/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.ArApCommonTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_010_ApFin2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("AP016_010_payBill_1", "AP016_010_payBill_2", "AP016_010_payBill_3", "AP016_010_payBill_4", "AP016_010_payBill_5", "AP016_010_payBill_6");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u6e90\u5355+\u8f6c\u4ed8\u5355\u5408\u5e76\u4e0b\u63a8\u4ed8\u6b3e,\u5f02\u5e01\u522b,\u8ba1\u5212\u884c;\u9700\u8981\u6269\u5c55\u4e1a\u52a1\u6d41\u652f\u6301\u5408\u5e76\uff09\u5b58\u5728bug,\u4e0b\u63a8\u4ed8\u6b3e\u5355\u540e\u53cd\u5199\u7684\u7269\u6599\u884c\u9501\u5b9a\u6709\u95ee\u9898")
    public void ApFinUnitTest_010_1() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, true, true, true, "AP016_010_apfin_1");
        long finBillId = finBill.getLong("id");
        long transBillId = this.produceAuditTransBill(finBill);
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        DynamicObject[] transBills = FinApBillTestHelper.remedyNoSameRateFinApData(new DynamicObject[]{transBill}, BigDecimal.valueOf(6.045));
        SaveServiceHelper.save((DynamicObject[])transBills);
        this.validateSrcFinBill_1(finBill, 0L, false);
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(9999L), "ap_finapbill", Arrays.asList(finBillId, transBillId), "C", "AP016_010_payBill_1", BigDecimal.valueOf(6.045));
        long payBillId = payBills[0].getLong("id");
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        this.validateSrcFinBill_1(finBill, payBillId, false);
        this.validateTransBill_1(transBill, payBillId, false);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (DynamicObject[])payBills, (OperateOption)option);
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBills[0].getLong("id"), (String)"cas_paybill");
        CasPayBillTestChecker.validateCasPayBillJournalData(payBill);
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        this.validateSrcFinBill_1(finBill, payBillId, true);
        this.validateTransBill_1(transBill, payBillId, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u7269\u6599\u884c\uff0c\u5355\u5f20\u5168\u989d\u672c\u5e01\u522b\u4e0b\u63a8\uff09")
    @Test
    public void ApFinUnitTest_010_2() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, false, true, "AP016_010_apfin_2");
        long finPk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finPk), "AP016_010_payBill_2");
        finBill = BusinessDataServiceHelper.loadSingle((Object)finPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateFinishApFin(finBill, true, false);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finPk}, new Long[]{payBills[0].getLong("id")}, false);
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBills[0].getLong("id"), (String)"cas_paybill");
        CasPayBillTestChecker.validateCasPayBillJournalData(payBill);
        OperateOption option = OperateOption.create();
        long capPayBillId = payBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{capPayBillId}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{capPayBillId}, (OperateOption)option);
        FinApBillTestChecker.validateFinApFullLockData(finPk);
        payBill = BusinessDataServiceHelper.loadSingle((Object)capPayBillId, (String)"cas_paybill");
        CasPayBillTestHelper.executeChargeback(new DynamicObject[]{payBill});
        finBill = BusinessDataServiceHelper.loadSingle((Object)finPk, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u7269\u6599\u884c\uff0c\u672c\u5e01\u6b63\u8d1f\u5206\u5f55,\u6e90\u5355\u548c\u8f6c\u4ed8\u5355\u5408\u5e76\u4e0b\u63a8\u4ed8\u6b3e\u5355;\u9700\u8981\u6269\u5c55\u4e1a\u52a1\u6d41\u652f\u6301\u5408\u5e76\uff09")
    public void ApFinUnitTest_010_3() {
        AP016_010_ApFin2PayTest.assertEquals((String)"\u6b63\u8d1f\u5206\u5f55\u95ee\u9898\uff0c\u5b58\u5728bug\uff0c\u5f85\u9700\u6c42\u786e\u5b9a\u540e\u5b8c\u5584\u6d4b\u8bd5\u7528\u4f8b", (boolean)true, (boolean)false);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u4eba\u6c11\u5e01\uff0c\u8de8\u671f\u53cd\u7ed3\u7b97\uff08\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\uff09\uff09")
    @Test
    public void ApFinUnitTest_010_4() {
        DynamicObject intertemporalOrg = BaseDataTestProvider.getIntertemporalOrg();
        DynamicObject finBill = this.createIntertemporalFin("AP016_010_apfin_4", intertemporalOrg);
        long finPk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finPk), null);
        ArApCommonTestHelper.setOrgIntertemporal(intertemporalOrg);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finPk}, new Long[]{payBills[0].getLong("id")}, false);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])settleRecords, (OperateOption)OperateOption.create());
        settleRecords = SettleRecordTestHelper.loadData(new Long[]{finPk}, new Long[]{payBills[0].getLong("id")}, false);
        AP016_010_ApFin2PayTest.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u5e94\u4e3a4\u6761\uff0c\u5305\u542b2\u6761\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u4eba\u6c11\u5e01\uff0c\u8de8\u671f\u53cd\u7ed3\u7b97\uff09")
    @Test
    public void ApFinUnitTest_010_5() {
        DynamicObject intertemporalOrg = BaseDataTestProvider.getIntertemporalOrg();
        DynamicObject finBill = this.createIntertemporalFin("AP016_010_apfin_5", intertemporalOrg);
        long finPk = finBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finPk), null);
        ArApCommonTestHelper.setOrgIntertemporal(intertemporalOrg);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)OperateOption.create());
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finPk}, new Long[]{payBills[0].getLong("id")}, false);
        AP016_010_ApFin2PayTest.assertEquals((String)"\u7ed3\u7b97\u8bb0\u5f55\u5e94\u4e3a4\u6761\uff0c\u5305\u542b2\u6761\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
    }

    private void validateSrcFinBill_1(DynamicObject finBill, long payBillId, boolean isPay) {
        AP016_010_ApFin2PayTest.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        if (isPay) {
            FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(27.5), BigDecimal.valueOf(166.2375), BigDecimal.valueOf(72.5), BigDecimal.valueOf(438.2625));
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBill.getLong("id")}, new Long[]{payBillId}, false);
        } else {
            FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(55L), BigDecimal.valueOf(332.475), BigDecimal.valueOf(45L), BigDecimal.valueOf(272.025));
        }
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailOne = (DynamicObject)detailEntry.get(0);
        DynamicObject detailTwo = (DynamicObject)detailEntry.get(1);
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject planOne = (DynamicObject)planEntity.get(0);
        DynamicObject planTwo = (DynamicObject)planEntity.get(1);
        if (payBillId == 0L) {
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailOne, BigDecimal.valueOf(15.0), BigDecimal.valueOf(55.0), BigDecimal.valueOf(31.5), BigDecimal.valueOf(190.4175), BigDecimal.valueOf(38.5), BigDecimal.valueOf(232.7325));
            FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailTwo, BigDecimal.valueOf(30.0), BigDecimal.ZERO, BigDecimal.valueOf(13.5), BigDecimal.valueOf(81.6075), BigDecimal.valueOf(16.5), BigDecimal.valueOf(99.7425));
            FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(45L), BigDecimal.valueOf(25L));
            FinApBillTestChecker.validateApFinPlanLockAmt(planTwo, BigDecimal.ZERO, BigDecimal.valueOf(30L));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planOne, BigDecimal.valueOf(45L), BigDecimal.valueOf(272.025), BigDecimal.valueOf(25L), BigDecimal.valueOf(151.125));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planTwo, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(181.35));
        } else if (!isPay) {
            FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(57.5), BigDecimal.valueOf(12.5));
            FinApBillTestChecker.validateApFinPlanLockAmt(planTwo, BigDecimal.valueOf(15.0), BigDecimal.valueOf(15.0));
        } else {
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailOne, BigDecimal.valueOf(50.75), BigDecimal.valueOf(306.7838), BigDecimal.valueOf(19.25), BigDecimal.valueOf(116.3662));
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailTwo, BigDecimal.valueOf(21.75), BigDecimal.valueOf(131.4787), BigDecimal.valueOf(8.25), BigDecimal.valueOf(49.8713));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planOne, BigDecimal.valueOf(57.5), BigDecimal.valueOf(347.5875), BigDecimal.valueOf(12.5), BigDecimal.valueOf(75.5625));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planTwo, BigDecimal.valueOf(15.0), BigDecimal.valueOf(90.675), BigDecimal.valueOf(15.0), BigDecimal.valueOf(90.675));
        }
    }

    private void validateTransBill_1(DynamicObject transBill, long payBillId, boolean isPay) {
        if (isPay) {
            AP016_010_ApFin2PayTest.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)transBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(transBill, BigDecimal.valueOf(22.5), BigDecimal.valueOf(136.0175), BigDecimal.valueOf(22.5), BigDecimal.valueOf(136.0125));
            SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{transBill.getLong("id")}, new Long[]{payBillId}, false);
        } else {
            AP016_010_ApFin2PayTest.assertEquals((String)"\u5e94\u4ed8\u5355\u8868\u5934\u7ed3\u7b97\u72b6\u6001\u5e94\u4e3a\u672a\u7ed3\u7b97", (String)"unsettle", (String)transBill.getString("settlestatus"));
            FinApBillTestChecker.validateApFinHeadSettleAmt(transBill, BigDecimal.valueOf(45L), BigDecimal.valueOf(272.03), BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DynamicObjectCollection detailEntry = transBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailOne = (DynamicObject)detailEntry.get(0);
        DynamicObject detailTwo = (DynamicObject)detailEntry.get(1);
        DynamicObjectCollection planEntity = transBill.getDynamicObjectCollection("planentity");
        DynamicObject planOne = (DynamicObject)planEntity.get(0);
        if (isPay) {
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailOne, BigDecimal.valueOf(7.5), BigDecimal.valueOf(45.3375), BigDecimal.valueOf(7.5), BigDecimal.valueOf(45.3425));
            FinApBillTestChecker.validateApFinDetailSettleAmt(detailTwo, BigDecimal.valueOf(15.0), BigDecimal.valueOf(90.675), BigDecimal.valueOf(15.0), BigDecimal.valueOf(90.675));
            FinApBillTestChecker.validateApFinPlanSettleAmt(planOne, BigDecimal.valueOf(22.5), BigDecimal.valueOf(136.0125), BigDecimal.valueOf(22.5), BigDecimal.valueOf(136.0175));
        } else {
            FinApBillTestChecker.validateApFinDetailLockAmt(detailOne, BigDecimal.valueOf(7.5), BigDecimal.valueOf(7.5));
            FinApBillTestChecker.validateApFinDetailLockAmt(detailTwo, BigDecimal.valueOf(15.0), BigDecimal.valueOf(15.0));
            FinApBillTestChecker.validateApFinPlanLockAmt(planOne, BigDecimal.valueOf(22.5), BigDecimal.valueOf(22.5));
        }
    }

    private long produceAuditTransBill(DynamicObject finBill) {
        FinApBillTestHelper.searchOneRowDataByBillNo(this, finBill.getString("billno"));
        FinApBillTestHelper.turnPayByRow(this);
        long transBillId = FinApBillTestHelper.getTransBillId(finBill.getLong("id"));
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        return transBillId;
    }

    private DynamicObject createIntertemporalFin(String billNo, DynamicObject org) {
        FinApBillDataVO headVO = FinApBillDataVO.New();
        headVO.setOrg(org).setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        List<FinApBillDataDetailVO> finApBillDataDetailVOS = FinApBillTestDataProvider.structureFinApDataDetailVO(true, false);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(headVO, finApBillDataDetailVOS);
    }
}

