/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP016_013_ApFin2Apply2Pay2WriteOffTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Arrays.asList("AP016_013_payapply_1", "AP016_013_payapply_2", "AP016_013_payapply_3", "AP016_013_payapply_4");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Arrays.asList("AP016_013_payBill_1", "AP016_013_payBill_2", "AP016_013_payBill_3", "AP016_013_payBill_4");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecords = Arrays.asList("AP016_013_apfin_1", "AP016_013_apfin_2", "AP016_013_apfin_3", "AP016_013_apfin_4");
        DeleteServiceHelper.delete((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecords)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u7533\u8bf7-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_013_1() {
        List<FinApBillDataDetailVO> detailVo = FinApBillTestDataProvider.structureFinApDataDetailVO(true, true);
        FinApBillDataVO headVo = FinApBillTestDataProvider.structureFinApHeadVo("AP016_013_apfin_1", false, true, false);
        DynamicObject finBill = FinApBillTestDataProvider.buildByPriceAndQuantity(headVo, detailVo);
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.fullPushPayApply("ap_finapbill", Collections.singletonList(finpk), "AP016_013_payapply_1");
        long applyBillId = applyBills[0].getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(applyBillId), "AP016_013_payBill_1");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpk);
        this.validateData(finpk, writeOffBill, applyBillId, payBills[0].getLong("id"), false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpk);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u7533\u8bf7-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff0c\u90e8\u5206\u4e0b\u63a8\uff09")
    public void ApFinUnitTest_013_2() {
        List<FinApBillDataDetailVO> detailVo = FinApBillTestDataProvider.structureFinApDataDetailVO(true, true);
        FinApBillDataVO headVo = FinApBillTestDataProvider.structureFinApHeadVo("AP016_013_apfin_2", false, true, false);
        DynamicObject finBill = FinApBillTestDataProvider.buildByPriceAndQuantity(headVo, detailVo);
        long finpk = finBill.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill(BigDecimal.valueOf(50L), "ap_finapbill", Collections.singletonList(finpk), "AP016_013_payapply_2");
        long applyBillId = applyBills[0].getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.ONE, "ap_payapply", Collections.singletonList(applyBillId), "AP016_013_payBill_2");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpk);
        this.validateData(finpk, writeOffBill, applyBillId, payBills[0].getLong("id"), false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpk);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u4ed8\u6b3e\u7533\u8bf7-\u4ed8\u6b3e\u5355 AND \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u591a\u5bf9\u4e00\u5168\u989d\u4e0b\u63a8\uff0c\u8ba1\u5212\u884c\uff0c\u4eba\u6c11\u5e01\uff09")
    @Test
    public void ApFinUnitTest_013_3() {
        DynamicObject finBillOne = FinApBillTestDataProvider.createFinApBill(true, true, false, true, "AP016_013_apfin_3");
        DynamicObject finBillTwo = FinApBillTestDataProvider.createFinApBill(true, false, false, true, "AP016_013_apfin_4");
        long finpkOne = finBillOne.getLong("id");
        long finpkTwo = finBillTwo.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.fullPushPayApply("ap_finapbill", Arrays.asList(finpkOne, finpkTwo), "AP016_013_payapply_3");
        long applyBillId = applyBills[0].getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(applyBillId), "AP016_013_payBill_3");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finpkOne);
        this.validateData(finpkOne, writeOffBill, applyBillId, payBills[0].getLong("id"), true);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        FinApBillTestChecker.validateInitialApFin(finpkOne);
    }

    private void validateData(long srcFinId, DynamicObject writeOffBill, long applyBillId, long payBillId, boolean isManyToOne) {
        FinApBillTestChecker.validateFinishApFin(srcFinId, true, true);
        long writerOffId = writeOffBill.getLong("id");
        FinApBillTestChecker.validateApFinVerifyRecordData(srcFinId, writerOffId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{srcFinId}, new Long[]{writerOffId}, false);
        Map<String, HashSet<Long>> targetBills = BOTPHelper.findTargetBills("ap_finapbill", srcFinId);
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u4e0e\u4ed8\u6b3e\u7533\u8bf7\u5355\u65ad\u6389BOTP\u5173\u7cfb", (boolean)false, (boolean)targetBills.containsKey("ap_payapply"));
        FinApBillTestChecker.validateFinishApFin(writeOffBill, true, true);
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)applyBillId, (String)"ap_payapply");
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u5df2\u5173\u95ed", (String)"D", (String)applyBill.getString("billstatus"));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{srcFinId}, new Long[]{payBillId}, false);
        AP016_013_ApFin2Apply2Pay2WriteOffTest.assertEquals((String)"\u6e90\u8d22\u52a1\u5e94\u4ed8\u5355\u548c\u4ed8\u6b3e\u5355\u7684\u7ed3\u7b97\u8bb0\u5f55\u5e94\u8be5\u4e3a4\u6761", (boolean)true, (settleRecords.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(settleRecords);
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        if (isManyToOne) {
            this.validateCasPayBill(payBill);
        } else {
            CasPayBillTestChecker.validateInitialCasPayBill(payBill);
        }
    }

    private void validateCasPayBill(DynamicObject casPayBill) {
        DynamicObjectCollection detailRows = casPayBill.getDynamicObjectCollection("entry");
        DynamicObject detail = (DynamicObject)detailRows.get(0);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.ZERO, BigDecimal.valueOf(70L));
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
        detail = (DynamicObject)detailRows.get(1);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.ZERO, BigDecimal.valueOf(30L));
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        detail = (DynamicObject)detailRows.get(2);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.valueOf(60L), BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.valueOf(60L), BigDecimal.valueOf(60L), BigDecimal.ZERO, BigDecimal.ZERO);
        detail = (DynamicObject)detailRows.get(3);
        CasPayBillTestChecker.validateCasPayBillDetailRefundAmt(detail, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, BigDecimal.valueOf(40L), BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

