/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AP016_020_ApFin2AdjustThenApFin2WriteOff
extends AbstractJUnitTestPlugIn {
    SimulatorTestHelper util = new SimulatorTestHelper(this);

    public void initData() {
        super.initData();
        List<String> deleteFinAps = Arrays.asList("AP016_020_adjust_1", "AP016_020_adjust_2", "AP016_020_adjust_3");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8c03\u6574 Then \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u7f8e\u5143\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, true, true, "AP016_020_apfin_1");
        long finBillId = finBill.getLong("id");
        long adjustBillId = this.adjustBill("AP016_020_apfin_1", "AP016_020_adjust_1");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finBillId);
        long writeOffBillId = writeOffBill.getLong("id");
        this.validateData(finBillId, adjustBillId, writeOffBillId, false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_020_ApFin2AdjustThenApFin2WriteOff.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8c03\u6574 Then \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_002() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(true, false, true, true, "AP016_020_apfin_2");
        long finBillId = finBill.getLong("id");
        long adjustBillId = this.adjustBill("AP016_020_apfin_2", "AP016_020_adjust_2");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finBillId);
        long writeOffBillId = writeOffBill.getLong("id");
        this.validateData(finBillId, adjustBillId, writeOffBillId, false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_020_ApFin2AdjustThenApFin2WriteOff.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8-\u8c03\u6574 Then \u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\u6570\u636e,\u751f\u6210\u51ed\u8bc1\uff09")
    @Test
    public void ApFinUnitTest_003() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill(false, true, true, true, "AP016_020_apfin_3");
        long finBillId = finBill.getLong("id");
        long adjustBillId = this.adjustBill("AP016_020_apfin_3", "AP016_020_adjust_3");
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finBillId}, new Long[]{adjustBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finBillId);
        long writeOffBillId = writeOffBill.getLong("id");
        this.validateData(finBillId, adjustBillId, writeOffBillId, false);
        boolean isExists = SettleRecordTestHelper.existsWriteOff(new Long[]{finBillId}, new Long[]{adjustBillId}, false);
        AP016_020_ApFin2AdjustThenApFin2WriteOff.assertEquals((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\u672a\u751f\u6210\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u3002", (boolean)true, (boolean)isExists);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBill.getLong("id")}, (OperateOption)OperateOption.create());
        AP016_020_ApFin2AdjustThenApFin2WriteOff.assertEquals((boolean)true, (boolean)true);
    }

    private void validateData(long finBillId, long adjustBillId, long writeOffBillId, boolean isRedWriteOff) {
        FinApBillTestChecker.validateFinishApFin(finBillId, true, true);
        FinApBillTestChecker.validateInitialApFin(adjustBillId);
        FinApBillTestChecker.validateFinishApFin(writeOffBillId, true, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBillId}, new Long[]{writeOffBillId}, false);
        FinApBillTestChecker.validateApFinVerifyRecordData(finBillId, writeOffBillId);
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finBillId}, new Long[]{adjustBillId}, false);
        AP016_020_ApFin2AdjustThenApFin2WriteOff.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0e\u8c03\u6574\u5355\u7ed3\u7b97\u8bb0\u5f55\u4e3a4\u6761", (boolean)true, (records.length == 4 ? 1 : 0) != 0);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBillId}, new Long[]{adjustBillId}, false);
    }

    private long adjustBill(String sourceBillno, String adjustBillno) {
        FinApBillTestHelper.searchOneRowDataByBillNo(this, sourceBillno);
        IFormView adjustView = this.util.clickBarItemReturnChildView(this.getView(), "toolbarap", "tbladjust", "billmodify");
        IDataModel model = adjustView.getModel();
        model.setValue("expenseitem", (Object)BaseDataTestProvider.getExpenseItem(), 0);
        model.setValue("expenseitem", (Object)BaseDataTestProvider.getExpenseItem(), 1);
        model.setValue("adjusttype", (Object)"adjustinv");
        adjustView.invokeOperation("submit");
        long adjustBillId = (Long)model.getDataEntity().getPkValue();
        DynamicObject adjustBill = BusinessDataServiceHelper.loadSingle((Object)adjustBillId, (String)"ap_finapbill");
        adjustBill.set("billno", (Object)adjustBillno);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
        adjustView.close();
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Object[]{adjustBillId}, (OperateOption)OperateOption.create());
        return adjustBillId;
    }
}

