/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_003_AdjustFinArTest
extends FinBillBaseTest {
    private long finArAdjustBillId;
    private long finArAdjustBillId2;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header.setBillNo("AR_018_003-TEST");
        DynamicObject finArBill = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.finArBillId = finArBill.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u4e0b\u63a8\u6b63\u6570\u8c03\u6574\u5355\u6821\u9a8c")
    @Test
    public void positiveTest() throws InterruptedException {
        this.finArAdjustBillId = this.pushAdjust(new BigDecimal(400), new BigDecimal(400));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, true);
        this.assetInitStatus(this.finArBillId);
        Thread.sleep(5000L);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u4e0b\u63a8\u6b63\u6570\u8c03\u6574\u5355\u5220\u9664\u6821\u9a8c")
    @Test
    public void positiveDeleteTest() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId);
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, false);
        this.assetInitStatus(this.finArBillId);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4e0b\u63a8\u8d1f\u6570\u8d85\u989d\u8c03\u6574\u5355\u6821\u9a8c")
    @Test
    public void negativeTest() throws InterruptedException {
        this.finArAdjustBillId = this.pushAdjust(new BigDecimal(-2000), new BigDecimal(-2000));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, true);
        this.assetInitStatus(this.finArBillId);
        Thread.sleep(5000L);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u4e0b\u63a8\u8d1f\u6570\u8c03\u6574\u5355\u5220\u9664\u6821\u9a8c")
    @Test
    public void negativeDeleteTest() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId);
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, false);
        this.assetInitStatus(this.finArBillId);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u7269\u6599\u884c\u7ed3\u7b97-\u90e8\u5206\u4e0b\u63a8\u8c03\u6574\u53551\u6821\u9a8c")
    @Test
    public void partPushTest1() {
        this.finArAdjustBillId = this.pushAdjust(new BigDecimal(-200), new BigDecimal(-200));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.finArBillId}, new Long[]{this.finArAdjustBillId}, true);
        FinArBillTestHelper.checkFinJournal(this.finArAdjustBillId);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(1600L), BigDecimal.valueOf(1600L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(600L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=6)
    @DisplayName(value="\u7269\u6599\u884c\u7ed3\u7b97-\u5269\u4f59\u90e8\u5206\u4e0b\u63a8\u8c03\u6574\u53552\u6821\u9a8c")
    @Test
    public void partPushTest2() {
        this.finArAdjustBillId2 = this.pushAdjust(new BigDecimal(-800), new BigDecimal(-800));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId2, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.finArBillId}, new Long[]{this.finArAdjustBillId2}, true);
        FinArBillTestHelper.checkFinJournal(this.finArAdjustBillId2);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(2000L), BigDecimal.valueOf(2000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u90e8\u5206\u4e0b\u63a8\u8c03\u6574\u53551\u5220\u9664\u6821\u9a8c")
    @Test
    public void partPushDeleteTest1() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId);
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, false);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1600L), BigDecimal.valueOf(1600L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(600L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
    }

    @TestMethod(value=8)
    @DisplayName(value="\u90e8\u5206\u4e0b\u63a8\u8c03\u6574\u53552\u5220\u9664\u6821\u9a8c")
    @Test
    public void partPushDeleteTest2() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId2);
        this.assetInitStatus(this.finArBillId);
    }

    public void partPushTest3() {
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_003-TEST-PLAN");
        DynamicObject finArBill = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.finArBillId = finArBill.getLong("id");
        this.finArAdjustBillId = this.pushAdjust(new BigDecimal(-200), new BigDecimal(-400));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.finArBillId}, new Long[]{this.finArAdjustBillId}, true);
        FinArBillTestHelper.checkFinJournal(this.finArAdjustBillId);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(600L), BigDecimal.valueOf(600L), BigDecimal.valueOf(1400L), BigDecimal.valueOf(1400L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(300L), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L), BigDecimal.valueOf(700L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(300L), BigDecimal.valueOf(300L), BigDecimal.valueOf(700L), BigDecimal.valueOf(700L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(600L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }

    public void partPushTest4() {
        this.finArAdjustBillId2 = this.pushAdjust(new BigDecimal(-800), new BigDecimal(-600));
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId2, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.finArBillId}, new Long[]{this.finArAdjustBillId2}, true);
        FinArBillTestHelper.checkFinJournal(this.finArAdjustBillId);
        this.assetFinishedStatus(this.finArBillId);
    }

    public void partPushDeleteTest3() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId);
        this.assertSettleRecordExist(this.finArBillId, this.finArAdjustBillId, false);
        FinArBillTestHelper.checkJournalExists(this.finArAdjustBillId, false);
        DynamicObject finBill = this.getFinBill(this.finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1400L), BigDecimal.valueOf(1400L), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(700L), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L), BigDecimal.valueOf(300L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(700L), BigDecimal.valueOf(700L), BigDecimal.valueOf(300L), BigDecimal.valueOf(300L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(600L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public void partPushDeleteTest4() {
        this.deleteBill("ar_finarbill", this.finArAdjustBillId2);
        this.assetInitStatus(this.finArBillId);
    }

    private long pushAdjust(BigDecimal entryAmt1, BigDecimal entryAmt2) {
        List<DynamicObject> adjustBillList = BOTPHelper.push("ar_finarbill", "ar_finarbill", "646772185041512448", Collections.singletonList(this.finArBillId));
        KDAssert.assertEquals((int)1, (int)adjustBillList.size());
        DynamicObject adjustBill = FinArBillTestHelper.setEntryAmount(adjustBillList.get(0), new BigDecimal[]{entryAmt1, entryAmt2});
        adjustBillList.get(0).set("adjusttype", (Object)"adjustinv");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{adjustBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Object[]{adjustBill.getPkValue()}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{adjustBill.getPkValue()}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        return adjustBill.getLong("id");
    }

    private void assertSettleRecordExist(long mainBillId, long assetBillId, boolean expected) {
        boolean result = SettleRecordTestHelper.exists(new Long[]{mainBillId}, new Long[]{assetBillId}, true);
        if (expected) {
            AR018_003_AdjustFinArTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5b58\u5728", (boolean)result);
        } else {
            AR018_003_AdjustFinArTest.assertFalse((String)"\u7ed3\u7b97\u8bb0\u5f55\u5b58\u5728", (boolean)result);
        }
    }

    @Override
    protected void deleteBill(String entityName, long billId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])new Object[]{billId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])new Object[]{billId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
    }
}

