/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR018_006_FinArToApTest
extends AbstractJUnitTestPlugIn {
    private static String finArBillNo_1 = "AR018_006_FinArBillNo_01";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", finArBillNo_1);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536---\u8d22\u52a1\u5e94\u4ed8---\u6e05\u7406")
    @Test
    public void case1() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject finarBillInfo = this.createFinArBillArToAp(finArBillNo_1, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), false, true);
        Long finArBillId = finarBillInfo.getLong("id");
        idList.add(finArBillId);
        DynamicObject apBillInfo = this.getApBill(finArBillId);
        this.finArPushRecBill_1(finArBillId, idList);
        this.finArPushPayBill_1(apBillInfo);
        this.finArPushLiquidation(finArBillId, apBillInfo.getLong("id"), idList);
    }

    public void finArPushLiquidation(Long finArBillId, Long finApBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_liquidation", "1736302125647939584", idList);
        DynamicObject liquidationInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)planEntryCol.get(0)).getLong("id"), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        Long[] ids = new Long[]{finApBillId};
        Map<Long, Set<Long>> map = BOTPHelper.findDirtTargetBillIds("ap_finapbill", ids, "ap_liquidation", "ap_liquidation");
        Set<Long> apLiquidationIds = map.get(finApBillId);
        boolean hasApLiquidationBill = apLiquidationIds.size() == 1;
        AR018_006_FinArToApTest.assertEquals((String)("\u5e94\u6536\u5355[" + finArBillNo_1 + "]\u6e05\u7406\uff0c\u4e0b\u6e38\u5e94\u4ed8\u5355\u6ca1\u6709\u534f\u540c\u751f\u6210\u6e05\u7406\u5355\u3002"), (boolean)true, (boolean)hasApLiquidationBill);
        Iterator<Long> it = apLiquidationIds.iterator();
        Long apLiquidationId = 0L;
        while (it.hasNext()) {
            apLiquidationId = it.next();
        }
        DynamicObject apLiquidationInfo = BusinessDataServiceHelper.loadSingle((Object)apLiquidationId, (String)"ap_liquidation");
        BigDecimal liquidationamt = apLiquidationInfo.getBigDecimal("liquidationamt");
        KDAssert.assertEquals((String)"\u534f\u540c\u751f\u6210\u7684\u5e94\u4ed8\u6708\u672b\u6e05\u7406\u5355\u6e05\u7406\u91d1\u989d\u4e0d\u51c6\u786e", (boolean)false, (liquidationamt.compareTo(BigDecimal.valueOf(300L)) != 0 ? 1 : 0) != 0);
    }

    public void finArPushPayBill_1(DynamicObject apBillInfo) {
        DynamicObjectCollection entry;
        List<DynamicObject> list;
        ArrayList<Long> apIdList = new ArrayList<Long>(1);
        apIdList.add(apBillInfo.getLong("id"));
        DynamicObject payBillInfo = null;
        Long orgId = apBillInfo.getLong("org.id");
        int apSettleParam = ArApHelper.getApSettleParam(orgId);
        if (apSettleParam == 1) {
            list = BOTPHelper.push("ap_finapbill", "cas_paybill", "327194217749200896", apIdList);
            payBillInfo = list.get(0);
            entry = payBillInfo.getDynamicObjectCollection("entry");
            CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(200L));
            CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(300L));
            payBillInfo.set("actpayamt", (Object)BigDecimal.valueOf(500L));
            payBillInfo.set("localamt", (Object)BigDecimal.valueOf(500L));
        } else {
            list = BOTPHelper.push("ap_finapbill", "cas_paybill", "732372007164856320", apIdList);
            payBillInfo = list.get(0);
            entry = payBillInfo.getDynamicObjectCollection("entry");
            CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(500L));
            payBillInfo.set("actpayamt", (Object)BigDecimal.valueOf(500L));
            payBillInfo.set("localamt", (Object)BigDecimal.valueOf(500L));
        }
        DynamicObject settleTypeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JSFS04")});
        payBillInfo.set("settletype", (Object)settleTypeInfo);
        payBillInfo.set("itempayeetype", (Object)"bd_supplier");
        payBillInfo.set("itempayee", (Object)BaseDataTestProvider.getCoordinationSupplier());
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u5e94\u6536\u5355\u4e0b\u63a8\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        payBillInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBillInfo});
        OperationResult receivingrecResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + receivingrecResult.getMessage()), (boolean)true, (boolean)receivingrecResult.isSuccess());
    }

    public void finArPushRecBill_1(Long finArBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "cas_recbill", "729653820493174784", idList);
        DynamicObject recBillInfo = list.get(0);
        DynamicObjectCollection entry = recBillInfo.getDynamicObjectCollection("entry");
        CasRecTestHelper.setRecEntryAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(400L));
        recBillInfo.set("actrecamt", (Object)BigDecimal.valueOf(400L));
        recBillInfo.set("localamt", (Object)BigDecimal.valueOf(400L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u5e94\u6536\u5355\u4e0b\u63a8\u6536\u6b3e\u5355\uff0c\u6536\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        recBillInfo = BusinessDataServiceHelper.loadSingle((Object)recBillInfo.getLong("id"), (String)"cas_recbill");
        recBillInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBillInfo});
        OperationResult receivingrecResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + receivingrecResult.getMessage()), (boolean)true, (boolean)receivingrecResult.isSuccess());
    }

    public DynamicObject getApBill(Long finArBillId) {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Long[] ids = new Long[]{finArBillId};
        Map<Long, Set<Long>> map = BOTPHelper.findDirtTargetBillIds("ar_finarbill", ids, "ap_finapbill", "ap_finapbill");
        Set<Long> apIds = map.get(finArBillId);
        boolean hasApBill = apIds.size() == 1;
        AR018_006_FinArToApTest.assertEquals((String)("\u5e94\u6536\u5355[" + finArBillNo_1 + "]\u5ba1\u6838\u6ca1\u6709\u534f\u540c\u751f\u6210\u5e94\u4ed8\u5355\u3002"), (boolean)true, (boolean)hasApBill);
        Iterator<Long> it = apIds.iterator();
        Long apBillId = 0L;
        while (it.hasNext()) {
            apBillId = it.next();
        }
        DynamicObject apBillInfo = BusinessDataServiceHelper.loadSingle((Object)apBillId, (String)"ap_finapbill");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (DynamicObject[])new DynamicObject[]{apBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u8d22\u52a1\u5e94\u4ed8\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (DynamicObject[])new DynamicObject[]{apBillInfo}, (OperateOption)OperateOption.create());
        AR018_006_FinArToApTest.assertEquals((String)("\u8d22\u52a1\u5e94\u4ed8\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        apBillInfo = BusinessDataServiceHelper.loadSingle((Object)apBillId, (String)"ap_finapbill");
        return apBillInfo;
    }

    public DynamicObject createFinArBillArToAp(String billNo, BigDecimal quantity_1, BigDecimal price_1, BigDecimal quantity_2, BigDecimal price_2, boolean isDetailSettle, boolean isLocal) {
        ArrayList<FinArBillDataDetailVO> finArBillDataDetailV0List = new ArrayList<FinArBillDataDetailVO>();
        FinArBillDataDetailVO finArBillDataDetailVO_1 = new FinArBillDataDetailVO();
        finArBillDataDetailVO_1.setSeq(1);
        finArBillDataDetailVO_1.setPrice(price_1);
        finArBillDataDetailVO_1.setQuantity(quantity_1);
        finArBillDataDetailV0List.add(finArBillDataDetailVO_1);
        FinArBillDataDetailVO finArBillDataDetailVO_2 = new FinArBillDataDetailVO();
        finArBillDataDetailVO_2.setSeq(2);
        finArBillDataDetailVO_2.setPrice(price_2);
        finArBillDataDetailVO_2.setQuantity(quantity_2);
        finArBillDataDetailV0List.add(finArBillDataDetailVO_2);
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQtyArToAp(billNo, finArBillDataDetailV0List, isDetailSettle, isLocal);
        return finArBill;
    }
}

