/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR018_008_CasRecFinArTest
extends FinBillBaseTest {
    private long casRecBillId;
    private long casRecBillId2;
    private long cacheFinArBillId1;
    private long cacheFinArBillId2;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header.setBillNo("AR_018_008-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(1L));
        header1.setOrg(BaseDataTestProvider.getDetailInitOrg());
        header1.setBillNo("AR_018_008-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u7269\u6599\u884c\u4e0b\u63a8-\u90e8\u5206\u6536\u6b3e\u53551\u6821\u9a8c")
    @Test
    public void partPushSaveTest1() {
        this.casRecBillId = this.pushAndSaveCas(1, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=2)
    @DisplayName(value="\u7269\u6599\u884c\u4e0b\u63a8-\u90e8\u5206\u6536\u6b3e\u53552\u6821\u9a8c")
    @Test
    public void partPushSaveTest2() {
        this.casRecBillId2 = this.pushAndSaveCas(1, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53551\u786e\u8ba4\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void partPushCasTest1() throws InterruptedException {
        this.auditCas(this.casRecBillId);
        this.receive(this.casRecBillId);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53552\u786e\u8ba4\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void partPushCasTest2() throws InterruptedException {
        this.auditCas(this.casRecBillId2);
        this.receive(this.casRecBillId2);
        Thread.sleep(10000L);
        this.assetFinishedStatus(this.cacheFinArBillId1);
        this.assetFinishedStatus(this.cacheFinArBillId2);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId2}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId2}, true);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53551\u53d6\u6d88\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void partPushCancelTest1() throws InterruptedException {
        this.cancel(this.casRecBillId);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53552\u53d6\u6d88\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void partPushCancelTest2() throws InterruptedException {
        this.cancel(this.casRecBillId2);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(2000L));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId2}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId2}, true);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53551\u5220\u9664\u6821\u9a8c")
    @Test
    public void partPushDeleteTest1() {
        this.deleteBill("cas_recbill", this.casRecBillId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=8)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53552\u5220\u9664\u6821\u9a8c")
    @Test
    public void partPushDeleteTest2() {
        this.deleteBill("cas_recbill", this.casRecBillId2);
        this.assetInitStatus(this.cacheFinArBillId1);
        this.assetInitStatus(this.cacheFinArBillId2);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u8ba1\u5212\u884c\u4e0b\u63a8-\u5f02\u5e01\u522b\u90e8\u5206\u6536\u6b3e\u53553\u4fdd\u5b58\u6821\u9a8c")
    @Test
    public void planPartPushSaveTest3() {
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(6.3725));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_008-USD-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(6.3725));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("R_018_008-USD-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
        this.casRecBillId = this.pushAndSaveCas(2, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
    }

    @TestMethod(value=10)
    @DisplayName(value="\u8ba1\u5212\u884c\u4e0b\u63a8-\u5f02\u5e01\u522b\u90e8\u5206\u6536\u6b3e\u53554\u4fdd\u5b58\u6821\u9a8c")
    @Test
    public void planPartPushSaveTest4() {
        this.casRecBillId2 = this.pushAndSaveCas(2, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53553\u786e\u8ba4\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void planPartPushCasTest3() throws InterruptedException {
        this.auditCas(this.casRecBillId);
        this.receive(this.casRecBillId);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
    }

    @TestMethod(value=12)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53554\u786e\u8ba4\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void planPartPushCasTest4() throws InterruptedException {
        this.auditCas(this.casRecBillId2);
        this.receive(this.casRecBillId2);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId2}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId2}, true);
    }

    @TestMethod(value=13)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53553\u53d6\u6d88\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void planPartPushCancelTest3() throws InterruptedException {
        this.cancel(this.casRecBillId);
        Thread.sleep(10000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5), BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25), BigDecimal.valueOf(500L), BigDecimal.valueOf(3186.25));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
    }

    @TestMethod(value=14)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53554\u53d6\u6d88\u6536\u6b3e\u6821\u9a8c")
    @Test
    public void planPartPushCancelTest4() throws InterruptedException {
        this.cancel(this.casRecBillId2);
        Thread.sleep(5000L);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(2000L), BigDecimal.valueOf(12745.0));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(1000L), BigDecimal.valueOf(6372.5));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.casRecBillId2}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.casRecBillId2}, true);
    }

    @TestMethod(value=15)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53553\u5220\u9664\u6821\u9a8c")
    @Test
    public void planPartPushDeleteTest3() {
        this.deleteBill("cas_recbill", this.casRecBillId);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L));
    }

    @TestMethod(value=16)
    @DisplayName(value="\u90e8\u5206\u6536\u6b3e\u53552\u5220\u9664\u6821\u9a8c")
    @Test
    public void planPartPushDeleteTest4() {
        this.deleteBill("cas_recbill", this.casRecBillId2);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=17)
    @DisplayName(value="\u5168\u90e8\u4e0b\u63a8\u6536\u6b3e\u5355-\u624b\u5de5\u53cd\u7ed3\u7b97")
    @Test
    public void fullPushCasRecSettle() {
        this.casRecBillId = this.pushAndSaveCas(2, new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        this.auditCas(this.casRecBillId);
        this.receive(this.casRecBillId);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{this.cacheFinArBillId1, this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
        AR018_008_CasRecFinArTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (settleRecords.length > 0 ? 1 : 0) != 0);
        for (DynamicObject settleRecord2 : settleRecords) {
            settleRecord2.set("isvoucher", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        Object[] settleRecordIds = Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).toArray();
        OperationResult result = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(1000L));
        DynamicObject[] settleRecords1 = SettleRecordTestHelper.loadData(new Long[]{this.cacheFinArBillId1, this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
        AR018_008_CasRecFinArTest.assertTrue((String)"\u672a\u751f\u6210\u5bf9\u5e94\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55", (settleRecords1.length > settleRecords.length ? 1 : 0) != 0);
    }

    @TestMethod(value=18)
    @DisplayName(value="\u6536\u6b3e\u53555\u5220\u9664")
    @Test
    public void casRec5Delete() {
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{this.cacheFinArBillId1, this.cacheFinArBillId2}, new Long[]{this.casRecBillId}, true);
        AR018_008_CasRecFinArTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (settleRecords.length > 0 ? 1 : 0) != 0);
        for (DynamicObject settleRecord : settleRecords) {
            settleRecord.set("isvoucher", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        this.cancel(this.casRecBillId);
        this.deleteBill("cas_recbill", this.casRecBillId);
    }

    private long pushAndSaveCas(int settleModel, BigDecimal[] entryAmtArray, BigDecimal[] entryDisCountArray, BigDecimal[] entryChargeArray) {
        String ruleId = settleModel == 1 ? "440257677843523584" : "729653820493174784";
        List<DynamicObject> casRecBillList = BOTPHelper.push("ar_finarbill", "cas_recbill", ruleId, Arrays.asList(this.cacheFinArBillId1, this.cacheFinArBillId2));
        KDAssert.assertTrue((casRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject casRecBill = casRecBillList.get(0);
        casRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        CasRecTestHelper.setEntryAmt(casRecBill, entryAmtArray, entryDisCountArray, entryChargeArray);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        return casRecBill.getLong("id");
    }

    private void auditCas(long casRecBillId) {
        DynamicObject casRecBill = BusinessDataServiceHelper.loadSingle((Object)casRecBillId, (String)"cas_recbill");
        casRecBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
    }

    private void receive(long casRecBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])new Object[]{casRecBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private void cancel(long casRecBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Object[]{casRecBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }
}

