/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AR018_013_FinArRefundTest
extends AbstractJUnitTestPlugIn {
    private String finArBillNo = "AR018_013_FinArBill_01";
    private String payBillNo = "AR018_013_PayBillNo_01";
    private String recBillNo = "AR018_013_RecBillNo_01";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", this.finArBillNo);
        FinArBillTestHelper.deleteBill("cas_paybill", this.payBillNo);
        FinArBillTestHelper.deleteBill("cas_recbill", this.recBillNo);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355-\u4ed8\u6b3e\u5355-\u9000\u6b3e\u9000\u7968\u5355\u5143\u6d4b\u8bd5")
    @Test
    public void case1() {
        ArrayList<Long> finArBillIds = new ArrayList<Long>(1);
        DynamicObject finArBillInfo = FinArBillTestHelper.createFinArBill(this.finArBillNo, BigDecimal.valueOf(-1L), BigDecimal.valueOf(100L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId = finArBillInfo.getLong("id");
        finArBillIds.add(finArBillId);
        List<DynamicObject> payBillList = BOTPHelper.push("ar_finarbill", "cas_paybill", "757805466909715456", finArBillIds);
        DynamicObject payBillInfo = payBillList.get(0);
        payBillInfo.set("billno", (Object)this.payBillNo);
        OperationResult saveResult_1 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_013_FinArRefundTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult_1.getMessage()), (boolean)true, (boolean)saveResult_1.isSuccess());
        payBillInfo = BusinessDataServiceHelper.loadSingle((Object)payBillInfo.getLong("id"), (String)"cas_paybill");
        payBillInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBillInfo});
        finArBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.checkArAmt(finArBillInfo, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-500L), BigDecimal.valueOf(-500L));
        DynamicObjectCollection billDetailEntryCol_1 = finArBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)billDetailEntryCol_1.get(0), BigDecimal.valueOf(-100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)billDetailEntryCol_1.get(1), BigDecimal.valueOf(-400L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection billPlanEntryCol_1 = finArBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)billPlanEntryCol_1.get(0), BigDecimal.valueOf(-500L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-500L), BigDecimal.valueOf(-500L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_013_FinArRefundTest.assertEquals((String)("\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        finArBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.checkArAmt(finArBillInfo, BigDecimal.valueOf(-500L), BigDecimal.valueOf(-500L), BigDecimal.ZERO, BigDecimal.ZERO);
        billDetailEntryCol_1 = finArBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)billDetailEntryCol_1.get(0), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.checkSettleAmt(false, true, finArBillIds, finArBillId, ((DynamicObject)billDetailEntryCol_1.get(0)).getLong("id"), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)billDetailEntryCol_1.get(1), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.checkSettleAmt(false, true, finArBillIds, finArBillId, ((DynamicObject)billDetailEntryCol_1.get(1)).getLong("id"), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        billPlanEntryCol_1 = finArBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)billPlanEntryCol_1.get(0), BigDecimal.valueOf(-500L), BigDecimal.valueOf(-500L), BigDecimal.valueOf(-500L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        Long payBillId_1 = payBillInfo.getLong("id");
        DynamicObjectCollection entryCol_1 = payBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkSettleAmt(false, false, finArBillIds, payBillId_1, ((DynamicObject)entryCol_1.get(0)).getLong("id"), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L));
        FinArBillTestChecker.checkSettleAmt(false, false, finArBillIds, payBillId_1, ((DynamicObject)entryCol_1.get(1)).getLong("id"), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        CasRecBillDataVO casRecBillHeader = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(500L));
        ArrayList<CasRecBillDataDetailVO> entries = new ArrayList<CasRecBillDataDetailVO>(16);
        CasRecBillDataDetailVO detailVO = new CasRecBillDataDetailVO();
        detailVO.setPriceTaxTotal(BigDecimal.valueOf(500L));
        entries.add(detailVO);
        DynamicObject casRecBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(casRecBillHeader, entries);
        casRecBill.set("payertype", (Object)"bd_customer");
        casRecBill.set("customerf7", (Object)BaseDataTestProvider.getCustomer());
        casRecBill.set("billno", (Object)this.recBillNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        Long casRecBillId = casRecBill.getLong("id");
        SimulatorTestHelper util = new SimulatorTestHelper(this);
        this.getModel().setValue("id", (Object)payBillInfo.getLong("id"), 0);
        this.getModel().setValue("targetbilltype", (Object)"cas_paybill", 0);
        this.getModel().setValue("sourcebilltype", (Object)"ap_payapply", 0);
        this.getModel().setValue("billtype", (Object)"cas_paybill", 0);
        this.getView().getFormShowParameter().setCustomParam("billId", (Object)casRecBillId);
        String selectOne = "[{\"key\":\"entryentity\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"entryentity\":{\"fieldKey\":\"payee\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]}]";
        util.invokeAction(selectOne);
        try {
            this.getView().invokeOperation("returnmoney");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SettleRecordTestChecker.checkNotExist(new Long[]{finArBillId}, new Long[]{payBillInfo.getLong("id")}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{casRecBillId}, new Long[]{payBillInfo.getLong("id")}, true);
    }
}

