/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.ArInvoiceBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.ArInvoiceBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR018_018_2_FinArToArInvoiceTest
extends AbstractJUnitTestPlugIn {
    private static String finArBillNo_1 = "AR018_018_2_FinArNo_01";
    private static String finArBillNo_2 = "AR018_018_2_FinArNo_02";
    private static String arInvoiceBillNo_1 = "AR018_018_2_ArInvoice_01";
    private static String arInvoiceBillNo_2 = "AR018_018_2_ArInvoice_02";
    private static String red_arInvoiceBillNo_1 = "Red_AR018_018_2_ArInv_01";
    private static String red_arInvoiceBillNo_2 = "Red_AR018_018_2_ArInv_02";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", finArBillNo_1, finArBillNo_2);
        FinArBillTestHelper.deleteBill("ar_invoice", arInvoiceBillNo_1, arInvoiceBillNo_2, red_arInvoiceBillNo_1, red_arInvoiceBillNo_2);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u4e0b\u63a8\u5f00\u7968\u5355\u5355\u5143\u6d4b\u8bd5\uff08\u6570\u91cf\u57fa\u51c6\uff09")
    @Test
    public void case1() {
        ArrayList<Long> finarBillIds = new ArrayList<Long>();
        DynamicObject[] invoices = new DynamicObject[2];
        DynamicObject[] red_invoices = new DynamicObject[2];
        DynamicObject arBill_1 = FinArBillTestHelper.createFinArBill(finArBillNo_1, BigDecimal.valueOf(3L), BigDecimal.valueOf(100L), BigDecimal.valueOf(3L), BigDecimal.valueOf(133L), true, true);
        Long arBillId_1 = arBill_1.getLong("id");
        finarBillIds.add(arBillId_1);
        DynamicObject arBill_2 = FinArBillTestHelper.createFinArBill(finArBillNo_2, BigDecimal.valueOf(5L), BigDecimal.valueOf(1543L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4132L), true, true);
        Long arBillId_2 = arBill_2.getLong("id");
        finarBillIds.add(arBillId_2);
        AR018_018_2_FinArToArInvoiceTest.pushInvoice1(finarBillIds, invoices);
        AR018_018_2_FinArToArInvoiceTest.checkAmt_1(arBillId_1, arBillId_2);
        AR018_018_2_FinArToArInvoiceTest.invoiceWriteOff_1(invoices, red_invoices);
        AR018_018_2_FinArToArInvoiceTest.checkRedAmt_1(arBillId_1, arBillId_2, invoices);
        AR018_018_2_FinArToArInvoiceTest.invoiceWriteOff_2(invoices, red_invoices);
        AR018_018_2_FinArToArInvoiceTest.checkRedAmt_2(arBillId_1, arBillId_2, invoices);
        AR018_018_2_FinArToArInvoiceTest.deleteRedInvoice(arBillId_1, arBillId_2, red_invoices);
        AR018_018_2_FinArToArInvoiceTest.invalidInovice(arBillId_1, arBillId_2, invoices);
        AR018_018_2_FinArToArInvoiceTest.unInvalidInvoice(arBillId_1, arBillId_2, invoices);
        AR018_018_2_FinArToArInvoiceTest.pushInvoice2(finarBillIds, invoices);
        AR018_018_2_FinArToArInvoiceTest.checkAmt_2(arBillId_1, arBillId_2);
        this.deleteInvoice(arBillId_1, arBillId_2, invoices);
    }

    public static void pushInvoice1(List<Long> finarBillIds, DynamicObject[] invoices) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_invoice", "762791232819726336", finarBillIds);
        DynamicObject invInfo = list.get(0);
        invInfo.set("billno", (Object)arInvoiceBillNo_1);
        DynamicObjectCollection invEntryCol = invInfo.getDynamicObjectCollection("entry");
        DynamicObject invEntryInfo0 = (DynamicObject)invEntryCol.get(0);
        DynamicObject invEntryInfo1 = (DynamicObject)invEntryCol.get(1);
        DynamicObject invEntryInfo2 = (DynamicObject)invEntryCol.get(2);
        invEntryCol.remove(3);
        BigDecimal amt1 = ArInvoiceBillTestHelper.invoiceEntrySet(invEntryInfo0, "quantity", BigDecimal.valueOf(1L));
        BigDecimal amt2 = ArInvoiceBillTestHelper.invoiceEntrySet(invEntryInfo1, "quantity", BigDecimal.valueOf(1.5));
        BigDecimal amt3 = ArInvoiceBillTestHelper.invoiceEntrySet(invEntryInfo2, "quantity", BigDecimal.valueOf(2L));
        BigDecimal amtSum = amt1.add(amt2).add(amt3);
        invInfo.set("recamount", (Object)amtSum);
        invInfo.set("reclocalamt", (Object)amtSum);
        invInfo.set("amount", (Object)amtSum);
        invInfo.set("localamt", (Object)amtSum);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invInfo}, (OperateOption)OperateOption.create());
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u5408\u5e76\u4e0b\u63a8\u5f00\u7968\u5355\u7b2c1\u6b21\uff0c\u4fdd\u5b58\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        invoices[0] = invInfo;
    }

    public static void checkAmt_1(Long arBillId_1, Long arBillId_2) {
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.valueOf(299.5), BigDecimal.valueOf(399.5), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(100L), BigDecimal.valueOf(200L), BigDecimal.valueOf(1.5), BigDecimal.valueOf(1.5), BigDecimal.valueOf(199.5), BigDecimal.valueOf(199.5));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.valueOf(3086L), BigDecimal.valueOf(17025L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(3086L), BigDecimal.valueOf(4629L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
    }

    public static void invoiceWriteOff_1(DynamicObject[] invoices, DynamicObject[] red_invoices) {
        DynamicObject invoiceInfo = invoices[0];
        invoiceInfo.set("isoffline", (Object)Boolean.TRUE);
        invoiceInfo.set("billstatus", (Object)"C");
        invoiceInfo.set("invoicestatus", (Object)"1");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoiceInfo}, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u5f00\u7968\u5355\u66f4\u65b0\u5ba1\u6838\u6001\u3001\u5df2\u5f00\u7968\u72b6\u6001\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        invoiceIds.add(invoiceInfo.getLong("id"));
        List<DynamicObject> red_invoies = BOTPHelper.push("ar_invoice", "ar_invoice", "762872803660698624", invoiceIds);
        DynamicObject red_invInfo = red_invoies.get(0);
        red_invInfo.set("billno", (Object)red_arInvoiceBillNo_1);
        DynamicObjectCollection entryCol = red_invInfo.getDynamicObjectCollection("entry");
        DynamicObject entryInfo_0 = (DynamicObject)entryCol.get(0);
        DynamicObject entryInfo_1 = (DynamicObject)entryCol.get(1);
        DynamicObject entryInfo_2 = (DynamicObject)entryCol.get(2);
        BigDecimal amt1 = ArInvoiceBillTestHelper.invoiceEntrySet(entryInfo_0, "quantity", BigDecimal.valueOf(-0.5));
        BigDecimal amt2 = ArInvoiceBillTestHelper.invoiceEntrySet(entryInfo_1, "quantity", BigDecimal.valueOf(-1L));
        BigDecimal amt3 = ArInvoiceBillTestHelper.invoiceEntrySet(entryInfo_2, "quantity", BigDecimal.valueOf(-1L));
        BigDecimal amtSum = amt1.add(amt2).add(amt3);
        red_invInfo.set("recamount", (Object)amtSum);
        red_invInfo.set("reclocalamt", (Object)amtSum);
        red_invInfo.set("amount", (Object)amtSum);
        red_invInfo.set("localamt", (Object)amtSum);
        OperationResult red_saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{red_invInfo}, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u53d1\u7968\u53551\u7b2c1\u6b21\u7ea2\u51b2\uff0c\u7ea2\u51b2\u5f00\u7968\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + red_saveResult.getMessage()), (boolean)true, (boolean)red_saveResult.isSuccess());
        red_invoices[0] = red_invInfo;
    }

    public static void checkRedAmt_1(Long arBillId_1, Long arBillId_2, DynamicObject[] invoices) {
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.valueOf(116.5), BigDecimal.valueOf(582.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(2.5), BigDecimal.valueOf(50L), BigDecimal.valueOf(250L), BigDecimal.valueOf(0.5), BigDecimal.valueOf(2.5), BigDecimal.valueOf(66.5), BigDecimal.valueOf(332.5));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.valueOf(1543L), BigDecimal.valueOf(18568L), BigDecimal.valueOf(1L), BigDecimal.valueOf(4L), BigDecimal.valueOf(1543L), BigDecimal.valueOf(6172L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
        Long invoiceId = invoices[0].getLong("id");
        DynamicObject invoiceInfo = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"ar_invoice");
        String invoiceBillNo = invoiceInfo.getString("billno");
        ArInvoiceBillTestChecker.checkArInvWriteOffAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u5f00\u7968\u5355", invoiceBillNo), invoiceInfo, BigDecimal.valueOf(50L), BigDecimal.valueOf(0.5), BigDecimal.valueOf(50L), BigDecimal.valueOf(0.5), BigDecimal.valueOf(133L), BigDecimal.valueOf(1L), BigDecimal.valueOf(66.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(1543L), BigDecimal.valueOf(1L), BigDecimal.valueOf(1543L), BigDecimal.valueOf(1L));
        invoices[0] = invoiceInfo;
    }

    public static void invoiceWriteOff_2(DynamicObject[] invoices, DynamicObject[] red_invoices) {
        Long invoiceId = invoices[0].getLong("id");
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        invoiceIds.add(invoiceId);
        List<DynamicObject> red_invoies = BOTPHelper.push("ar_invoice", "ar_invoice", "762872803660698624", invoiceIds);
        DynamicObject red_invInfo = red_invoies.get(0);
        red_invInfo.set("billno", (Object)red_arInvoiceBillNo_2);
        OperationResult red_saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{red_invInfo}, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u53d1\u7968\u53551\u7b2c2\u6b21\u7ea2\u51b2\uff0c\u7ea2\u51b2\u5f00\u7968\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + red_saveResult.getMessage()), (boolean)true, (boolean)red_saveResult.isSuccess());
        red_invoices[1] = red_invInfo;
    }

    public static void checkRedAmt_2(Long arBillId_1, Long arBillId_2, DynamicObject[] invoices) {
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.ZERO, BigDecimal.valueOf(699L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(300L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(399L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.ZERO, BigDecimal.valueOf(20111L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(7715L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
        Long invoiceId = invoices[0].getLong("id");
        DynamicObject invoiceInfo = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"ar_invoice");
        String invoiceBillNo = invoiceInfo.getString("billno");
        ArInvoiceBillTestChecker.checkArInvWriteOffAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u5f00\u7968\u5355", invoiceBillNo), invoiceInfo, BigDecimal.valueOf(100L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(199.5), BigDecimal.valueOf(1.5), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3086L), BigDecimal.valueOf(2L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        invoices[0] = invoiceInfo;
    }

    public static void deleteRedInvoice(Long arBillId_1, Long arBillId_2, DynamicObject[] red_invoices) {
        OperationResult red_delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_invoice", (DynamicObject[])red_invoices, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u5220\u9664\u4e24\u5f20\u7ea2\u51b2\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + red_delResult.getMessage()), (boolean)true, (boolean)red_delResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.valueOf(299.5), BigDecimal.valueOf(399.5), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(100L), BigDecimal.valueOf(200L), BigDecimal.valueOf(1.5), BigDecimal.valueOf(1.5), BigDecimal.valueOf(199.5), BigDecimal.valueOf(199.5));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.valueOf(3086L), BigDecimal.valueOf(17025L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(3086L), BigDecimal.valueOf(4629L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
    }

    public static void invalidInovice(Long arBillId_1, Long arBillId_2, DynamicObject[] invoices) {
        DynamicObject invoiceInfo = invoices[0];
        invoiceInfo.set("invoicestatus", (Object)"3");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoiceInfo}, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u4f5c\u5e9f\u84dd\u5b57\u5f00\u7968\u5355\uff0c\u65e0\u6761\u4ef6\u4fdd\u5b58\u84dd\u5b57\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        invoices[0] = invoiceInfo;
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.ZERO, BigDecimal.valueOf(699L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(300L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(399L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.ZERO, BigDecimal.valueOf(20111L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(7715L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
    }

    public static void unInvalidInvoice(Long arBillId_1, Long arBillId_2, DynamicObject[] invoices) {
        DynamicObject invoiceInfo = invoices[0];
        invoiceInfo.set("invoicestatus", (Object)"1");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoiceInfo}, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u53d6\u6d88\u4f5c\u5e9f\u84dd\u5b57\u5f00\u7968\u5355\uff0c\u65e0\u6761\u4ef6\u4fdd\u5b58\u84dd\u5b57\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        invoices[0] = invoiceInfo;
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.valueOf(299.5), BigDecimal.valueOf(399.5), BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(100L), BigDecimal.valueOf(200L), BigDecimal.valueOf(1.5), BigDecimal.valueOf(1.5), BigDecimal.valueOf(199.5), BigDecimal.valueOf(199.5));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.valueOf(3086L), BigDecimal.valueOf(17025L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(3086L), BigDecimal.valueOf(4629L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
    }

    public static void pushInvoice2(List<Long> finarBillIds, DynamicObject[] invoices) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_invoice", "762791232819726336", finarBillIds);
        DynamicObject invInfo = list.get(0);
        invInfo.set("billno", (Object)arInvoiceBillNo_2);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invInfo}, (OperateOption)OperateOption.create());
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u5408\u5e76\u4e0b\u63a8\u5f00\u7968\u5355\u7b2c2\u6b21\uff0c\u4fdd\u5b58\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        invoices[1] = invInfo;
    }

    public static void checkAmt_2(Long arBillId_1, Long arBillId_2) {
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.valueOf(699L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.valueOf(0L), BigDecimal.valueOf(300L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(399L), BigDecimal.ZERO);
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.valueOf(20111L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.valueOf(0L), BigDecimal.valueOf(7715L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L), BigDecimal.ZERO);
    }

    public void deleteInvoice(Long arBillId_1, Long arBillId_2, DynamicObject[] invoices) {
        for (int i = 0; i < invoices.length; ++i) {
            DynamicObject invoice = invoices[i];
            invoice.set("billstatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
        OperationResult red_delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_invoice", (DynamicObject[])invoices, null);
        AR018_018_2_FinArToArInvoiceTest.assertEquals((String)("\u5220\u9664\u4e24\u5f20\u5f00\u7968\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + red_delResult.getMessage()), (boolean)true, (boolean)red_delResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)arBillId_1, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_1), billInfo_1, BigDecimal.ZERO, BigDecimal.valueOf(699L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(300L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(399L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)arBillId_2, (String)"ar_finarbill");
        FinArBillTestChecker.chekcFinArInvoiceAmt(String.format("\u5355\u636e\u7f16\u53f7\uff1a[%s]\u7684\u8d22\u52a1\u5e94\u6536\u5355", finArBillNo_2), billInfo_2, BigDecimal.ZERO, BigDecimal.valueOf(20111L), BigDecimal.ZERO, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(7715L), BigDecimal.ZERO, BigDecimal.valueOf(3L), BigDecimal.ZERO, BigDecimal.valueOf(12396L));
    }
}

