/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AR018_023_FinArToPayAndWriteOffTest
extends AbstractJUnitTestPlugIn {
    private static String finArBillNo_1 = "AR018_023_FinArBillNo_01";
    private static String finArBillNo_2 = "AR018_023_FinArBillNo_02";
    private static String payBillNo_1 = "AR018_023_PayBillNo_01";
    private static String payBillNo_2 = "AR018_023_PayBillNo_02";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", finArBillNo_1, finArBillNo_2);
        FinArBillTestHelper.deleteBill("cas_paybill", payBillNo_1, payBillNo_2);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u4e0b\u63a8\u6536\u6b3e\u5355\u3001\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u5355\u5143\u6d4b\u8bd5\uff08\u7269\u6599\u884c\u7ed3\u7b97\uff09")
    @Test
    public void case1() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinArBillTestHelper.setAR005(org.getLong("id"), true);
        DynamicObject finarBillInfo = FinArBillTestHelper.createFinArBill(finArBillNo_1, BigDecimal.valueOf(-2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId = finarBillInfo.getLong("id");
        idList.add(finArBillId);
        DynamicObject payBillInfo = AR018_023_FinArToPayAndWriteOffTest.finArPushPayBill_1(finArBillId, idList);
        AR018_023_FinArToPayAndWriteOffTest.writeOff_1(finArBillId);
        AR018_023_FinArToPayAndWriteOffTest.pay_1(finArBillId, idList, payBillInfo);
        DynamicObject red_finArBillInfo = AR018_023_FinArToPayAndWriteOffTest.writeOff_2(finArBillId, idList);
        AR018_023_FinArToPayAndWriteOffTest.unAuditRedBill_1(finArBillId, red_finArBillInfo);
    }

    public static void unAuditRedBill_1(Long finArBillId, DynamicObject red_finArBillInfo) {
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{red_finArBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u53cd\u5ba1\u6838\u7ea2\u5b57\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult.getMessage()), (boolean)true, (boolean)unauditResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L));
    }

    public static DynamicObject writeOff_2(Long finArBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", idList);
        DynamicObject red_finArBillInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{red_finArBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u7ea2\u5b57\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)detailEntryCol.get(0)).getLong("id"), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)detailEntryCol.get(1)).getLong("id"), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkArVerifyAmt(arBillInfo, BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(0L));
        return red_finArBillInfo;
    }

    public static void pay_1(Long finArBillId, List<Long> idList, DynamicObject payBillInfo) {
        OperationResult receivingrecResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u4ed8\u6b3e\u5355[" + payBillNo_1 + "]\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + receivingrecResult.getMessage()), (boolean)true, (boolean)receivingrecResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)detailEntryCol.get(0)).getLong("id"), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)detailEntryCol.get(1)).getLong("id"), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finArBillId}, new Long[]{payBillInfo.getLong("id")}, true);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
    }

    public static void writeOff_1(Long finArBillId) {
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryCol) {
            BigDecimal lockedAmt = entryInfo.getBigDecimal("e_lockedamt");
            BigDecimal settledAmt = entryInfo.getBigDecimal("e_settledamt");
            boolean isOnTheWay = lockedAmt != null && settledAmt != null && lockedAmt.compareTo(settledAmt) != 0;
            KDAssert.assertEquals((String)("\u5e94\u6536\u5355\u636e[" + finArBillNo_1 + "]\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u5e94\u8be5\u4e0d\u5141\u8bb8\u51b2\u9500\uff01"), (boolean)true, (boolean)isOnTheWay);
        }
    }

    public static DynamicObject finArPushPayBill_1(Long finarBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "cas_paybill", "757805466909715456", idList);
        DynamicObject payBillInfo = list.get(0);
        DynamicObjectCollection entry = payBillInfo.getDynamicObjectCollection("entry");
        CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(200L));
        CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L));
        payBillInfo.set("billno", (Object)payBillNo_1);
        payBillInfo.set("actpayamt", (Object)BigDecimal.valueOf(400L));
        payBillInfo.set("localamt", (Object)BigDecimal.valueOf(400L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u5e94\u6536\u5355\u4e0b\u63a8\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        payBillInfo = BusinessDataServiceHelper.loadSingle((Object)payBillInfo.getLong("id"), (String)"cas_paybill");
        payBillInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBillInfo});
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finarBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L));
        return payBillInfo;
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u4e0b\u63a8\u6536\u6b3e\u5355\u3001\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\u5355\u5143\u6d4b\u8bd5\uff08\u8ba1\u5212\u884c\u7ed3\u7b97\uff09")
    @Test
    public void case2() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinArBillTestHelper.setAR005(org.getLong("id"), true);
        DynamicObject finarBillInfo = FinArBillTestHelper.createFinArBill(finArBillNo_2, BigDecimal.valueOf(-2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(200L), false, true);
        Long finArBillId = finarBillInfo.getLong("id");
        idList.add(finArBillId);
        DynamicObject payBillInfo = AR018_023_FinArToPayAndWriteOffTest.finArPushPayBill_2(finArBillId, idList);
        AR018_023_FinArToPayAndWriteOffTest.writeOff_3(finArBillId);
        AR018_023_FinArToPayAndWriteOffTest.pay_2(finArBillId, idList, payBillInfo);
        DynamicObject red_finArBillInfo = AR018_023_FinArToPayAndWriteOffTest.writeOff_4(finArBillId, idList);
        AR018_023_FinArToPayAndWriteOffTest.unAuditRedBill_2(finArBillId, red_finArBillInfo);
    }

    public static void unAuditRedBill_2(Long finArBillId, DynamicObject red_finArBillInfo) {
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{red_finArBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u53cd\u5ba1\u6838\u7ea2\u5b57\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult.getMessage()), (boolean)true, (boolean)unauditResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L));
    }

    public static DynamicObject writeOff_4(Long finArBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", idList);
        DynamicObject red_finArBillInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{red_finArBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u7ea2\u5b57\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)planEntryCol.get(0)).getLong("id"), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L));
        FinArBillTestChecker.checkArVerifyAmt(arBillInfo, BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-2L), BigDecimal.valueOf(0L));
        return red_finArBillInfo;
    }

    public static void pay_2(Long finArBillId, List<Long> idList, DynamicObject payBillInfo) {
        OperationResult receivingrecResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u4ed8\u6b3e\u5355[" + payBillNo_2 + "]\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + receivingrecResult.getMessage()), (boolean)true, (boolean)receivingrecResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId, ((DynamicObject)planEntryCol.get(0)).getLong("id"), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finArBillId}, new Long[]{payBillInfo.getLong("id")}, true);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
    }

    public static void writeOff_3(Long finArBillId) {
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryCol) {
            BigDecimal lockedAmt = entryInfo.getBigDecimal("e_lockedamt");
            BigDecimal settledAmt = entryInfo.getBigDecimal("e_settledamt");
            boolean isOnTheWay = lockedAmt != null && settledAmt != null && lockedAmt.compareTo(settledAmt) != 0;
            KDAssert.assertEquals((String)("\u5e94\u6536\u5355\u636e[" + finArBillNo_1 + "]\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u5e94\u8be5\u4e0d\u5141\u8bb8\u51b2\u9500\uff01"), (boolean)true, (boolean)isOnTheWay);
        }
    }

    public static DynamicObject finArPushPayBill_2(Long finarBillId, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "cas_paybill", "754275988539463680", idList);
        DynamicObject payBillInfo = list.get(0);
        DynamicObjectCollection entry = payBillInfo.getDynamicObjectCollection("entry");
        CasPayBillTestHelper.setPayEntryAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(400L));
        payBillInfo.set("billno", (Object)payBillNo_2);
        payBillInfo.set("actpayamt", (Object)BigDecimal.valueOf(400L));
        payBillInfo.set("localamt", (Object)BigDecimal.valueOf(400L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBillInfo}, (OperateOption)OperateOption.create());
        AR018_023_FinArToPayAndWriteOffTest.assertEquals((String)("\u5e94\u6536\u5355\u4e0b\u63a8\u4ed8\u6b3e\u5355\uff0c\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        payBillInfo = BusinessDataServiceHelper.loadSingle((Object)payBillInfo.getLong("id"), (String)"cas_paybill");
        payBillInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBillInfo});
        DynamicObject arBillInfo = BusinessDataServiceHelper.loadSingle((Object)finarBillId, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol = arBillInfo.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(0), BigDecimal.valueOf(-200L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol.get(1), BigDecimal.valueOf(-200L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L));
        DynamicObjectCollection planEntryCol = arBillInfo.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol.get(0), BigDecimal.valueOf(-400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L));
        return payBillInfo;
    }
}

