/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import org.junit.Test;

public class AR018_025_FinArTransferTest
extends AbstractJUnitTestPlugIn {
    private static String finArBillNo_1 = "AR018_025_FinArBillNo_01";
    private static String finArBillNo_2 = "AR018_025_FinArBillNo_02";
    private static String finArBillNo_3 = "AR018_025_FinArBillNo_03";
    private static String finArBillNo_4 = "AR018_025_FinArBillNo_04";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", finArBillNo_1, finArBillNo_2, finArBillNo_3, finArBillNo_4);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536-\u503a\u6743\u8f6c\u79fb-\u51b2\u9500\u5355\u5143\u6d4b\u8bd5\uff08\u7269\u6599\u884c\uff09\u6c47\u603b\u8f6c\u5165")
    @Test
    public void case1() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject finarBillInfo_1 = FinArBillTestHelper.createFinArBill(finArBillNo_1, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_1 = finarBillInfo_1.getLong("id");
        idList.add(finArBillId_1);
        DynamicObject finarBillInfo_2 = FinArBillTestHelper.createFinArBill(finArBillNo_2, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_2 = finarBillInfo_2.getLong("id");
        idList.add(finArBillId_2);
        Set<Long> transferIds = this.pushTransfer_1(finArBillId_1, finArBillId_2, idList);
        this.writeOff_1(finArBillId_1, finArBillId_2, transferIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536-\u503a\u6743\u8f6c\u79fb-\u51b2\u9500\u5355\u5143\u6d4b\u8bd5\uff08\u7269\u6599\u884c\uff09\u5206\u6563\u8f6c\u5165")
    @Test
    public void case2() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject finarBillInfo_1 = FinArBillTestHelper.createFinArBill(finArBillNo_3, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_1 = finarBillInfo_1.getLong("id");
        idList.add(finArBillId_1);
        DynamicObject finarBillInfo_2 = FinArBillTestHelper.createFinArBill(finArBillNo_4, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_2 = finarBillInfo_2.getLong("id");
        idList.add(finArBillId_2);
        Set<Long> transferIds = this.pushTransfer_2(finArBillId_1, finArBillId_2, idList);
        this.writeOff_2(finArBillId_1, finArBillId_2, transferIds);
    }

    public void writeOff_1(Long finArBillId_1, Long finArBillId_2, Set<Long> transferIds) {
        ArrayList<Long> ids = new ArrayList<Long>(transferIds);
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", ids);
        DynamicObject billInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{billInfo}, (OperateOption)OperateOption.create());
        AR018_025_FinArTransferTest.assertEquals((String)("\u503a\u5238\u8f6c\u79fb\u5355\u636e\u51b2\u9500\u751f\u6210\u7684\u7ea2\u5b57\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        DynamicObject arBillInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject arBillInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    public void writeOff_2(Long finArBillId_1, Long finArBillId_2, Set<Long> transferIds) {
        ArrayList<Long> ids = new ArrayList<Long>(transferIds);
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", ids);
        DynamicObject billInfo_1 = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{billInfo_1}, (OperateOption)OperateOption.create());
        AR018_025_FinArTransferTest.assertEquals((String)("\u503a\u5238\u8f6c\u79fb\u5355\u636e\u51b2\u9500\u751f\u6210\u7684\u7ea2\u5b57\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        DynamicObject billInfo_2 = list.get(1);
        OperationResult saveResult_2 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{billInfo_2}, (OperateOption)OperateOption.create());
        AR018_025_FinArTransferTest.assertEquals((String)("\u503a\u5238\u8f6c\u79fb\u5355\u636e\u51b2\u9500\u751f\u6210\u7684\u7ea2\u5b57\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult_2.getMessage()), (boolean)true, (boolean)saveResult_2.isSuccess());
        DynamicObject arBillInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject arBillInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    public Set<Long> pushTransfer_1(Long finArBillId_1, Long finArBillId_2, List<Long> idList) {
        Set<Long> transferIds = this.pushAndSaveTransfer("sum", finArBillId_1, finArBillId_2, new BigDecimal[]{BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(2L)}, new BigDecimal[]{BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L)});
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.audit(transferIds);
        DynamicObject arBillInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(0)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(1)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        DynamicObjectCollection planEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObject arBillInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(0)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(1)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        DynamicObjectCollection planEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finArBillId_1, finArBillId_2}, transferIds.toArray(new Long[0]), true);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
        return transferIds;
    }

    public Set<Long> pushTransfer_2(Long finArBillId_1, Long finArBillId_2, List<Long> idList) {
        Set<Long> transferIds = this.pushAndSaveTransfer("bijection", finArBillId_1, finArBillId_2, new BigDecimal[]{BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(2L)}, new BigDecimal[]{BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L)});
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.audit(transferIds);
        DynamicObject arBillInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(0)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(1)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        DynamicObjectCollection planEntryCol_1 = arBillInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObject arBillInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(0)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(1)).getLong("id"), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L));
        DynamicObjectCollection planEntryCol_2 = arBillInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finArBillId_1, finArBillId_2}, transferIds.toArray(new Long[0]), true);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
        return transferIds;
    }

    private void audit(Set<Long> billIds) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])billIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private Set<Long> pushAndSaveTransfer(String transferType, Long finArBillId_1, Long finArBillId_2, BigDecimal[] transferQtyArray, BigDecimal[] transferAmtArray) {
        DynamicObject finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObject finArBill2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObject transfer = BusinessDataServiceHelper.newDynamicObject((String)"ar_transferofcredit");
        transfer.set("transfertype", (Object)transferType);
        transfer.set("asstacttype", (Object)finArBill.getString("asstacttype"));
        transfer.set("asstact", (Object)finArBill.getDynamicObject("asstact"));
        transfer.set("bizdate", (Object)finArBill.getDate("bizdate"));
        transfer.set("duedate", (Object)finArBill.getDate("bizdate"));
        transfer.set("payproperty", (Object)finArBill.getDynamicObject("payproperty"));
        transfer.set("currency", (Object)finArBill.getDynamicObject("currency"));
        transfer.set("head_exchangerate", (Object)finArBill.getBigDecimal("exchangerate"));
        transfer.set("org", (Object)finArBill.getDynamicObject("org"));
        transfer.set("recorg", (Object)finArBill.getDynamicObject("recorg"));
        transfer.set("exratetable", (Object)finArBill.getDynamicObject("exratetable"));
        transfer.set("billtype", (Object)finArBill.getDynamicObject("billtype"));
        if (EntityMetadataUtils.isExistProperty(transfer, "quotation")) {
            transfer.set("quotation", (Object)"0");
        }
        int i = 0;
        int j = 0;
        this.setTransferEntry(finArBill, transfer, new BigDecimal[]{transferQtyArray[i++], transferQtyArray[i++]}, new BigDecimal[]{transferAmtArray[j++], transferAmtArray[j++]});
        this.setTransferEntry(finArBill2, transfer, new BigDecimal[]{transferQtyArray[i++], transferQtyArray[i++]}, new BigDecimal[]{transferAmtArray[j++], transferAmtArray[j++]});
        OperationResult transferResult = OperationServiceHelper.executeOperate((String)"transfer", (String)"ar_transferofcredit", (DynamicObject[])new DynamicObject[]{transfer}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(transferResult);
        return this.getTransferBillId(new Long[]{finArBillId_1, finArBillId_2});
    }

    private Set<Long> getTransferBillId(Long[] finArBillIds) {
        Map<String, HashSet<Long>> botpResult = BOTPHelper.findTargetBills("ar_finarbill", finArBillIds);
        Set debtBillIds = botpResult.getOrDefault("ar_finarbill", new HashSet(16));
        return debtBillIds;
    }

    private void setTransferEntry(DynamicObject finArBill, DynamicObject transfer, BigDecimal[] transferQtyArray, BigDecimal[] transferAmtArray) {
        DynamicObjectType dataEntityType = (DynamicObjectType)transfer.getDataEntityType();
        DynamicObjectType transferEntryType = ((EntryProp)dataEntityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        DynamicObjectCollection transferEntries = transfer.getDynamicObjectCollection("entryentity");
        int precision = finArBill.getDynamicObject("currency").getInt("amtprecision");
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            DynamicObject transferEntryRow = new DynamicObject(transferEntryType);
            transferEntryRow.set("e_srcfinbillid", (Object)finArBill.getLong("id"));
            transferEntryRow.set("e_asstacttype", (Object)finArBill.getString("asstacttype"));
            transferEntryRow.set("e_asstact", (Object)finArBill.getString("asstact"));
            transferEntryRow.set("e_billno", (Object)finArBill.getString("billno"));
            transferEntryRow.set("e_bizdate", (Object)finArBill.getDate("bizdate"));
            transferEntryRow.set("e_currency", (Object)finArBill.getDynamicObject("currency"));
            transferEntryRow.set("e_currency", (Object)finArBill.getDynamicObject("currency"));
            transferEntryRow.set("e_trate", (Object)finArBill.getBigDecimal("exchangerate"));
            transferEntryRow.set("e_srcentryid", (Object)detailEntryRow.getLong("id"));
            transferEntryRow.set("e_material", (Object)detailEntryRow.getDynamicObject("e_material"));
            transferEntryRow.set("e_recamount", (Object)detailEntryRow.getBigDecimal("e_recamount"));
            transferEntryRow.set("e_measureunit", (Object)detailEntryRow.getDynamicObject("e_measureunit"));
            transferEntryRow.set("e_quantity", (Object)transferQtyArray[i]);
            transferEntryRow.set("e_taxrate", (Object)BigDecimal.ZERO);
            transferEntryRow.set("e_transamount", (Object)transferAmtArray[i]);
            transferEntryRow.set("e_transtax", (Object)BigDecimal.ZERO);
            transferEntryRow.set("e_transrecamount", (Object)transferAmtArray[i]);
            transferEntryRow.set("e_localamount", (Object)transferAmtArray[i].multiply(finArBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP));
            transferEntries.add((Object)transferEntryRow);
        }
        DynamicObjectType transferPlanEntryType = ((EntryProp)dataEntityType.getProperty("planentity")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        DynamicObjectCollection transferPlanEntries = transfer.getDynamicObjectCollection("planentity");
        for (int i = 0; i < planEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)planEntries.get(i);
            DynamicObject transferEntryRow = new DynamicObject(transferPlanEntryType);
            transferEntryRow.set("p_billid", (Object)finArBill.getLong("id"));
            transferEntryRow.set("p_billno", (Object)finArBill.getString("billno"));
            transferEntryRow.set("planduedate", (Object)finArBill.getDate("bizdate"));
            transferEntryRow.set("planpricetax", (Object)detailEntryRow.getBigDecimal("planpricetax"));
            transferEntryRow.set("p_transpricetaxtotal", (Object)detailEntryRow.getBigDecimal("planpricetax"));
            transferEntryRow.set("p_entryid", (Object)detailEntryRow.getLong("id"));
            transferPlanEntries.add((Object)transferEntryRow);
        }
    }
}

