/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.ViewInfoTestHelper;
import org.junit.Test;

public class AP001_BusApBillTest
extends AbstractJUnitTestPlugIn {
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private OperationServiceImpl impl = new OperationServiceImpl();
    private IDataModel model = null;
    private IFormView busBillView = null;
    private final long orgId = BaseDataTestProvider.getUnInitOrg().getLong("id");

    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u5f55\u5165\u542b\u7a0e\u4ef7=false,\u5f55\u5165\u603b\u4ef7=false")
    @Test
    public void testCase1() {
        this.fillFieldVlaues();
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("taxrateid", (Object)1L, 0);
        DynamicObject busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), 0);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(13L), BigDecimal.valueOf(13L), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busBill);
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("ispricetotal", (Object)Boolean.FALSE);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 1);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 1);
        this.model.setValue("e_taxunitprice", (Object)BigDecimal.valueOf(22.6), 1);
        this.model.setValue("taxrateid", (Object)1L, 1);
        this.model.setValue("e_discountmode", (Object)"PERCENT", 1);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 1);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(180L), BigDecimal.valueOf(180L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), BigDecimal.valueOf(18L), BigDecimal.valueOf(20.34), 1);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(23.4), BigDecimal.valueOf(23.4), BigDecimal.valueOf(22.6), BigDecimal.valueOf(22.6), 1);
        BusBillTestChecker.headCheck(busBill);
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("ispricetotal", (Object)Boolean.TRUE);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 2);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 2);
        this.model.setValue("e_amount", (Object)BigDecimal.valueOf(300L), 2);
        this.model.setValue("taxrateid", (Object)1L, 2);
        this.model.setValue("e_discountmode", (Object)"PERUNIT", 2);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 2);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(300L), BigDecimal.valueOf(300L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(45.2), BigDecimal.valueOf(30L), BigDecimal.valueOf(33.9), 2);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(39L), BigDecimal.valueOf(39L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 2);
        BusBillTestChecker.headCheck(busBill);
        this.model.createNewEntryRow("entry");
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("ispricetotal", (Object)Boolean.TRUE);
        this.model.setValue("e_discountmode", (Object)"TOTAL", 3);
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 3);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 3);
        this.model.setValue("taxrateid", (Object)1L, 3);
        this.model.setValue("e_pricetaxtotal", (Object)BigDecimal.valueOf(452L), 3);
        this.model.setValue("e_discountamount", (Object)BigDecimal.valueOf(226L), 3);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(452L), BigDecimal.valueOf(452L), 3);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(452L), BigDecimal.valueOf(452L), 3);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(452L), BigDecimal.valueOf(452L), 3);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(60L), BigDecimal.valueOf(67.8), BigDecimal.valueOf(40L), BigDecimal.valueOf(45.2), 3);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(52L), BigDecimal.valueOf(52L), BigDecimal.valueOf(226L), BigDecimal.valueOf(226L), 3);
        BusBillTestChecker.headCheck(busBill);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u6570\u91cf\u57fa\u51c6\u4fdd\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u6d4b\u8bd5\u3001\u53cd\u5ba1\u6838")
    @Test
    public void testCase5() {
        this.busBillView.invokeOperation("save");
        DynamicObject busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillJournalCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillDeleteJournalCheck(busBill.getString("billno"), false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u91d1\u989d\u57fa\u51c6")
    @Test
    public void testCase6() {
        DynamicObject payPro = BaseDataTestProvider.getPayPropertyByAmtBenchmark();
        DynamicObject apPro = BusinessDataServiceHelper.loadSingle((String)"ap_payproperty", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payPro.getString("number"))});
        this.model.setValue("payproperty", (Object)apPro);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        DynamicObject busBill = this.model.getDataEntity(true);
        busBill.get("payproperty");
        BusBillTestChecker.entryCheckByQty(busBill, BigDecimal.ONE, 0);
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("ispricetotal", (Object)Boolean.TRUE);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(-1L), 0);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(-100L), BigDecimal.valueOf(-113L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-113L), 0);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(13L), BigDecimal.valueOf(13L), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("ispricetotal", (Object)Boolean.FALSE);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(-1L), 1);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(-180L), BigDecimal.valueOf(-180L), BigDecimal.valueOf(-203.4), BigDecimal.valueOf(-203.4), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-203.4), BigDecimal.valueOf(-203.4), 1);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-203.4), BigDecimal.valueOf(-203.4), 1);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(200L), BigDecimal.valueOf(226L), BigDecimal.valueOf(180L), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(-23.4), BigDecimal.valueOf(-23.4), BigDecimal.valueOf(-22.6), BigDecimal.valueOf(-22.6), 1);
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("ispricetotal", (Object)Boolean.TRUE);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(-1L), 2);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(300L), BigDecimal.valueOf(300L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(-290L), BigDecimal.valueOf(-327.7), BigDecimal.valueOf(-300L), BigDecimal.valueOf(-339L), 2);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(39L), BigDecimal.valueOf(39L), BigDecimal.valueOf(-11.3), BigDecimal.valueOf(-11.3), 2);
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("ispricetotal", (Object)Boolean.FALSE);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(-1L), 3);
        busBill = this.model.getDataEntity(true);
        this.busBillView.invokeOperation("save");
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(-397.4), BigDecimal.valueOf(-397.4), BigDecimal.valueOf(-449.062), BigDecimal.valueOf(-449.062), 3);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-449.062), BigDecimal.valueOf(-449.062), 3);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-449.062), BigDecimal.valueOf(-449.062), 3);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(420L), BigDecimal.valueOf(474.6), BigDecimal.valueOf(397.4), BigDecimal.valueOf(449.062), 3);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(-51.662), BigDecimal.valueOf(-51.662), BigDecimal.valueOf(-25.538), BigDecimal.valueOf(-25.538), 3);
        BusBillTestChecker.headCheck(busBill);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u91d1\u989d\u57fa\u51c6\u4fdd\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u6d4b\u8bd5\u3001\u53cd\u5ba1\u6838")
    @Test
    public void testCase7() {
        this.busBillView.invokeOperation("save");
        DynamicObject busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.invokeOperation("refresh");
        this.busBillView.invokeOperation("close");
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillJournalCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillDeleteJournalCheck(busBill.getString("billno"), false);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u5f02\u5e01\u522b")
    @Test
    public void testCase8() {
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("ispricetotal", (Object)Boolean.FALSE);
        this.model.setValue("currency", (Object)6L);
        this.model.setValue("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        this.model.setValue("exchangerate", (Object)6);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 1);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 2);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 3);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(20L), 1);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(30L), 2);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(40L), 3);
        DynamicObject busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(180L), BigDecimal.valueOf(1080L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), BigDecimal.valueOf(18L), BigDecimal.valueOf(20.34), 1);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(23.4), BigDecimal.valueOf(140.4), BigDecimal.valueOf(22.6), BigDecimal.valueOf(135.6), 1);
        BusBillTestChecker.headCheck(busBill);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u5f02\u5e01\u522b\u4fdd\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u6d4b\u8bd5\u3001\u53cd\u5ba1\u6838")
    @Test
    public void testCase9() {
        this.busBillView.invokeOperation("save");
        DynamicObject busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.operationCheck();
        this.busBillView.close();
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.operationCheck();
        this.busBillView.close();
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillJournalCheck(busBill);
        this.operationCheck();
        this.busBillView.close();
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillDeleteJournalCheck(busBill.getString("billno"), false);
        this.operationCheck();
    }

    @TestMethod(value=10)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u5220\u9664")
    @Test
    public void testCase10() {
        this.busBillView.close();
        String resMeg = this.impl.invokeOperation("delete", this.model.getDataEntityType().getName(), new Object[]{this.model.getDataEntity(true).getPkValue()}, null);
        DynamicObject busBill = QueryServiceHelper.queryOne((String)"ap_busbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", this.model.getValue("billno"))});
        AP001_BusApBillTest.assertEquals((String)("\u6682\u4f30\u5e94\u4ed8\u5355\u5220\u9664\u5931\u8d25" + resMeg), (busBill != null ? 1 : 0) != 0, (boolean)false);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u4ee3\u57ab\u5355\u636e\u6d4b\u8bd5")
    @Test
    public void testCase11() {
        this.fillFieldVlaues();
        this.model.setValue("billtype", (Object)1732528341409358848L);
        this.model.setValue("asstact", (Object)BaseDataTestProvider.getSupplier());
        this.model.setValue("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        this.model.setValue("taxrateid", (Object)1L, 0);
        this.model.setValue("e_expenseitem", (Object)BusinessDataServiceHelper.loadSingle((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)true)}), 0);
        DynamicObject busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 0);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), 0);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(13L), BigDecimal.valueOf(13L), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busBill);
        this.model.setValue("isincludetax", (Object)Boolean.TRUE);
        this.model.setValue("ispricetotal", (Object)Boolean.FALSE);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 1);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 1);
        this.model.setValue("e_taxunitprice", (Object)BigDecimal.valueOf(22.6), 1);
        this.model.setValue("e_expenseitem", (Object)BusinessDataServiceHelper.loadSingle((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)true)}), 1);
        this.model.setValue("taxrateid", (Object)1L, 1);
        this.model.setValue("e_discountmode", (Object)"PERCENT", 1);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 1);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(180L), BigDecimal.valueOf(180L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(203.4), 1);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), BigDecimal.valueOf(18L), BigDecimal.valueOf(20.34), 1);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(23.4), BigDecimal.valueOf(23.4), BigDecimal.valueOf(22.6), BigDecimal.valueOf(22.6), 1);
        BusBillTestChecker.headCheck(busBill);
        this.model.setValue("isincludetax", (Object)Boolean.FALSE);
        this.model.setValue("ispricetotal", (Object)Boolean.TRUE);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 2);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 2);
        this.model.setValue("e_amount", (Object)BigDecimal.valueOf(300L), 2);
        this.model.setValue("taxrateid", (Object)1L, 2);
        this.model.setValue("e_discountmode", (Object)"PERUNIT", 2);
        this.model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 2);
        this.model.setValue("e_prepaid", (Object)Boolean.TRUE, 2);
        this.model.setValue("e_expenseitem", (Object)BusinessDataServiceHelper.loadSingle((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)true)}), 2);
        busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(300L), BigDecimal.valueOf(300L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(339L), BigDecimal.valueOf(339L), 2);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(45.2), BigDecimal.valueOf(30L), BigDecimal.valueOf(33.9), 2);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(39L), BigDecimal.valueOf(39L), BigDecimal.valueOf(113L), BigDecimal.valueOf(113L), 2);
        BusBillTestChecker.headCheck(busBill);
    }

    @TestMethod(value=12)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u4ee3\u57ab\u672c\u7aef\u5168\u6d41\u7a0b\u6d4b\u8bd5--\u4fdd\u5b58\u3001\u63d0\u4ea4\u3001\u5ba1\u6838\u6d4b\u8bd5\u3001\u53cd\u5ba1\u6838")
    @Test
    public void testCase12() throws InterruptedException {
        this.busBillView.invokeOperation("save");
        DynamicObject busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        Thread.sleep(20000L);
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillJournalCheck(busBill);
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"ap_busbill");
        filter.and(new QFilter("sourcebillid", "=", (Object)busBill.getString("id")));
        boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{filter});
        AP001_BusApBillTest.assertEquals((String)"\u4ee3\u57ab\u6682\u4f30\u672a\u81ea\u52a8\u751f\u6210\u6682\u4f30\u5e94\u6536\u5355", (boolean)true, (boolean)exists);
        this.busBillView.close();
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{this.busBillView.getModel().getDataEntity().getLong("id")});
        this.busBillView.invokeOperation("refresh");
        busBill = this.busBillView.getModel().getDataEntity(true);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestChecker.busBillDeleteJournalCheck(busBill.getString("billno"), false);
    }

    @TestMethod(value=13)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u6574\u5355\u6298\u6263\uff0c\u8f93\u5165\u6298\u6263\u989d\uff0c\u6570\u91cf\uff0c\u67e5\u770b\u5b57\u6bb5\u53d8\u5316")
    @Test
    public void testCase13() throws InterruptedException {
        this.fillFieldVlaues();
        this.model.setValue("asstact", (Object)BaseDataTestProvider.getSupplier());
        this.model.setValue("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(100L), 0);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(1L), 0);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 1);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(-1L), 1);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(100L), 1);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 2);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(1L), 2);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(100L), 2);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 3);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(1L), 3);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(100L), 3);
        this.model.createNewEntryRow("entry");
        this.model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 4);
        this.model.setValue("e_quantity", (Object)BigDecimal.valueOf(1L), 4);
        this.model.setValue("e_unitprice", (Object)BigDecimal.valueOf(100L), 4);
        OperationResult opResult = this.busBillView.invokeOperation("save");
        AP001_BusApBillTest.assertInvokeOperation((OperationResult)opResult);
        String param = "[{\"key\":\"advcontoolbarap\",\"methodName\":\"itemClick\",\"args\":[\"totaldiscount\",\"\"],\"postData\":[{},[]]}]";
        String childPageId = ViewInfoTestHelper.getChildPageId(this.busBillView, param, this);
        this.loadData(childPageId);
        IFormView discountView = this.getView(childPageId);
        IDataModel discountModel = discountView.getModel();
        discountModel.setValue("discountamount", (Object)new BigDecimal("299.99"));
        discountView.invokeOperation("btnok");
        IDataModel apModel = this.busBillView.getModel();
        DynamicObjectCollection entrys = apModel.getEntryEntity("entry");
        BigDecimal sumDiscountAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            BigDecimal totalAmt = entry.getBigDecimal("e_pricetaxtotal");
            BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
            KDAssert.assertEquals((String)"\u6298\u6263\u540e\u65b9\u5411\u6709\u8bef", (boolean)false, (totalAmt.signum() != discountAmt.signum() ? 1 : 0) != 0);
            sumDiscountAmt = sumDiscountAmt.add(discountAmt);
        }
        KDAssert.assertEquals((String)"\u6574\u5355\u6298\u6263\u540e\u754c\u9762\u91d1\u989d\u6709\u8bef", (boolean)false, (sumDiscountAmt.compareTo(new BigDecimal("299.99")) != 0 ? 1 : 0) != 0);
        apModel.setValue("e_quantity", (Object)1, 0);
        BigDecimal disAmt = (BigDecimal)apModel.getValue("e_discountamount", 0);
        BigDecimal disRate = (BigDecimal)apModel.getValue("e_discountrate", 0);
        disRate = disRate.multiply(BigDecimal.ONE);
        KDAssert.assertEquals((String)"\u6298\u6263\u989d\u8ba1\u7b97\u6709\u8bef", (boolean)false, (disAmt.compareTo(disRate) != 0 ? 1 : 0) != 0);
        apModel.setValue("taxrateid", (Object)1L, 0);
        BigDecimal taxrate = (BigDecimal)apModel.getValue("e_taxrate", 0);
        KDAssert.assertEquals((String)"\u6298\u6263\u989d\u8ba1\u7b97\u6709\u8bef", (boolean)false, (disAmt.compareTo(disRate) != 0 ? 1 : 0) != 0);
        apModel.setValue("isincludetax", (Object)false);
        apModel.setValue("e_quantity", (Object)0.5, 0);
        DynamicObject currency = (DynamicObject)apModel.getValue("currency");
        int amtPrecision = currency.getInt("amtprecision");
        disAmt = (BigDecimal)apModel.getValue("e_discountamount", 0);
        KDAssert.assertEquals((String)"\u6298\u6263\u989d\u8ba1\u7b97\u6709\u8bef", (boolean)false, (disAmt.compareTo(BigDecimal.valueOf(0.5).multiply(disRate.multiply(BigDecimal.ONE.add(taxrate.divide(new BigDecimal(100))))).setScale(amtPrecision, RoundingMode.HALF_UP)) != 0 ? 1 : 0) != 0);
    }

    private void operationCheck() {
        DynamicObject busBill = this.model.getDataEntity(true);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(100L), BigDecimal.valueOf(600L), BigDecimal.valueOf(113L), BigDecimal.valueOf(678L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(678L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(113L), BigDecimal.valueOf(678L), 0);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), BigDecimal.valueOf(10L), BigDecimal.valueOf(11.3), 0);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(13L), BigDecimal.valueOf(78L), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(180L), BigDecimal.valueOf(1080L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(203.4), BigDecimal.valueOf(1220.4), 1);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), BigDecimal.valueOf(18L), BigDecimal.valueOf(20.34), 1);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(23.4), BigDecimal.valueOf(140.4), BigDecimal.valueOf(22.6), BigDecimal.valueOf(135.6), 1);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(200L), BigDecimal.valueOf(1200L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 2);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 2);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 2);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(30L), BigDecimal.valueOf(33.9), BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), 2);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(26L), BigDecimal.valueOf(156L), BigDecimal.valueOf(113L), BigDecimal.valueOf(678L), 2);
        BusBillTestChecker.entryCheckByAmt(busBill, BigDecimal.valueOf(200L), BigDecimal.valueOf(1200L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 3);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 3);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 3);
        BusBillTestChecker.entryCheckByPrice(busBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(45.2), BigDecimal.valueOf(20L), BigDecimal.valueOf(22.6), 3);
        BusBillTestChecker.entryCheckByTax(busBill, BigDecimal.valueOf(26L), BigDecimal.valueOf(156L), BigDecimal.valueOf(226L), BigDecimal.valueOf(1356L), 3);
        BusBillTestChecker.headCheck(busBill);
    }

    private void fillFieldVlaues() {
        IListView listView = (IListView)this.getView();
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + this.orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        this.util.invokeAction((IFormView)listView, param);
        this.busBillView = this.util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        this.model = this.busBillView.getModel();
        this.model.setValue("asstact", (Object)BaseDataTestProvider.getSupplier());
        this.model.setValue("payorg", (Object)this.orgId);
        this.model.setValue("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        this.model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
    }
}

