/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.junit.Test;

public class AP018_001_BusApBillManualWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 10000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u5168\u989d\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase1() {
        this.deleteBill("AP018_001_Case1_BusApBillNo");
        this.deleteBill("AP018_001_Case1_AllWoffBillNo");
        String busApBillNo = "AP018_001_Case1_BusApBillNo";
        String busApAllWoffBillNo = "AP018_001_Case1_AllWoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill = BusBillTestHelper.getAuditBusApBill(busApBillNo, false, false, qtys, prices);
        long busApBillId = busApBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusApBill(null, "ap_busbill", Collections.singletonList(busApBillId), "C", busApAllWoffBillNo, "712748085842822144")[0];
        long woffBillId = woffBill.getLong("id");
        this.case1Check(busApBillId, woffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{woffBillId});
        this.case1Check(busApBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u90e8\u5206\u51b2\u56de\u540e\u51b2\u56de\u5355\u518d\u6b21\u5168\u989d\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase2() {
        this.deleteBill("AP018_001_Case2_BusApBillNo");
        this.deleteBill("AP018_002_Case2_PartWoffBillNo");
        this.deleteBill("AP018_002_Case2_WriteWoffBillNo");
        String busApBillNo = "AP018_001_Case2_BusApBillNo";
        String busApAllWoffBillNo = "AP018_002_Case2_PartWoffBillNo";
        String writeWoffBillNo = "AP018_002_Case2_WriteWoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill = BusBillTestHelper.getAuditBusApBill(busApBillNo, false, false, qtys, prices);
        long busApBillId = busApBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusApBill(BigDecimal.valueOf(999999L), "ap_busbill", Collections.singletonList(busApBillId), "C", busApAllWoffBillNo, "712748085842822144")[0];
        long woffBillId = woffBill.getLong("id");
        DynamicObject writeWoffBill = BusBillTestHelper.pushBusApBill(null, "ap_busbill", Collections.singletonList(woffBillId), "C", writeWoffBillNo, "712748085842822144")[0];
        long writeWoffBillId = writeWoffBill.getLong("id");
        this.case2Check(busApBillId, woffBillId, writeWoffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{writeWoffBillId});
        this.case2Check(busApBillId, woffBillId, writeWoffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{woffBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u91d1\u989d\u57fa\u51c6\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase3() throws InterruptedException {
        this.deleteBill("AP018_001_Case3_BusApBillNo");
        this.deleteBill("AP018_001_Case3_WoffBillNo");
        String busApBillNo = "AP018_001_Case3_BusApBillNo";
        String busApWoffBillNo = "AP018_001_Case3_WoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill = BusBillTestHelper.getAuditBusApBill(busApBillNo, true, false, qtys, prices);
        long busApBillId = busApBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusApBill(null, "ap_busbill", Collections.singletonList(busApBillId), "C", busApWoffBillNo, "712748085842822144")[0];
        long woffBillId = woffBill.getLong("id");
        this.case3Check(busApBillId, woffBillId, false);
        Thread.sleep(10000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{woffBillId});
        this.case3Check(busApBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u91d1\u989d\u57fa\u51c6\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase4() {
        this.deleteBill("AP018_001_Case4_BusApBillNo");
        this.deleteBill("AP018_001_Case4_WoffBillNo");
        String busApBillNo = "AP018_001_Case4_BusApBillNo";
        String busApWoffBillNo = "AP018_001_Case4_WoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill = BusBillTestHelper.getAuditBusApBill(busApBillNo, false, true, qtys, prices);
        long busApBillId = busApBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusApBill(null, "ap_busbill", Collections.singletonList(busApBillId), "C", busApWoffBillNo, "712748085842822144")[0];
        long woffBillId = woffBill.getLong("id");
        this.case4Check(busApBillId, woffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{woffBillId});
        this.case4Check(busApBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
    }

    private void case4Check(long busApBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case4_WoffBillNo \u6682\u4f30\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP018_001_Case4_WoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(650L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(2600L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busApBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ap_busbill");
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case4_WoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case4_WoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-2600L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void case3Check(long busApBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case3_WoffBillNo \u6682\u4f30\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP018_001_Case3_WoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busApBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ap_busbill");
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case3_WoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case3_WoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void case2Check(long busApBillId, long woffBillId, long writeWoffBillId, boolean isWriteWoffBillUnAudit) {
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ap_busbill");
        if (isWriteWoffBillUnAudit) {
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)writeWoffBillId)});
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_WriteWoffBillNo \u6682\u4f30\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 1);
            BusBillTestChecker.headCheck(busApBill);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
            BusBillTestChecker.headCheck(woffBill);
        } else {
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("writeoffbusiness"));
            DynamicObject writeWoffBill = BusinessDataServiceHelper.loadSingle((Object)writeWoffBillId, (String)"ap_busbill");
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 1);
            BusBillTestChecker.headCheck(busApBill);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill);
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_WriteWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_002_Case2_WriteWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 1);
            BusBillTestChecker.headCheck(writeWoffBill);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill);
        }
    }

    private void case1Check(long busApBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case1_AllWoffBillNo \u6682\u4f30\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP018_001_Case1_AllWoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busApBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ap_busbill");
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case1_AllWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AP018_001_BusApBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP018_001_Case1_AllWoffBillNo\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void deleteBill(String billNo) {
        boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
    }
}

