/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP018_002_BusApBillAutoWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u591a\u5bf9\u591a--\u6682\u4f30\u5e94\u4ed8\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase1() throws InterruptedException {
        this.busApStratProcess(true, false);
        this.busApStratProcess(false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6--\u6682\u4f30\u5e94\u4ed8\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase2() throws InterruptedException {
        this.amtBenchMarkTest(true);
        this.amtBenchMarkTest(false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u5f02\u5e01\u522b--\u6682\u4f30\u5e94\u4ed8\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase3() throws InterruptedException {
        this.busApStratProcess(true, true);
        this.busApStratProcess(false, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AP018_002_BusApBillAutoWoffTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u9a8c\u8bc1\u6279\u91cf\u5ba1\u6838\u5c11\u51b2\u56de\u7684\u573a\u666f")
    @Test
    public void testCase5() throws InterruptedException {
        String busBillNo = "AP018_002_Case5_BusBillNo1";
        String finBillNo1 = "AP018_002_Case5_FinBillNo1";
        String finBillNo2 = "AP018_002_Case5_FinBillNo2";
        String finBillNo3 = "AP018_002_Case5_FinBillNo3";
        this.deleteBill(busBillNo, "ap_busbill");
        this.deleteBill(finBillNo1, "ap_finapbill");
        this.deleteBill(finBillNo2, "ap_finapbill");
        this.deleteBill(finBillNo3, "ap_finapbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busBill = BusBillTestHelper.getAuditBusApBill(busBillNo, false, false, qtys, prices);
        long busBillId = busBill.getLong("id");
        DynamicObject finApBill1 = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busBillId), "C", finBillNo1, BigDecimal.ONE)[0];
        long finBillId1 = finApBill1.getLong("id");
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(BigDecimal.ONE), 1);
        BusBillTestChecker.headCheck(busBill);
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId1)});
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L).multiply(BigDecimal.ONE), 1);
        DynamicObject finApBill2 = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busBillId), "B", finBillNo2, BigDecimal.ONE)[0];
        long finBillId2 = finApBill2.getLong("id");
        DynamicObject finApBill3 = FinApBillTestHelper.fullPushFinArpill("ap_busbill", Collections.singletonList(busBillId), "B", finBillNo3)[0];
        long finBillId3 = finApBill3.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finBillId2, finBillId3});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.headCheck(busBill);
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId2)});
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-2.5), BigDecimal.valueOf(-25L), BigDecimal.valueOf(-25L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L).multiply(BigDecimal.ONE), 1);
        DynamicObject woffBill3 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId3)});
        BusBillTestChecker.entryCheckByWoff(woffBill3, BigDecimal.valueOf(-2.5), BigDecimal.valueOf(-25L), BigDecimal.valueOf(-25L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill3, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L).multiply(BigDecimal.ONE), 1);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finBillId1, finBillId2, finBillId3});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L).multiply(BigDecimal.ONE), 1);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finBillId1, finBillId2, finBillId3});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busBillId});
    }

    private void busApStratProcess(boolean isNewWoff, boolean isUSD) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busApBillNo1 = isUSD ? "AP018_002_Case3_BusApBillNo1" : "AP018_002_Case1_BusApBillNo1";
        String busApBillNo2 = isUSD ? "AP018_002_Case3_BusApBillNo2" : "AP018_002_Case1_BusApBillNo2";
        String finApBillNo1 = isUSD ? "AP018_002_Case3_FinApBillNo1" : "AP018_002_Case1_FinApBillNo1";
        String finApBillNo2 = isUSD ? "AP018_002_Case3_FinApBillNo2" : "AP018_002_Case1_FinApBillNo2";
        this.deleteBill(busApBillNo1, "ap_busbill");
        this.deleteBill(busApBillNo2, "ap_busbill");
        this.deleteBill(finApBillNo1, "ap_finapbill");
        this.deleteBill(finApBillNo2, "ap_finapbill");
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill1 = BusBillTestHelper.getAuditBusApBill(busApBillNo1, false, isUSD, qtys, prices);
        long busApBillId1 = busApBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busApBill2 = BusBillTestHelper.getAuditBusApBill(busApBillNo2, false, isUSD, qtys, prices);
        long busApBillId2 = busApBill2.getLong("id");
        List<Object> finApIds1 = FinApBillTestHelper.pushFinApBillIds(BigDecimal.valueOf(999999L), "ap_busbill", Arrays.asList(busApBillId1, busApBillId2), "C", finApBillNo1, exchangeRate);
        this.finApBillAuditCheckBusApBill(busApBillId1, busApBillId2, true, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds1, false, exchangeRate);
        List<Object> finApIds2 = FinApBillTestHelper.pushFinApBillIds(null, "ap_busbill", Arrays.asList(busApBillId1, busApBillId2), "C", finApBillNo2, exchangeRate);
        this.finApBillAuditCheckBusApBill(busApBillId1, busApBillId2, false, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds2, false, exchangeRate);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finApIds2.toArray());
        this.finApBillUnAuditCheckBusApBill(busApBillId1, busApBillId2, true, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds2, true, exchangeRate);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finApIds2.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finApIds1.toArray());
        this.finApBillUnAuditCheckBusApBill(busApBillId1, busApBillId2, false, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds1, true, exchangeRate);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finApIds1.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
    }

    private void amtBenchMarkTest(boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busApBillNo1 = "AP018_002_Case2_BusApBillNo1";
        String busApBillNo2 = "AP018_002_Case2_BusApBillNo2";
        String finApBillNo = "AP018_002_Case2_FinApBillNo";
        this.deleteBill(busApBillNo1, "ap_busbill");
        this.deleteBill(busApBillNo2, "ap_busbill");
        this.deleteBill(finApBillNo, "ap_finapbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill1 = BusBillTestHelper.getAuditBusApBill(busApBillNo1, true, false, qtys, prices);
        long busApBillId1 = busApBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busApBill2 = BusBillTestHelper.getAuditBusApBill(busApBillNo2, true, false, qtys, prices);
        long busApBillId2 = busApBill2.getLong("id");
        DynamicObject finApBill = FinApBillTestHelper.fullPushFinApBill("ap_busbill", Arrays.asList(busApBillId1, busApBillId2), finApBillNo)[0];
        long finApBillId = finApBill.getLong("id");
        busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.headCheck(busApBill1);
        BusBillTestChecker.headCheck(busApBill2);
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 1);
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-40L), BigDecimal.valueOf(-40L), 1);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        boolean exists1 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        AP018_002_BusApBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
        boolean exists2 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        AP018_002_BusApBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(1L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(1L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(1L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), 0);
        BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(1L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), 1);
        BusBillTestChecker.headCheck(busApBill1);
        BusBillTestChecker.headCheck(busApBill2);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId1});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId1});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId2});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId2});
    }

    private void finApBillAuditCheckBusApBill(long busApBillId1, long busApBillId2, boolean isFirstPush, BigDecimal exchangeRate) {
        DynamicObject busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        DynamicObject busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        if (isFirstPush) {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(15L), BigDecimal.valueOf(450L), BigDecimal.valueOf(450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        }
    }

    private void finApBillUnAuditCheckBusApBill(long busApBillId1, long busApBillId2, boolean isFirstUnAudit, BigDecimal exchangeRate) {
        DynamicObject busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        DynamicObject busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        if (isFirstUnAudit) {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(15L), BigDecimal.valueOf(450L), BigDecimal.valueOf(450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        }
    }

    private void checkWoffBill(long busApBillId1, long busApBillId2, List<Object> finApIds, boolean isReverse, BigDecimal exchangeRate) {
        if (isReverse) {
            boolean exists1 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "in", finApIds)});
            AP018_002_BusApBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
            boolean exists2 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "in", finApIds)});
            AP018_002_BusApBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        } else {
            DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "in", finApIds)});
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L).multiply(exchangeRate), 1);
            DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "in", finApIds)});
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-15L), BigDecimal.valueOf(-450L), BigDecimal.valueOf(-450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L).multiply(exchangeRate), 1);
        }
    }

    private void deleteBill(String billNo, String entityKey) {
        boolean exists = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
    }
}

