/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.ApInvoiceBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP018_008_BusApBill2Invoice2WriteTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6--\u6682\u4f30\u5e94\u4ed8\u5355--\u6536\u7968\u5355--\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.busApStratProcess(true, false, false);
        this.busApStratProcess(false, false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6--\u6682\u4f30\u5e94\u4ed8\u5355--\u6536\u7968\u5355--\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.busApStratProcess(true, true, false);
        this.busApStratProcess(false, true, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5f02\u5e01\u522b--\u6682\u4f30\u5e94\u4ed8\u5355--\u6536\u7968\u5355--\u8d22\u52a1\u5e94\u4ed8\u5355--\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        this.busApStratProcess(true, false, true);
        this.busApStratProcess(false, false, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AP018_008_BusApBill2Invoice2WriteTest.assertEquals((int)1, (int)1);
    }

    private void busApStratProcess(boolean isNewWoff, boolean isAmtBenckMark, boolean isUSD) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busApBillNo1 = "AP018_008_Case1_BusApBillNo1";
        String busApBillNo2 = "AP018_008_Case1_BusApBillNo2";
        String finApBillNo = "AP018_008_Case1_FinApBillNo";
        if (isAmtBenckMark) {
            busApBillNo1 = "AP018_008_Case2_BusApBillNo1";
            busApBillNo2 = "AP018_008_Case2_BusApBillNo2";
            finApBillNo = "AP018_008_Case2_FinApBillNo";
        }
        if (isUSD) {
            busApBillNo1 = "AP018_008_Case3_BusApBillNo1";
            busApBillNo2 = "AP018_008_Case3_BusApBillNo2";
            finApBillNo = "AP018_008_Case3_FinApBillNo";
        }
        this.deleteBill(busApBillNo1, "ap_busbill");
        this.deleteBill(busApBillNo2, "ap_busbill");
        this.deleteBill(finApBillNo, "ap_finapbill");
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        BigDecimal[] qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busApBill1 = BusBillTestHelper.getAuditBusApBill(busApBillNo1, isAmtBenckMark, isUSD, qtys, prices);
        long busApBillId1 = busApBill1.getLong("id");
        qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(40L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busApBill2 = BusBillTestHelper.getAuditBusApBill(busApBillNo2, isAmtBenckMark, isUSD, qtys, prices);
        long busApBillId2 = busApBill2.getLong("id");
        ApInvoiceBillTestHelper.setAP001(BaseDataTestProvider.getDetailInitOrg().getLong("id"), false);
        List<Long> invoiceIds = ApInvoiceBillTestHelper.pushInvoiceAndAudit("ap_busbill", Arrays.asList(busApBillId1, busApBillId2));
        List<Object> finApIds = FinApBillTestHelper.pushFinApBillIds(null, "ap_invoice", invoiceIds, "C", finApBillNo, exchangeRate);
        ArrayList<Long> finApWriteBillIds = new ArrayList<Long>(2);
        for (Object finApId : finApIds) {
            long finApBillId = (Long)finApId;
            FinApBillTestHelper.executeWriteOff(finApBillId);
            finApWriteBillIds.add(FinApBillTestHelper.getWriteOffBillId(finApBillId));
        }
        this.WriteCheckBusApBill(busApBillId1, busApBillId2, false, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds, false, isAmtBenckMark, exchangeRate);
        this.checkWriteWoffBill(busApBillId1, busApBillId2, finApWriteBillIds, false, isAmtBenckMark, exchangeRate);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finApWriteBillIds.toArray());
        this.WriteCheckBusApBill(busApBillId1, busApBillId2, true, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busApBillId1, busApBillId2, finApIds, true, isAmtBenckMark, exchangeRate);
        this.checkWriteWoffBill(busApBillId1, busApBillId2, finApWriteBillIds, true, isAmtBenckMark, exchangeRate);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finApIds.toArray());
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finApIds.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ap_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("delete", "ap_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
    }

    private void WriteCheckBusApBill(long busApBillId1, long busApBillId2, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        DynamicObject busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        DynamicObject busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        if (isReverse) {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busApBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(40L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(busApBill1);
            BusBillTestChecker.headCheck(busApBill2);
        }
    }

    private void checkWoffBill(long busApBillId1, long busApBillId2, List<Object> finApIds, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "in", finApIds)});
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "in", finApIds)});
        if (isReverse) {
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-10L), isAmtBenchMark ? BigDecimal.valueOf(-10L) : BigDecimal.valueOf(-100L), isAmtBenchMark ? BigDecimal.valueOf(-10L) : BigDecimal.valueOf(-100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-20L), isAmtBenchMark ? BigDecimal.valueOf(-20L) : BigDecimal.valueOf(-400L), isAmtBenchMark ? BigDecimal.valueOf(-20L) : BigDecimal.valueOf(-400L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill1);
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-30L), isAmtBenchMark ? BigDecimal.valueOf(-30L) : BigDecimal.valueOf(-900L), isAmtBenchMark ? BigDecimal.valueOf(-30L) : BigDecimal.valueOf(-900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-40L), isAmtBenchMark ? BigDecimal.valueOf(-40L) : BigDecimal.valueOf(-1600L), isAmtBenchMark ? BigDecimal.valueOf(-40L) : BigDecimal.valueOf(-1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill2);
        } else {
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill1);
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill2);
        }
    }

    private void checkWriteWoffBill(long busApBillId1, long busApBillId2, List<Long> writeOffBillIds, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        if (isReverse) {
            boolean exists1 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busApBillId1), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u9500\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
            boolean exists2 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busApBillId2), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u9500\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        } else {
            DynamicObject writeWoffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busApBillId1), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill1.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(writeWoffBill1);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill1);
            DynamicObject writeWoffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busApBillId2), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill2.getBoolean("isadjust"));
            AP018_008_BusApBill2Invoice2WriteTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(40L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(writeWoffBill2);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill2);
        }
    }

    private void deleteBill(String billNo, String entityKey) {
        boolean exists = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
    }
}

