/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AP018_021_BusApBillSameSrcWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 5000L;
    DynamicObject org;
    long currencyId;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        this.currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("ap_004", "1");
        SystemParameterHelper.setSystemParameter(false, this.org.getLong("id"), params);
        Object ap_004 = SystemParameterHelper.getAPAppParameter(this.org.getLong("id"), "ap_004");
        AP018_021_BusApBillSameSrcWoffTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5355\u5230\u51b2\u56de\u5173\u95ed\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u51b2\u56de"), (boolean)"1".equals(ap_004));
        String sql = "UPDATE t_ap_stdconfig SET fvalue = 'false' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u975e\u4f9b\u5e94\u94fe\u6e90\u5355\u540c\u6e90\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6")
    @Test
    public void testCase2() throws InterruptedException {
        String busBillNo = "AP018_021_Case2_busApBillNo";
        String finBillNo = "AP018_021_Case2_finApBillNo";
        this.deleteBill("ap_busbill", new String[]{busBillNo});
        this.deleteBill("ap_finapbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345602L, false);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345602L, false);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinApBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinApBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finWriteBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6\u4e00\u5f20\u6682\u4f30\u4e24\u5f20\u8d22\u52a1")
    @Test
    public void testCase3() throws InterruptedException {
        DynamicObject[] woffBills;
        String busBillNo = "AP018_021_Case3_busApBillNo";
        String finBillNo1 = "AP018_021_Case3_finApBillNo1";
        String finBillNo2 = "AP018_021_Case3_finApBillNo2";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ap_busbill", busBillNos);
        this.deleteBill("ap_finapbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 123456703L, false);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), 123456703L, false);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(7), 123456703L, false);
        Date date = DateUtils.getLastDay(new Date(), 1);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", finBillIds);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") && entry.getInt("seq") == 1) {
                    KDAssert.assertEquals((String)(finBillNo1 + "\u6628\u5929\u8d22\u52a1\u5355\u672a\u5148\u51b2\u56de"), (int)new BigDecimal(-7).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
                }
                if (finBill2.getLong("id") != woffBill.getLong("srcfinbillid") || entry.getInt("seq") != 1) continue;
                KDAssert.assertEquals((String)(finBillNo2 + "\u4eca\u5929\u8d22\u52a1\u5355\u672a\u6b63\u786e\u51b2\u56de"), (int)new BigDecimal(-3).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
            }
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinApBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinApBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u975e\u4f9b\u5e94\u94fe\u6e90\u5355\u540c\u6e90\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6")
    @Test
    public void testCase4() throws InterruptedException {
        String busBillNo = "AP018_021_Case4_busApBillNo";
        String finBillNo = "AP018_021_Case4_finApBillNo";
        this.deleteBill("ap_busbill", new String[]{busBillNo});
        this.deleteBill("ap_finapbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345604L, true);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345604L, true);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinApBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinApBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finWriteBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6\u4e00\u5f20\u6682\u4f30\u4e24\u5f20\u8d22\u52a1")
    @Test
    public void testCase5() throws InterruptedException {
        DynamicObject[] woffBills;
        String busBillNo = "AP018_021_Case5_busApBillNo";
        String finBillNo1 = "AP018_021_Case5_finApBillNo1";
        String finBillNo2 = "AP018_021_Case5_finApBillNo2";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ap_busbill", busBillNos);
        this.deleteBill("ap_finapbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 123456705L, true);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), 123456705L, true);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(7), 123456705L, true);
        Date date = DateUtils.getLastDay(new Date(), 1);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", finBillIds);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") && entry.getInt("seq") == 2) {
                    KDAssert.assertEquals((String)(finBillNo1 + "\u6628\u5929\u8d22\u52a1\u5355\u672a\u5148\u51b2\u56de"), (int)new BigDecimal(7).compareTo(entry.getBigDecimal("e_pricetaxtotal")), (int)0);
                }
                if (finBill2.getLong("id") != woffBill.getLong("srcfinbillid") || entry.getInt("seq") != 2) continue;
                KDAssert.assertEquals((String)(finBillNo2 + "\u4eca\u5929\u8d22\u52a1\u5355\u672a\u6b63\u786e\u51b2\u56de"), (int)new BigDecimal(3).compareTo(entry.getBigDecimal("e_pricetaxtotal")), (int)0);
            }
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinApBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinApBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u540c\u6e90\u51b2\u56de\uff1a\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase6() throws InterruptedException {
        String busBillNo = "AP018_021_Case6_busApBillNo";
        String finBillNo = "AP018_021_Case6_finApBillNo";
        this.deleteBill("ap_busbill", new String[]{busBillNo});
        this.deleteBill("ap_finapbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345606L, false);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345606L, false);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinApBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinApBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        Map<String, Object> busResult = BOTPHelper.push4Result("ap_busbill", "ap_busbill", "712748085842822144", Collections.singletonList(busBill.getLong("id")));
        Object convertBusArResult = busResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AP018_021_BusApBillSameSrcWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busBills = (List)busResult.get("trgBills");
        BusBillTestHelper.executeOperation("save", "ap_busbill", busBills.toArray(new DynamicObject[0]));
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
        try {
            BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finWriteBillId});
        }
        catch (Exception e) {
            AP018_021_BusApBillSameSrcWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
        }
    }

    @TestMethod(value=7)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6\u540c\u6e90\u51b2\u56de\uff1a\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase7() throws InterruptedException {
        String busBillNo = "AP018_021_Case7_busApBillNo";
        String finBillNo = "AP018_021_Case7_finApBillNo";
        this.deleteBill("ap_busbill", new String[]{busBillNo});
        this.deleteBill("ap_finapbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345607L, true);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345607L, true);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinApBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinApBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        Map<String, Object> busResult = BOTPHelper.push4Result("ap_busbill", "ap_busbill", "712748085842822144", Collections.singletonList(busBill.getLong("id")));
        Object convertBusArResult = busResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AP018_021_BusApBillSameSrcWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busBills = (List)busResult.get("trgBills");
        BusBillTestHelper.executeOperation("save", "ap_busbill", busBills.toArray(new DynamicObject[0]));
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        try {
            BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finWriteBillId});
        }
        catch (Exception e) {
            AP018_021_BusApBillSameSrcWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
        }
    }

    private DynamicObject prepareBusBill(String billNo, BigDecimal number, Long srcbillid, boolean isAmtBenchMark) {
        ArrayList<BusApBillDataDetailVO> busEntryList = new ArrayList<BusApBillDataDetailVO>(2);
        BusApBillDataDetailVO busDetailVO1 = BusApBillDataDetailVO.New().setSeq(1);
        BusApBillDataDetailVO busDetailVO2 = BusApBillDataDetailVO.New().setSeq(2);
        if (isAmtBenchMark) {
            busDetailVO1 = busDetailVO1.setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
            busDetailVO2 = busDetailVO2.setQuantity(BigDecimal.valueOf(-1L)).setPrice(number);
        } else {
            busDetailVO1 = busDetailVO1.setQuantity(number).setPrice(BigDecimal.TEN);
            busDetailVO2 = busDetailVO2.setQuantity(number.negate()).setPrice(BigDecimal.valueOf(20L));
        }
        busEntryList.add(busDetailVO1);
        busEntryList.add(busDetailVO2);
        BusApBillDataVO busBillInfo = BusApBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE);
        busBillInfo.setBillStatus("C");
        DynamicObject payproperty = BaseDataTestProvider.getPayPropertyByAmtBenchmark();
        if (isAmtBenchMark) {
            busBillInfo.setPayProperty(payproperty);
        }
        DynamicObject busBill = BusApBillTestDataProvider.buildByPriceAndQuantity(busBillInfo, busEntryList);
        busBill.set("sourcebilltype", (Object)"erkai_test");
        for (DynamicObject entry : busBill.getDynamicObjectCollection("entry")) {
            entry.set("e_srcbillid", (Object)srcbillid);
            entry.set("e_srcentryid", (Object)(srcbillid + (long)entry.getInt("seq")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill});
        return busBill;
    }

    private DynamicObject prepareFinBill(String billNo, BigDecimal number, Long srcbillid, boolean isAmtBenchMark) {
        ArrayList<FinApBillDataDetailVO> entryList = new ArrayList<FinApBillDataDetailVO>(2);
        FinApBillDataDetailVO detailVO1 = FinApBillDataDetailVO.New().setSeq(1);
        FinApBillDataDetailVO detailVO2 = FinApBillDataDetailVO.New().setSeq(2);
        if (isAmtBenchMark) {
            detailVO1 = detailVO1.setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
            detailVO2 = detailVO2.setQuantity(BigDecimal.valueOf(-1L)).setPrice(number);
        } else {
            detailVO1 = detailVO1.setQuantity(number).setPrice(BigDecimal.TEN);
            detailVO2 = detailVO2.setQuantity(number.negate()).setPrice(BigDecimal.valueOf(20L));
        }
        entryList.add(detailVO1);
        entryList.add(detailVO2);
        FinApBillDataVO billInfo = FinApBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("B");
        DynamicObject payproperty = BaseDataTestProvider.getPayPropertyByAmtBenchmark();
        if (isAmtBenchMark) {
            billInfo.setPayproperty(payproperty);
        }
        DynamicObject finBill = FinApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
        finBill.set("sourcebilltype", (Object)"erkai_test");
        for (DynamicObject entry : finBill.getDynamicObjectCollection("detailentry")) {
            entry.set("e_sourcebillid", (Object)srcbillid);
            entry.set("e_sourcebillentryid", (Object)(srcbillid + (long)entry.getInt("seq")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ap_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }
}

