/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.ArInvoiceBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AR020_010_BusArBill2Invoice2FinArTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    private final SimulatorTestHelper util = new SimulatorTestHelper(this);
    private IListView listView;
    private long orgId;

    public void initData() {
        super.initData();
        this.listView = (IListView)this.getView();
        this.orgId = BaseDataTestProvider.getDetailInitOrg().getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6--\u6682\u4f30\u5e94\u6536\u5355--\u5f00\u7968\u5355--\u8d22\u52a1\u5e94\u6536\u5355")
    @Test
    public void testCase1() throws InterruptedException {
        this.busArStratProcess(true, false, false);
        this.busArStratProcess(false, false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6--\u6682\u4f30\u5e94\u6536\u5355--\u5f00\u7968\u5355--\u8d22\u52a1\u5e94\u6536\u5355")
    @Test
    public void testCase2() throws InterruptedException {
        this.busArStratProcess(true, true, false);
        this.busArStratProcess(false, true, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5f02\u5e01\u522b--\u6682\u4f30\u5e94\u6536\u5355--\u5f00\u7968\u5355--\u8d22\u52a1\u5e94\u6536\u5355")
    @Test
    public void testCase3() throws InterruptedException {
        this.busArStratProcess(true, false, true);
        this.busArStratProcess(false, false, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AR020_010_BusArBill2Invoice2FinArTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u90e8\u5206\u51b2\u56de\u540e\u51b2\u56de\u5355\u518d\u6b21\u5168\u989d\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase5() throws InterruptedException {
        String busArBillNo = "AP020_001_Case2_busArBillNo";
        String busArAllWoffBillNo = "AP020_002_Case2_PartWoffBillNo";
        this.deleteBill(new String[]{busArBillNo});
        this.deleteBill(new String[]{busArAllWoffBillNo});
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo, false, false, qtys, prices);
        Long busArBillId = busArBill.getLong("id");
        BusBillTestHelper.pushBusArBill(BigDecimal.valueOf(400L), "ar_busbill", Collections.singletonList(busArBillId), "C", busArAllWoffBillNo, "697561685841434624");
        this.partBusArStratProcess(busArBillId);
    }

    private void busArStratProcess(boolean isNewWoff, boolean isAmtBenckMark, boolean isUSD) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busArBillNo1 = "AR020_010_Case1_busArBillNo1";
        String busArBillNo2 = "AR020_010_Case1_busArBillNo2";
        String finArBillNo = "AR020_010_Case1_finArBillNo";
        if (isAmtBenckMark) {
            busArBillNo1 = "AR020_010_Case2_busArBillNo1";
            busArBillNo2 = "AR020_010_Case2_busArBillNo2";
            finArBillNo = "AR020_010_Case2_finArBillNo";
        }
        if (isUSD) {
            busArBillNo1 = "AR020_010_Case3_busArBillNo1";
            busArBillNo2 = "AR020_010_Case3_busArBillNo2";
            finArBillNo = "AR020_010_Case3_finArBillNo";
        }
        this.deleteBill(new String[]{busArBillNo1, busArBillNo2, finArBillNo});
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        BigDecimal[] qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        long[] taxrateIds = new long[]{1L, 1L};
        long busArBillId1 = BusBillTestHelper.getBusArBillView(this.listView, this.util, this.orgId, busArBillNo1, isAmtBenckMark, isUSD, qtys, prices, taxrateIds);
        qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(40L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        long busArBillId2 = BusBillTestHelper.getBusArBillView(this.listView, this.util, this.orgId, busArBillNo2, isAmtBenckMark, isUSD, qtys, prices, taxrateIds);
        ArInvoiceBillTestHelper.setAR001(this.orgId, false);
        List<Long> invoiceIds = ArInvoiceBillTestHelper.pushInvoiceAndAudit("ar_busbill", Arrays.asList(busArBillId1, busArBillId2), null);
        Long[] FinArIds = FinArBillTestHelper.pushFinArBillIds(null, "ar_invoice", invoiceIds, "C", finArBillNo, exchangeRate);
        this.checkbusArBill(busArBillId1, busArBillId2, false, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, FinArIds, false, isAmtBenckMark, exchangeRate);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", Arrays.stream(FinArIds).toArray());
        this.checkbusArBill(busArBillId1, busArBillId2, true, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, FinArIds, true, isAmtBenckMark, exchangeRate);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", Arrays.stream(FinArIds).toArray());
        BusBillTestHelper.executeOperation("unaudit", "ar_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("delete", "ar_invoice", invoiceIds.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
    }

    private void checkbusArBill(long busArBillId1, long busArBillId2, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        if (isReverse) {
            BusBillTestChecker.entryCheckByWoff(busArBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenchMark ? BigDecimal.valueOf(11.3) : BigDecimal.valueOf(113L), isAmtBenchMark ? BigDecimal.valueOf(11.3) : BigDecimal.valueOf(113L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L), isAmtBenchMark ? BigDecimal.valueOf(22.6) : BigDecimal.valueOf(452L), isAmtBenchMark ? BigDecimal.valueOf(22.6) : BigDecimal.valueOf(452L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenchMark ? BigDecimal.valueOf(33.9) : BigDecimal.valueOf(1017L), isAmtBenchMark ? BigDecimal.valueOf(33.9) : BigDecimal.valueOf(1017L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(40L), isAmtBenchMark ? BigDecimal.valueOf(45.2) : BigDecimal.valueOf(1808L), isAmtBenchMark ? BigDecimal.valueOf(45.2) : BigDecimal.valueOf(1808L).multiply(exchangeRate), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
    }

    private void checkWoffBill(long busArBillId1, long busArBillId2, Long[] FinArIds, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        if (isReverse) {
            boolean exists1 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)FinArIds)});
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
            boolean exists2 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)FinArIds)});
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        } else {
            DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)FinArIds)});
            DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)FinArIds)});
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("isadjust"));
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-10L), isAmtBenchMark ? BigDecimal.valueOf(-11.3) : BigDecimal.valueOf(-113L), isAmtBenchMark ? BigDecimal.valueOf(-11.3) : BigDecimal.valueOf(-113L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-20L), isAmtBenchMark ? BigDecimal.valueOf(-22.6) : BigDecimal.valueOf(-452L), isAmtBenchMark ? BigDecimal.valueOf(-22.6) : BigDecimal.valueOf(-452L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill1);
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("isadjust"));
            AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-30L), isAmtBenchMark ? BigDecimal.valueOf(-33.9) : BigDecimal.valueOf(-1017L), isAmtBenchMark ? BigDecimal.valueOf(-33.9) : BigDecimal.valueOf(-1017L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-40L), isAmtBenchMark ? BigDecimal.valueOf(-45.2) : BigDecimal.valueOf(-1808L), isAmtBenchMark ? BigDecimal.valueOf(-45.2) : BigDecimal.valueOf(-1808L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill2);
        }
    }

    private void deleteBill(String[] billNos) {
        boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        if (exists) {
            DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        }
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }

    private void partBusArStratProcess(Long busBillId) throws InterruptedException {
        ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        BigDecimal exchangeRate = BigDecimal.ONE;
        String finArBillNo = "AR020_010_Case5_finArBillNo";
        ArInvoiceBillTestHelper.setAR001(this.orgId, false);
        DynamicObject arInvoiceBill = ArInvoiceBillTestHelper.pushInvoice("ar_busbill", Collections.singletonList(busBillId), exchangeRate);
        long arInvoiceBillId = arInvoiceBill.getLong("id");
        DynamicObject finArBill = FinArBillTestHelper.fullPushFinArBill("ar_invoice", Collections.singletonList(arInvoiceBillId), finArBillNo, exchangeRate)[0];
        long finArBillId = finArBill.getLong("id");
        DynamicObjectCollection woffBills = QueryServiceHelper.query((String)"ar_busbill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("srcfinbillid", "=", (Object)finArBillId)});
        Long sourcebillid = ((DynamicObject)woffBills.get(0)).getLong("sourcebillid");
        AR020_010_BusArBill2Invoice2FinArTest.assertEquals((String)"\u51b2\u56de\u6709\u8bef\uff0c\u51b2\u56de\u5339\u914d\u9519\u8bef", (Object)busBillId, (Object)sourcebillid);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", new Object[]{finArBillId});
        BusBillTestHelper.executeOperation("unaudit", "ar_invoice", new Object[]{arInvoiceBillId});
        BusBillTestHelper.executeOperation("delete", "ar_invoice", new Object[]{arInvoiceBillId});
    }
}

