/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR020_020_BusArBillGroupWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    DynamicObject org;
    long currencyId;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        this.currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        Map<String, Object> params = new HashMap<String, Object>(2);
        params.put("ar_004", "1");
        String condition = "{\"exprTran\":\"\u5355\u636e\u7f16\u53f7 \u4ee5\u2026\u2026\u5f00\u59cb AR020_020_\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"40H23JSI7GVA\",\"leftBracket\":\"\",\"compareType\":\"60\",\"fieldName\":\"billno\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"40H23JSI7HIK\",\"value\":\"AR020_020_\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"40H23JSI7GVA\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"60\\\",\\\"fieldName\\\":\\\"billno\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"40H23JSI7HIK\\\",\\\"value\\\":\\\"AR020_020_\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u5355\u636e\u7f16\u53f7 \u4ee5\u2026\u2026\u5f00\u59cb AR020_020_\"},\"exprDesc\":\"\u5355\u636e\u7f16\u53f7 \u4ee5\u2026\u2026\u5f00\u59cb AR020_020_\"}";
        params.put("ar_0041", true);
        params.put("ar0041_condition", "\u5355\u636e\u7f16\u53f7 \u4ee5\u2026\u2026\u5f00\u59cb AR020_020_");
        params.put("ar0041_conditionvalue", condition);
        params.put("ar_0042", true);
        params.put("ar0042_condition", "\u5355\u636e\u7f16\u53f7 \u4ee5\u2026\u2026\u5f00\u59cb AR020_020_");
        params.put("ar0042_conditionvalue", condition);
        SystemParameterHelper.setSystemParameter(true, this.org.getLong("id"), params);
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(this.org.getLong("id"));
        Map<Long, Map<String, Object>> orgMaps = SystemParameterHelper.batchGetAppParameters(Boolean.TRUE, orgIds, "ar_004", "ar_0041", "ar0041_conditionvalue", "ar_0042", "ar0042_conditionvalue");
        params = orgMaps.get(this.org.getLong("id"));
        AR020_020_BusArBillGroupWoffTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5355\u5230\u51b2\u56de\u5173\u95ed\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u51b2\u56de"), (boolean)"1".equals(params.get("ar_004")));
        String sql = "UPDATE t_ap_stdconfig SET fvalue = 'false' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6210\u7ec4\u51b2\u56de")
    @Test
    public void testCase2() throws InterruptedException {
        DynamicObject[] woffBills;
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case2_busArBillNo1";
        String busBillNo2 = "AR020_020_Case2_busArBillNo2";
        String busBillNo3 = "AR020_020_Case2_busArBillNo3";
        String busBillNo4 = "AR020_020_Case2_busArBillNo4";
        String busBillNo5 = "AR020_020_Case2_busArBillNo5";
        String busBillNo6 = "AR020_020_Case2_busArBillNo6";
        String finBillNo1 = "AR020_020_Case2_finArBillNo1";
        String finBillNo2 = "AR020_020_Case2_finArBillNo2";
        String finBillNo3 = "AR020_020_Case2_finArBillNo3";
        String finBillNo4 = "AR020_020_Case2_finArBillNo4";
        String finBillNo5 = "AR020_020_Case2_finArBillNo5";
        String finBillNo6 = "AR020_020_Case2_finArBillNo6";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3, busBillNo4, busBillNo5, busBillNo6};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2, finBillNo3, finBillNo4, finBillNo5, finBillNo6});
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, BigDecimal.TEN, "woffcorebill1", "woffgroup1", false);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, BigDecimal.TEN, "woffcorebill2", "woffgroup2", true);
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, BigDecimal.TEN, "woffcorebill3", "woffgroup3", false);
        DynamicObject busBill4 = this.prepareBusBill(busBillNo4, BigDecimal.TEN, "woffcorebill3", "woffgroup3", true);
        DynamicObject busBill5 = this.prepareBusBill(busBillNo5, BigDecimal.TEN, "woffcorebill5", "", false);
        DynamicObject busBill6 = this.prepareBusBill(busBillNo6, BigDecimal.TEN, "woffcorebill6", "woffgroup6", true);
        Object[] busBillIds = new Object[]{busBill1.getLong("id"), busBill2.getLong("id"), busBill3.getLong("id"), busBill4.getLong("id"), busBill5.getLong("id"), busBill6.getLong("id")};
        DynamicObject finBill6 = this.prepareFinBill(finBillNo6, BigDecimal.TEN, "woffcorebill6", "", true);
        DynamicObject finBill5 = this.prepareFinBill(finBillNo5, BigDecimal.TEN, "woffcorebill5", "woffgroup5", false);
        DynamicObject finBill4 = this.prepareFinBill(finBillNo4, BigDecimal.TEN, "woffcorebill3", "woffgroup3", true);
        DynamicObject finBill3 = this.prepareFinBill(finBillNo3, BigDecimal.TEN, "woffcorebill3", "woffgroup3", false);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, BigDecimal.TEN, "woffcorebill2", "woffgroup2", true);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, BigDecimal.TEN, "woffcorebill1", "woffgroup1", false);
        Object[] finBillIds = new Long[]{finBill6.getLong("id"), finBill5.getLong("id"), finBill4.getLong("id"), finBill3.getLong("id"), finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        }
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            if (busBillNo1.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo1 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo2.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo2 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill2.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo3.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo3 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill3.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo4.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo4 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill4.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo5.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo5 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill5.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (!busBillNo6.equals(woffBill.getString("sourcebillno"))) continue;
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo6 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill6.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object object : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)object);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)object));
        }
        Thread.sleep(20000L);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u4e00\u5f20\u6682\u4f30\u4e24\u5f20\u8d22\u52a1")
    @Test
    public void testCase3() throws InterruptedException {
        DynamicObject[] woffBills;
        String busBillNo = "AR020_020_Case3_busArBillNo";
        String finBillNo1 = "AR020_020_Case3_finArBillNo1";
        String finBillNo2 = "AR020_020_Case3_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, "woffcorebill31", "woffgroup31");
        long busBillId = busBill.getLong("id");
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), "woffcorebill31", "woffgroup31");
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(7), "woffcorebill31", "woffgroup31");
        Date date = DateUtils.getLastDay(new Date(), 1);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (finBill1.getLong("id") == woffBill.getLong("srcfinbillid")) {
                    KDAssert.assertEquals((String)(finBillNo1 + "\u6628\u5929\u8d22\u52a1\u5355\u672a\u5148\u51b2\u56de"), (int)new BigDecimal(-7).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
                }
                if (finBill2.getLong("id") != woffBill.getLong("srcfinbillid")) continue;
                KDAssert.assertEquals((String)(finBillNo2 + "\u4eca\u5929\u8d22\u52a1\u5355\u672a\u6b63\u786e\u51b2\u56de"), (int)new BigDecimal(-3).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
            }
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBillId});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6210\u7ec4\u51b2\u56de\uff1a\u5176\u4ed6\u5e94\u6536")
    @Test
    public void testCase4() throws InterruptedException {
        String busBillNo = "AR020_020_Case4_busArBillNo";
        String finBillNo = "AR020_020_Case4_finArBillNo";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, "woffcorebill41", "woffgroup41");
        busBill.set("billtype", (Object)665765867887304704L);
        busBill.set("asstacttype", (Object)"bd_supplier");
        busBill.set("asstact", (Object)supplier);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill});
        long busBillId = busBill.getLong("id");
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, "woffcorebill41", "woffgroup41");
        finBill.set("billtype", (Object)580984824236356608L);
        finBill.set("asstacttype", (Object)"bd_supplier");
        finBill.set("asstact", (Object)supplier);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        Object[] finBillIds = new Long[]{finBill.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)(busBillNo + "\u672a\u51b2\u56de"), (boolean)true, (woffBills.length > 0 ? 1 : 0) != 0);
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.TEN, new BigDecimal(100), new BigDecimal(100), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBillId});
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6210\u7ec4\u51b2\u56de\uff1a\u7ea2\u5b57")
    @Test
    public void testCase5() throws InterruptedException {
        DynamicObject[] woffBills;
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case5_busArBillNo1";
        String busBillNo2 = "AR020_020_Case5_busArBillNo2";
        String busBillNo3 = "AR020_020_Case5_busArBillNo3";
        String busBillNo4 = "AR020_020_Case5_busArBillNo4";
        String finBillNo1 = "AR020_020_Case5_finArBillNo1";
        String finBillNo2 = "AR020_020_Case5_finArBillNo2";
        String finBillNo3 = "AR020_020_Case5_finArBillNo3";
        String finBillNo4 = "AR020_020_Case5_finArBillNo4";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3, busBillNo4};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2, finBillNo3, finBillNo4});
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, BigDecimal.ONE, "woffcorebill5", "woffgroup5");
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, BigDecimal.ONE, "woffcorebill5", "woffgroup5");
        busBill2.set("payproperty", (Object)payproperty);
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(-1), "woffcorebill5", "woffgroup5");
        DynamicObject busBill4 = this.prepareBusBill(busBillNo4, new BigDecimal(-1), "woffcorebill5", "woffgroup5");
        busBill4.set("payproperty", (Object)payproperty);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2, busBill4});
        Object[] busBillIds = new Object[]{busBill1.getLong("id"), busBill2.getLong("id"), busBill3.getLong("id"), busBill4.getLong("id")};
        DynamicObject finBill4 = this.prepareFinBill(finBillNo4, new BigDecimal(-1), "woffcorebill5", "woffcorebill5");
        finBill4.set("payproperty", (Object)payproperty);
        DynamicObject finBill3 = this.prepareFinBill(finBillNo3, new BigDecimal(-1), "woffcorebill5", "woffcorebill5");
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, BigDecimal.ONE, "woffcorebill5", "woffcorebill5");
        finBill2.set("payproperty", (Object)payproperty);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill4, finBill2});
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, BigDecimal.ONE, "woffcorebill5", "woffcorebill5");
        Object[] finBillIds = new Long[]{finBill4.getLong("id"), finBill3.getLong("id"), finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        }
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            if (busBillNo1.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo1 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo2.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo2 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill2.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (busBillNo3.equals(woffBill.getString("sourcebillno"))) {
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo3 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill3.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
            }
            if (!busBillNo4.equals(woffBill.getString("sourcebillno"))) continue;
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBillNo4 + " \u5339\u914d\u8d22\u52a1\u5355\u9519\u8bef"), (boolean)true, (finBill4.getLong("id") == woffBill.getLong("srcfinbillid") ? 1 : 0) != 0);
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object object : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)object);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)object));
        }
        Thread.sleep(20000L);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            if (busBillNo1.equals(dynamicObject.getString("sourcebillno")) || busBillNo2.equals(dynamicObject.getString("sourcebillno"))) {
                BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 0);
                BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 0);
            }
            if (!busBillNo3.equals(dynamicObject.getString("sourcebillno")) && !busBillNo4.equals(dynamicObject.getString("sourcebillno"))) continue;
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(-10), new BigDecimal(-10), 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(-10), new BigDecimal(-10), 0);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            if (busBillNo1.equals(dynamicObject.getString("sourcebillno")) || busBillNo2.equals(dynamicObject.getString("sourcebillno"))) {
                BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 0);
                BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 0);
            }
            if (!busBillNo3.equals(dynamicObject.getString("sourcebillno")) && !busBillNo4.equals(dynamicObject.getString("sourcebillno"))) continue;
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(-10), new BigDecimal(-10), 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(-10), new BigDecimal(-10), 0);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=10)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u4e24\u5f20\u6682\u4f30\u4e00\u5f20\u8d22\u52a1")
    @Test
    public void testCase10() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case10_busArBillNo1";
        String busBillNo2 = "AR020_020_Case10_busArBillNo2";
        String finBillNo = "AR020_020_Case10_finArBillNo";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(8), "woffcorebill_Case10", "woffgroup_Case10");
        Thread.sleep(50L);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(7), "woffcorebill_Case10", "woffgroup_Case10");
        Date date = DateUtils.getLastDay(new Date(), 1);
        busBill1.set("bizdate", (Object)date);
        busBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        Object[] busBillIds = new Object[]{busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, "woffcorebill_Case10", "woffgroup_Case10");
        Object[] finBillIds = new Long[]{finBill.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            }
            if (!busBillNo2.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)2, (int)woffBills.length);
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object object : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)object);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)object));
        }
        Thread.sleep(20000L);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            if (busBillNo1.equals(dynamicObject.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(dynamicObject, new BigDecimal(7), new BigDecimal(70), new BigDecimal(70), 0);
                BusBillTestChecker.entryCheckByInvoice(dynamicObject, new BigDecimal(7), new BigDecimal(70), new BigDecimal(70), 0);
            }
            if (!busBillNo2.equals(dynamicObject.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(dynamicObject, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            if (busBillNo1.equals(dynamicObject.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            }
            if (!busBillNo2.equals(dynamicObject.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(dynamicObject, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            if (busBillNo1.equals(dynamicObject.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(dynamicObject, new BigDecimal(7), new BigDecimal(70), new BigDecimal(70), 0);
                BusBillTestChecker.entryCheckByInvoice(dynamicObject, new BigDecimal(7), new BigDecimal(70), new BigDecimal(70), 0);
            }
            if (!busBillNo2.equals(dynamicObject.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(dynamicObject, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6210\u7ec4\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6\u591a\u5bf9\u591a")
    @Test
    public void testCase11() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case11_busArBillNo1";
        String busBillNo2 = "AR020_020_Case11_busArBillNo2";
        String busBillNo3 = "AR020_020_Case11_busArBillNo3";
        String finBillNo1 = "AR020_020_Case11_finArBillNo1";
        String finBillNo2 = "AR020_020_Case11_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(2), "woffcorebill_Case11", "woffgroup_Case11");
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(3), "woffcorebill_Case11", "woffgroup_Case11");
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(5), "woffcorebill_Case11", "woffgroup_Case11");
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        Object[] busBillIds = new Object[]{busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(3), "woffcorebill_Case11", "woffgroup_Case11");
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(6), "woffcorebill_Case11", "woffgroup_Case11");
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=12)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6210\u7ec4\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6\u591a\u5bf9\u591a")
    @Test
    public void testCase12() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case12_busArBillNo1";
        String busBillNo2 = "AR020_020_Case12_busArBillNo2";
        String busBillNo3 = "AR020_020_Case12_busArBillNo3";
        String finBillNo1 = "AR020_020_Case12_finArBillNo1";
        String finBillNo2 = "AR020_020_Case12_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(20), "woffcorebill_Case12", "woffgroup_Case12", true);
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(30), "woffcorebill_Case12", "woffgroup_Case12", true);
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(50), "woffcorebill_Case12", "woffgroup_Case12", true);
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        Object[] busBillIds = new Object[]{busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(30), "woffcorebill_Case12", "woffgroup_Case12", true);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(60), "woffcorebill_Case12", "woffgroup_Case12", true);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=13)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6210\u7ec4\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6\u5b8c\u5168\u6838\u9500")
    @Test
    public void testCase13() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case13_busArBillNo1";
        String busBillNo2 = "AR020_020_Case13_busArBillNo2";
        String busBillNo3 = "AR020_020_Case13_busArBillNo3";
        String busBillNo4 = "AR020_020_Case13_busArBillNo4";
        String finBillNo1 = "AR020_020_Case13_finArBillNo1";
        String finBillNo2 = "AR020_020_Case13_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3, busBillNo4};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(2), "woffcorebill_Case13", "woffgroup_Case13");
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(3), "woffcorebill_Case13", "woffgroup_Case13");
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(5), "woffcorebill_Case13", "woffgroup_Case13");
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        DynamicObject busBill4 = this.prepareBusBill(busBillNo4, new BigDecimal(4), "woffcorebill_Case13", "woffgroup_Case13");
        Object[] busBillIds = new Object[]{busBill4.getLong("id"), busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), "woffcorebill_Case13", "woffgroup_Case13");
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(9), "woffcorebill_Case13", "woffgroup_Case13");
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        for (DynamicObject entry : finBill1.getDynamicObjectCollection("entry")) {
            entry.set("e_isallverify", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
                continue;
            }
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
                continue;
            }
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            }
            if (!busBillNo4.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 1);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=14)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6210\u7ec4\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6\u5b8c\u5168\u6838\u9500")
    @Test
    public void testCase14() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case14_busArBillNo1";
        String busBillNo2 = "AR020_020_Case14_busArBillNo2";
        String busBillNo3 = "AR020_020_Case14_busArBillNo3";
        String busBillNo4 = "AR020_020_Case14_busArBillNo4";
        String finBillNo1 = "AR020_020_Case14_finArBillNo1";
        String finBillNo2 = "AR020_020_Case14_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(20), "woffcorebill_Case14", "woffgroup_Case14", true);
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(30), "woffcorebill_Case14", "woffgroup_Case14", true);
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(50), "woffcorebill_Case14", "woffgroup_Case14", true);
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        DynamicObject busBill4 = this.prepareBusBill(busBillNo4, new BigDecimal(40), "woffcorebill_Case14", "woffgroup_Case14", true);
        Object[] busBillIds = new Object[]{busBill4.getLong("id"), busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(80), "woffcorebill_Case14", "woffgroup_Case14", true);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(90), "woffcorebill_Case14", "woffgroup_Case14", true);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        for (DynamicObject entry : finBill1.getDynamicObjectCollection("entry")) {
            entry.set("e_isallverify", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            }
            if (!busBillNo4.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
            }
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
            }
            if (!busBillNo4.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            }
            if (!busBillNo4.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
            }
            if (busBillNo3.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
            }
            if (!busBillNo4.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=21)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6838\u5fc3\u5355\u636e\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6\u591a\u5bf9\u591a")
    @Test
    public void testCase21() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case21_busArBillNo1";
        String busBillNo2 = "AR020_020_Case21_busArBillNo2";
        String busBillNo3 = "AR020_020_Case21_busArBillNo3";
        String finBillNo1 = "AR020_020_Case21_finArBillNo1";
        String finBillNo2 = "AR020_020_Case21_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(2), "woffcorebill_Case21", "");
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(3), "woffcorebill_Case21", "");
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(5), "woffcorebill_Case21", "");
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        Object[] busBillIds = new Object[]{busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(3), "woffcorebill_Case21", "");
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(6), "woffcorebill_Case21", "");
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(4), new BigDecimal(40), new BigDecimal(40), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(2), new BigDecimal(20), new BigDecimal(20), 1);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(5), new BigDecimal(50), new BigDecimal(50), 1);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
            BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(3), new BigDecimal(30), new BigDecimal(30), 1);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=22)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u6838\u5fc3\u5355\u636e\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6\u591a\u5bf9\u591a")
    @Test
    public void testCase22() throws InterruptedException {
        DynamicObject[] busBills;
        String busBillNo1 = "AR020_020_Case22_busArBillNo1";
        String busBillNo2 = "AR020_020_Case22_busArBillNo2";
        String busBillNo3 = "AR020_020_Case22_busArBillNo3";
        String finBillNo1 = "AR020_020_Case22_finArBillNo1";
        String finBillNo2 = "AR020_020_Case22_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2, busBillNo3};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        Date date = DateUtils.getLastDay(new Date(), 1);
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, new BigDecimal(20), "woffcorebill_Case22", "", true);
        Date date2 = DateUtils.getLastDay(new Date(), 2);
        busBill1.set("bizdate", (Object)date2);
        busBill1.set("bookdate", (Object)date2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill1});
        DynamicObject busBill3 = this.prepareBusBill(busBillNo3, new BigDecimal(30), "woffcorebill_Case22", "", true);
        Thread.sleep(50L);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, new BigDecimal(50), "woffcorebill_Case22", "", true);
        busBill2.set("bizdate", (Object)date);
        busBill2.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill2});
        Object[] busBillIds = new Object[]{busBill3.getLong("id"), busBill2.getLong("id"), busBill1.getLong("id")};
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(30), "woffcorebill_Case22", "", true);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(60), "woffcorebill_Case22", "", true);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)4, (int)woffBills.length);
        Long finBillId1 = finBill1.getLong("id");
        FinArBillTestHelper.executeWriteOff(finBillId1);
        Long finWriteBillId1 = FinArBillTestHelper.getWriteOffBillId(finBillId1);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(80), new BigDecimal(80), 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId1});
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno")) || busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(10), new BigDecimal(10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType())) {
            if (busBillNo1.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 2);
            }
            if (busBillNo2.equals(busBill.getString("billno"))) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(50), new BigDecimal(50), 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(100), new BigDecimal(100), 2);
            }
            if (!busBillNo3.equals(busBill.getString("billno"))) continue;
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(30), new BigDecimal(30), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, new BigDecimal(60), new BigDecimal(60), 2);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=30)
    @DisplayName(value="\u5386\u53f2\u6838\u5fc3\u5355\u636e\u51b2\u56de\u51b2\u9500")
    @Test
    public void testCase30() throws InterruptedException {
        DynamicObject[] busBills;
        String sql = "UPDATE t_ap_stdconfig SET fvalue = 'true' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "true");
        String busBillNo1 = "AR020_020_Case30_busArBillNo1";
        String busBillNo2 = "AR020_020_Case30_busArBillNo2";
        String finBillNo1 = "AR020_020_Case30_finArBillNo1";
        String finBillNo2 = "AR020_020_Case30_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo1, busBillNo2};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill1 = this.prepareBusBill(busBillNo1, BigDecimal.TEN, "woffcorebill_Case30", "", false);
        DynamicObject busBill2 = this.prepareBusBill(busBillNo2, BigDecimal.TEN, "woffcorebill_Case300", "", true);
        Object[] busBillIds = new Object[]{busBill1.getLong("id"), busBill2.getLong("id")};
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(20), "woffcorebill_Case30", "", false);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(20), "woffcorebill_Case300", "", true);
        Object[] finBillIds = new Long[]{finBill1.getLong("id"), finBill2.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill2.getDynamicObjectType())) {
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, new BigDecimal(-10), new BigDecimal(-10), 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, new BigDecimal(-20), new BigDecimal(-20), 2);
        }
        sql = "UPDATE t_ap_stdconfig SET fvalue = 'false' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object object : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)object);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)object));
        }
        Thread.sleep(20000L);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, new BigDecimal(-10), new BigDecimal(-10), 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ZERO, new BigDecimal(-20), new BigDecimal(-20), 2);
        }
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBills = BusinessDataServiceHelper.load((Object[])busBillIds, (DynamicObjectType)busBill1.getDynamicObjectType());
        for (DynamicObject dynamicObject : busBills) {
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByWoff(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(dynamicObject, BigDecimal.ONE, new BigDecimal(20), new BigDecimal(20), 2);
        }
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", busBillIds);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBillIds);
    }

    @TestMethod(value=31)
    @DisplayName(value="\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase31() throws InterruptedException {
        String busBillNo = "AR020_020_Case31_busArBillNo";
        String finBillNo = "AR020_020_Case31_finArBillNo";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, new BigDecimal(8), "woffcorebill_Case31", "woffgroup_Case31");
        long busBillId = busBill.getLong("id");
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, "woffcorebill_Case31", "woffgroup_Case31");
        Object[] finBillIds = new Long[]{finBill.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.e_quantity,entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)});
        KDAssert.assertEquals((String)"\u51b2\u56de\u5355\u6570\u91cf\u9519\u8bef", (int)1, (int)woffBills.length);
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(20000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
        Map<String, Object> busResult = BOTPHelper.push4Result("ar_busbill", "ar_busbill", "697561685841434624", Collections.singletonList(busBillId));
        Object convertBusArResult = busResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AR020_020_BusArBillGroupWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busBills = (List)busResult.get("trgBills");
        BusBillTestHelper.executeOperation("save", "ar_busbill", busBills.toArray(new DynamicObject[0]));
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, new BigDecimal(8), new BigDecimal(80), new BigDecimal(80), 0);
        try {
            BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        }
        catch (Exception e) {
            AR020_020_BusArBillGroupWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
        }
    }

    private DynamicObject prepareBusBill(String billNo, BigDecimal price, String corebillno, String groupnumber, boolean isAmtBenchMark) {
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        ArrayList<BusArBillDataDetailVO> entryList = new ArrayList<BusArBillDataDetailVO>(4);
        BusArBillDataDetailVO detailVO1 = BusArBillDataDetailVO.New().setSeq(1).setCorebillno(corebillno).setCorebillentryseq(2L).setGroupnumber(groupnumber).setGroupseq("4");
        entryList.add(detailVO1);
        BusArBillDataDetailVO detailVO2 = BusArBillDataDetailVO.New().setSeq(2).setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber).setGroupseq("6");
        entryList.add(detailVO2);
        BusArBillDataDetailVO detailVO3 = BusArBillDataDetailVO.New().setSeq(3).setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        entryList.add(detailVO3);
        for (int i = 0; i < entryList.size(); ++i) {
            BusArBillDataDetailVO detailVO = (BusArBillDataDetailVO)entryList.get(i);
            detailVO.setPrice(price.multiply(BigDecimal.valueOf(i))).setQuantity(BigDecimal.ONE);
        }
        BusArBillDataVO billInfo = BusArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("C");
        if (isAmtBenchMark) {
            billInfo.setPayProperty(payproperty);
        }
        return BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
    }

    private DynamicObject prepareFinBill(String billNo, BigDecimal price, String corebillno, String groupnumber, boolean isAmtBenchMark) {
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        ArrayList<FinArBillDataDetailVO> entryList = new ArrayList<FinArBillDataDetailVO>(4);
        FinArBillDataDetailVO detailVO1 = FinArBillDataDetailVO.New().setSeq(1).setCorebillno(corebillno).setCorebillentryseq(2L).setGroupnumber(groupnumber).setGroupseq("4");
        entryList.add(detailVO1);
        FinArBillDataDetailVO detailVO2 = FinArBillDataDetailVO.New().setSeq(2).setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber).setGroupseq("6");
        entryList.add(detailVO2);
        FinArBillDataDetailVO detailVO3 = FinArBillDataDetailVO.New().setSeq(3).setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        entryList.add(detailVO3);
        for (int i = 0; i < entryList.size(); ++i) {
            FinArBillDataDetailVO detailVO = (FinArBillDataDetailVO)entryList.get(i);
            detailVO.setPrice(price.multiply(BigDecimal.valueOf(i))).setQuantity(BigDecimal.ONE);
        }
        FinArBillDataVO billInfo = FinArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("B");
        if (isAmtBenchMark) {
            billInfo.setPayproperty(payproperty);
        }
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
    }

    private DynamicObject prepareBusBill(String billNo, BigDecimal quantity, String corebillno, String groupnumber) {
        ArrayList<BusArBillDataDetailVO> entryList = new ArrayList<BusArBillDataDetailVO>(4);
        BusArBillDataDetailVO detailVO = BusArBillDataDetailVO.New().setSeq(1).setQuantity(quantity).setPrice(BigDecimal.TEN).setCorebillno(corebillno).setCorebillentryseq(1L).setGroupnumber(groupnumber).setGroupseq("2");
        entryList.add(detailVO);
        BusArBillDataDetailVO detailVO2 = BusArBillDataDetailVO.New().setSeq(2).setQuantity(quantity).setPrice(BigDecimal.TEN).setCorebillno(corebillno).setCorebillentryseq(2L);
        entryList.add(detailVO2);
        BusArBillDataVO billInfo = BusArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE);
        billInfo.setBillStatus("C");
        return BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
    }

    private DynamicObject prepareFinBill(String billNo, BigDecimal quantity, String corebillno, String groupnumber) {
        ArrayList<FinArBillDataDetailVO> entryList = new ArrayList<FinArBillDataDetailVO>(4);
        FinArBillDataDetailVO detailVO = FinArBillDataDetailVO.New().setSeq(1).setQuantity(quantity).setPrice(BigDecimal.TEN).setCorebillno(corebillno).setCorebillentryseq(1L).setGroupnumber(groupnumber).setGroupseq("2");
        entryList.add(detailVO);
        FinArBillDataDetailVO detailVO2 = FinArBillDataDetailVO.New().setSeq(2).setQuantity(quantity).setPrice(BigDecimal.TEN).setCorebillno(corebillno).setCorebillentryseq(2L);
        entryList.add(detailVO2);
        FinArBillDataVO billInfo = FinArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("B");
        return FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }
}

