/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR020_021_BusArBillSameSrcWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 5000L;
    DynamicObject org;
    long currencyId;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        this.currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("ar_004", "1");
        SystemParameterHelper.setSystemParameter(true, this.org.getLong("id"), params);
        Object ar_004 = SystemParameterHelper.getARAppParameter(this.org.getLong("id"), "ar_004");
        AR020_021_BusArBillSameSrcWoffTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5355\u5230\u51b2\u56de\u5173\u95ed\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u51b2\u56de"), (boolean)"1".equals(ar_004));
        String sql = "UPDATE t_ap_stdconfig SET fvalue = 'false' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u975e\u4f9b\u5e94\u94fe\u6e90\u5355\u540c\u6e90\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6")
    @Test
    public void testCase2() throws InterruptedException {
        String busBillNo = "AR020_021_Case2_busArBillNo";
        String finBillNo = "AR020_021_Case2_finArBillNo";
        this.deleteBill("ar_busbill", new String[]{busBillNo});
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345602L, false);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345602L, false);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinArBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinArBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", new Object[]{finBillId});
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6\u4e00\u5f20\u6682\u4f30\u4e24\u5f20\u8d22\u52a1")
    @Test
    public void testCase3() throws InterruptedException {
        DynamicObject[] woffBills;
        String busBillNo = "AR020_021_Case3_busArBillNo";
        String finBillNo1 = "AR020_021_Case3_finArBillNo1";
        String finBillNo2 = "AR020_021_Case3_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 123456703L, false);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), 123456703L, false);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(7), 123456703L, false);
        Date date = DateUtils.getLastDay(new Date(), 1);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") && entry.getInt("seq") == 1) {
                    KDAssert.assertEquals((String)(finBillNo1 + "\u6628\u5929\u8d22\u52a1\u5355\u672a\u5148\u51b2\u56de"), (int)new BigDecimal(-7).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
                }
                if (finBill2.getLong("id") != woffBill.getLong("srcfinbillid") || entry.getInt("seq") != 1) continue;
                KDAssert.assertEquals((String)(finBillNo2 + "\u4eca\u5929\u8d22\u52a1\u5355\u672a\u6b63\u786e\u51b2\u56de"), (int)new BigDecimal(-3).compareTo(entry.getBigDecimal("e_quantity")), (int)0);
            }
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u975e\u4f9b\u5e94\u94fe\u6e90\u5355\u540c\u6e90\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6")
    @Test
    public void testCase4() throws InterruptedException {
        String busBillNo = "AR020_021_Case4_busArBillNo";
        String finBillNo = "AR020_021_Case4_finArBillNo";
        this.deleteBill("ar_busbill", new String[]{busBillNo});
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345604L, true);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345604L, true);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinArBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinArBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finBillId});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", new Object[]{finBillId});
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6309\u8bb0\u8d26\u65e5\u671f\u4f9d\u6b21\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6\u4e00\u5f20\u6682\u4f30\u4e24\u5f20\u8d22\u52a1")
    @Test
    public void testCase5() throws InterruptedException {
        DynamicObject[] woffBills;
        String busBillNo = "AR020_021_Case5_busArBillNo";
        String finBillNo1 = "AR020_021_Case5_finArBillNo1";
        String finBillNo2 = "AR020_021_Case5_finArBillNo2";
        String[] busBillNos = new String[]{busBillNo};
        this.deleteBill("ar_busbill", busBillNos);
        this.deleteBill("ar_finarbill", new String[]{finBillNo1, finBillNo2});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 123456705L, true);
        DynamicObject finBill2 = this.prepareFinBill(finBillNo2, new BigDecimal(8), 123456705L, true);
        Thread.sleep(50L);
        DynamicObject finBill1 = this.prepareFinBill(finBillNo1, new BigDecimal(7), 123456705L, true);
        Date date = DateUtils.getLastDay(new Date(), 1);
        finBill1.set("bizdate", (Object)date);
        finBill1.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill1});
        Object[] finBillIds = new Long[]{finBill2.getLong("id"), finBill1.getLong("id")};
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finBillIds);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        for (DynamicObject woffBill : woffBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillid,sourcebillno,srcfinbillid,entry.seq,entry.e_quantity,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("sourcebillno", "in", (Object)busBillNos)})) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (finBill1.getLong("id") == woffBill.getLong("srcfinbillid") && entry.getInt("seq") == 2) {
                    KDAssert.assertEquals((String)(finBillNo1 + "\u6628\u5929\u8d22\u52a1\u5355\u672a\u5148\u51b2\u56de"), (int)new BigDecimal(7).compareTo(entry.getBigDecimal("e_recamount")), (int)0);
                }
                if (finBill2.getLong("id") != woffBill.getLong("srcfinbillid") || entry.getInt("seq") != 2) continue;
                KDAssert.assertEquals((String)(finBillNo2 + "\u4eca\u5929\u8d22\u52a1\u5355\u672a\u6b63\u786e\u51b2\u56de"), (int)new BigDecimal(3).compareTo(entry.getBigDecimal("e_recamount")), (int)0);
            }
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Object finBillId : finBillIds) {
            FinArBillTestHelper.executeWriteOff((Long)finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId((Long)finBillId));
        }
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finBillIds);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finBillIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBill.getLong("id")});
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u540c\u6e90\u51b2\u56de\uff1a\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase6() throws InterruptedException {
        String busBillNo = "AR020_021_Case6_busArBillNo";
        String finBillNo = "AR020_021_Case6_finArBillNo";
        this.deleteBill("ar_busbill", new String[]{busBillNo});
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345606L, false);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345606L, false);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinArBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinArBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        Map<String, Object> busResult = BOTPHelper.push4Result("ar_busbill", "ar_busbill", "697561685841434624", Collections.singletonList(busBill.getLong("id")));
        Object convertBusArResult = busResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AR020_021_BusArBillSameSrcWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busBills = (List)busResult.get("trgBills");
        BusBillTestHelper.executeOperation("save", "ar_busbill", busBills.toArray(new DynamicObject[0]));
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 1);
        try {
            BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId});
        }
        catch (Exception e) {
            AR020_021_BusArBillSameSrcWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
        }
    }

    @TestMethod(value=7)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6\u540c\u6e90\u51b2\u56de\uff1a\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase7() throws InterruptedException {
        String busBillNo = "AR020_021_Case7_busArBillNo";
        String finBillNo = "AR020_021_Case7_finArBillNo";
        this.deleteBill("ar_busbill", new String[]{busBillNo});
        this.deleteBill("ar_finarbill", new String[]{finBillNo});
        DynamicObject busBill = this.prepareBusBill(busBillNo, BigDecimal.TEN, 12345607L, true);
        DynamicObject finBill = this.prepareFinBill(finBillNo, BigDecimal.TEN, 12345607L, true);
        Long finBillId = finBill.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finBillId});
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        FinArBillTestHelper.executeWriteOff(finBillId);
        long finWriteBillId = FinArBillTestHelper.getWriteOffBillId(finBillId);
        Thread.sleep(5000L);
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        Map<String, Object> busResult = BOTPHelper.push4Result("ar_busbill", "ar_busbill", "697561685841434624", Collections.singletonList(busBill.getLong("id")));
        Object convertBusArResult = busResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AR020_021_BusArBillSameSrcWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busBills = (List)busResult.get("trgBills");
        BusBillTestHelper.executeOperation("save", "ar_busbill", busBills.toArray(new DynamicObject[0]));
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (DynamicObjectType)busBill.getDynamicObjectType());
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 1);
        try {
            BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finWriteBillId});
        }
        catch (Exception e) {
            AR020_021_BusArBillSameSrcWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
        }
    }

    private DynamicObject prepareBusBill(String billNo, BigDecimal number, Long srcbillid, boolean isAmtBenchMark) {
        ArrayList<BusArBillDataDetailVO> busEntryList = new ArrayList<BusArBillDataDetailVO>(2);
        BusArBillDataDetailVO busDetailVO1 = BusArBillDataDetailVO.New().setSeq(1);
        BusArBillDataDetailVO busDetailVO2 = BusArBillDataDetailVO.New().setSeq(2);
        if (isAmtBenchMark) {
            busDetailVO1 = busDetailVO1.setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
            busDetailVO2 = busDetailVO2.setQuantity(BigDecimal.valueOf(-1L)).setPrice(number);
        } else {
            busDetailVO1 = busDetailVO1.setQuantity(number).setPrice(BigDecimal.valueOf(20L));
            busDetailVO2 = busDetailVO2.setQuantity(number.negate()).setPrice(BigDecimal.TEN);
        }
        busEntryList.add(busDetailVO1);
        busEntryList.add(busDetailVO2);
        BusArBillDataVO busBillInfo = BusArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("C");
        DynamicObject recproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        if (isAmtBenchMark) {
            busBillInfo.setPayProperty(recproperty);
        }
        DynamicObject busBill = BusArBillTestDataProvider.buildByPriceAndQuantity(busBillInfo, busEntryList);
        busBill.set("sourcebilltype", (Object)"erkai_test");
        for (DynamicObject entry : busBill.getDynamicObjectCollection("entry")) {
            entry.set("e_srcbillid", (Object)srcbillid);
            entry.set("e_srcentryid", (Object)(srcbillid + (long)entry.getInt("seq")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill});
        return busBill;
    }

    private DynamicObject prepareFinBill(String billNo, BigDecimal number, Long srcbillid, boolean isAmtBenchMark) {
        ArrayList<FinArBillDataDetailVO> entryList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataDetailVO detailVO1 = FinArBillDataDetailVO.New().setSeq(1).setQuantity(number).setPrice(BigDecimal.valueOf(20L));
        FinArBillDataDetailVO detailVO2 = FinArBillDataDetailVO.New().setSeq(2).setQuantity(number.negate()).setPrice(BigDecimal.TEN);
        if (isAmtBenchMark) {
            detailVO1 = detailVO1.setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
            detailVO2 = detailVO2.setQuantity(BigDecimal.valueOf(-1L)).setPrice(number);
        } else {
            detailVO1 = detailVO1.setQuantity(number).setPrice(BigDecimal.valueOf(20L));
            detailVO2 = detailVO2.setQuantity(number.negate()).setPrice(BigDecimal.TEN);
        }
        entryList.add(detailVO1);
        entryList.add(detailVO2);
        FinArBillDataVO billInfo = FinArBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE).setBillStatus("B");
        DynamicObject recproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        if (isAmtBenchMark) {
            billInfo.setPayproperty(recproperty);
        }
        DynamicObject finBill = FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
        finBill.set("sourcebilltype", (Object)"erkai_test");
        for (DynamicObject entry : finBill.getDynamicObjectCollection("entry")) {
            entry.set("e_srcid", (Object)srcbillid);
            entry.set("e_srcentryid", (Object)(srcbillid + (long)entry.getInt("seq")));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
        return finBill;
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }
}

