/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR020_022_BusArBillPrepaidWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    DynamicObject org;
    long currencyId;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        this.currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        Map<String, Object> params = new HashMap<String, Object>(2);
        params.put("ar_004", "1");
        SystemParameterHelper.setSystemParameter(true, this.org.getLong("id"), params);
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(this.org.getLong("id"));
        Map<Long, Map<String, Object>> orgMaps = SystemParameterHelper.batchGetAppParameters(Boolean.TRUE, orgIds, "ar_004");
        params = orgMaps.get(this.org.getLong("id"));
        AR020_022_BusArBillPrepaidWoffTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5355\u5230\u51b2\u56de\u5173\u95ed\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u51b2\u56de"), (boolean)"1".equals(params.get("ar_004")));
        String sql = "UPDATE t_ap_stdconfig SET fvalue = 'false' WHERE fkey = 'woffServiceV2';";
        DB.execute((DBRoute)DBRouteConst.AP, (String)sql);
        ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u4ee3\u57ab\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6")
    @Test
    public void testCase2() throws InterruptedException {
        String busApBillNo = "AR020_022_Case2_busApBillNo";
        String finApBillNo = "AR020_022_Case2_finApBillNo";
        String busArBillNo = "AR020_022_Case2_busArBillNo";
        String finArBillNo = "AR020_022_Case2_finArBillNo";
        this.deleteBill("ap_busbill", new String[]{busApBillNo});
        this.deleteBill("ap_finapbill", new String[]{finApBillNo});
        this.deleteBill("ar_busbill", new String[]{busArBillNo});
        this.deleteBill("ar_finarbill", new String[]{finArBillNo});
        this.testPrepaidWoff(false, false, busApBillNo, finApBillNo, busArBillNo, finArBillNo);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4ee3\u57ab\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6")
    @Test
    public void testCase3() throws InterruptedException {
        String busApBillNo = "AR020_022_Case3_busApBillNo";
        String finApBillNo = "AR020_022_Case3_finApBillNo";
        String busArBillNo = "AR020_022_Case3_busArBillNo";
        String finArBillNo = "AR020_022_Case3_finArBillNo";
        this.deleteBill("ap_busbill", new String[]{busApBillNo});
        this.deleteBill("ap_finapbill", new String[]{finApBillNo});
        this.deleteBill("ar_busbill", new String[]{busArBillNo});
        this.deleteBill("ar_finarbill", new String[]{finArBillNo});
        this.testPrepaidWoff(true, false, busApBillNo, finApBillNo, busArBillNo, finArBillNo);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u4ee3\u57ab\u51b2\u56de\uff1a\u6570\u91cf\u57fa\u51c6-\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase4() throws InterruptedException {
        String busApBillNo = "AR020_022_Case4_busApBillNo";
        String finApBillNo = "AR020_022_Case4_finApBillNo";
        String busArBillNo = "AR020_022_Case4_busArBillNo";
        String finArBillNo = "AR020_022_Case4_finArBillNo";
        this.deleteBill("ap_busbill", new String[]{busApBillNo});
        this.deleteBill("ap_finapbill", new String[]{finApBillNo});
        this.deleteBill("ar_busbill", new String[]{busArBillNo});
        this.deleteBill("ar_finarbill", new String[]{finArBillNo});
        this.testPrepaidWoff(false, true, busApBillNo, finApBillNo, busArBillNo, finArBillNo);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u4ee3\u57ab\u51b2\u56de\uff1a\u91d1\u989d\u57fa\u51c6-\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c")
    @Test
    public void testCase5() throws InterruptedException {
        String busApBillNo = "AR020_022_Case5_busApBillNo";
        String finApBillNo = "AR020_022_Case5_finApBillNo";
        String busArBillNo = "AR020_022_Case5_busArBillNo";
        String finArBillNo = "AR020_022_Case5_finArBillNo";
        this.deleteBill("ap_busbill", new String[]{busApBillNo});
        this.deleteBill("ap_finapbill", new String[]{finApBillNo});
        this.deleteBill("ar_busbill", new String[]{busArBillNo});
        this.deleteBill("ar_finarbill", new String[]{finArBillNo});
        this.testPrepaidWoff(true, true, busApBillNo, finApBillNo, busArBillNo, finArBillNo);
    }

    private void testPrepaidWoff(boolean isAmtBenchMark, boolean isOverValidator, String busApBillNo, String finApBillNo, String busArBillNo, String finArBillNo) throws InterruptedException {
        DynamicObject[] busBills;
        Long busApBillId = this.prepareBusApBill(busApBillNo, BigDecimal.TEN, isAmtBenchMark);
        ArrayList<Long> busApBillIds = new ArrayList<Long>(2);
        busApBillIds.add(busApBillId);
        Map<String, Object> busArResult = BOTPHelper.push4Result("ap_busbill", "ar_busbill", "1736283407375140864", busApBillIds);
        Object convertBusArResult = busArResult.get("convertResult");
        if (convertBusArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
            AR020_022_BusArBillPrepaidWoffTest.assertTrue((String)("\u4ee3\u57ab\u6682\u4f30\u5e94\u4ed8\u4e0b\u63a8\u6682\u4f30\u5e94\u6536\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
        }
        List busArBills = (List)busArResult.get("trgBills");
        ArrayList<Long> busArBillIds = new ArrayList<Long>(2);
        DynamicObject supplier = BaseDataTestProvider.getSupplier();
        for (DynamicObject busArBill : busArBills) {
            busArBillIds.add(busArBill.getLong("id"));
            busArBill.set("billno", (Object)busArBillNo);
            busArBill.set("asstact", (Object)supplier);
        }
        BusBillTestHelper.executeOperation("submit", "ar_busbill", busArBills.toArray(new DynamicObject[0]));
        BusBillTestHelper.executeOperation("audit", "ar_busbill", busArBillIds.toArray());
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", busApBillIds, finApBillNo);
        ArrayList<Long> finApBillIds = new ArrayList<Long>(2);
        for (DynamicObject finApBill : finApBills) {
            finApBillIds.add(finApBill.getLong("id"));
        }
        Thread.sleep(20000L);
        Map<String, Object> finArResult = BOTPHelper.push4Result("ap_finapbill", "ar_finarbill", "1732651344373769216", finApBillIds);
        Object convertfinArResult = busArResult.get("convertResult");
        if (convertfinArResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertfinArResult;
            AR020_022_BusArBillPrepaidWoffTest.assertTrue((String)("\u4ee3\u57ab\u8d22\u52a1\u5e94\u4ed8\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertfinArResult != null ? 1 : 0) != 0);
        }
        List finArBills = (List)finArResult.get("trgBills");
        ArrayList<Long> finArBillIds = new ArrayList<Long>(2);
        for (DynamicObject[] finArBill : finArBills) {
            finArBillIds.add(finArBill.getLong("id"));
            finArBill.set("billno", (Object)finArBillNo);
            finArBill.set("asstact", (Object)supplier);
        }
        BusBillTestHelper.executeOperation("submit", "ar_finarbill", finArBills.toArray(new DynamicObject[0]));
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finArBillIds.toArray());
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busArBillIds.toArray(), (DynamicObjectType)((DynamicObject)busArBills.get(0)).getDynamicObjectType())) {
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
        ArrayList<Long> finWriteBillIds = new ArrayList<Long>(2);
        for (Long finBillId : finArBillIds) {
            FinArBillTestHelper.executeWriteOff(finBillId);
            finWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId(finBillId));
        }
        Thread.sleep(20000L);
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busArBillIds.toArray(), (DynamicObjectType)((DynamicObject)busArBills.get(0)).getDynamicObjectType())) {
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
        }
        if (isOverValidator) {
            Map<String, Object> busResult = BOTPHelper.push4Result("ar_busbill", "ar_busbill", "697561685841434624", busArBillIds);
            convertBusArResult = busResult.get("convertResult");
            if (convertBusArResult != null) {
                ConvertOperationResult result = (ConvertOperationResult)convertBusArResult;
                AR020_022_BusArBillPrepaidWoffTest.assertTrue((String)("\u6682\u4f30\u624b\u5de5\u51b2\u56de\u9519\u8bef\uff1a" + BOTPHelper.getConvertReport(result)), (convertBusArResult != null ? 1 : 0) != 0);
            }
            List selfBusBills = (List)busResult.get("trgBills");
            BusBillTestHelper.executeOperation("save", "ar_busbill", selfBusBills.toArray(new DynamicObject[0]));
            for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busArBillIds.toArray(), (DynamicObjectType)((DynamicObject)busArBills.get(0)).getDynamicObjectType())) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            }
            try {
                BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
            }
            catch (Exception e) {
                AR020_022_BusArBillPrepaidWoffTest.assertTrue((String)"\u8d22\u52a1\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5355\u51b2\u56de\u989d\u5ea6\u6821\u9a8c\u5931\u8d25", (boolean)e.getMessage().startsWith("\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30"));
            }
        } else {
            BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finWriteBillIds.toArray());
            for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busArBillIds.toArray(), (DynamicObjectType)((DynamicObject)busArBills.get(0)).getDynamicObjectType())) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            }
            BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finArBillIds.toArray());
            for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((Object[])busArBillIds.toArray(), (DynamicObjectType)((DynamicObject)busArBills.get(0)).getDynamicObjectType())) {
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, 0);
                BusBillTestChecker.entryCheckByInvoice(busBill, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.TEN, 1);
            }
        }
    }

    private Long prepareBusApBill(String billNo, BigDecimal price, boolean isAmtBenchMark) {
        ArrayList<BusApBillDataDetailVO> entryList = new ArrayList<BusApBillDataDetailVO>(4);
        BusApBillDataDetailVO detailVO1 = BusApBillDataDetailVO.New().setSeq(1).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
        entryList.add(detailVO1);
        BusApBillDataDetailVO detailVO2 = BusApBillDataDetailVO.New().setSeq(2).setQuantity(BigDecimal.ONE).setPrice(price);
        entryList.add(detailVO2);
        BusApBillDataVO billInfo = BusApBillDataVO.New().setOrg(this.org).setBillNo(billNo).setCurrency(this.currencyId).setExchangerate(BigDecimal.ONE);
        billInfo.setBillStatus("C");
        if (isAmtBenchMark) {
            DynamicObject payproperty = BaseDataTestProvider.getPayPropertyByAmtBenchmark();
            billInfo.setPayProperty(payproperty);
        }
        DynamicObject busApBill = BusApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
        busApBill.set("billtype", (Object)688833926805888000L);
        DynamicObject expenseItem = BaseDataTestProvider.getExpenseItem();
        for (DynamicObject entry : busApBill.getDynamicObjectCollection("entry")) {
            entry.set("e_expenseitem", (Object)expenseItem);
            entry.set("e_prepaid", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busApBill});
        return busApBill.getLong("id");
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }
}

