/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.closeaccount;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.junit.Test;

public class AR007_001_CloseAccountUnitTest
extends AbstractJUnitTestPlugIn {
    private DynamicObject initOrg;
    private DynamicObject initOrg2;
    private Long initOrgId;
    private Long initOrg2Id;
    private DynamicObject initData;
    private Date currentDate;
    private static final String orgNameFilter = "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u5173\u8d26\u4e13\u7528";
    private static final BigDecimal BIGDECIMAL_100 = new BigDecimal(100);
    private static final Integer INDEX_ONE = 1;
    private static final Integer INDEX_ZREO = 0;
    private SimulatorTestHelper simulatorTestHelper;
    private boolean isOperationFailByOtherReason = false;

    public void initData() {
        super.initData();
        this.initOrg = BaseDataTestProvider.getDetailInitOrg2();
        this.initOrg2 = BaseDataTestProvider.getPlanInitOrg2();
        this.initOrgId = this.initOrg.getLong("id");
        this.initOrg2Id = this.initOrg2.getLong("id");
        this.simulatorTestHelper = new SimulatorTestHelper(this);
        this.initData = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"id,org,isfinishinit,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.initOrgId)});
        this.currentDate = this.initData.getDate("currentdate");
        this.deleteRelatedBill();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u5173\u8d26")
    @Test
    public void closeAccountTest() {
        if (this.isOperationFailByOtherReason) {
            AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
        } else {
            this.selectTargetDataRows();
            this.checkIsFinishInit();
        }
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5173\u8d262")
    @Test
    public void closeAccountTestTwo() {
        if (this.isOperationFailByOtherReason) {
            AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
        } else {
            this.selectTargetDataRows();
            this.initData.set("isfinishinit", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.initData});
            this.checkCurrentDateValidator();
            this.checkExistUnauditBusBill();
            this.checkExistUnauditInvoice();
            this.checkExistUnauditLiquidation();
            this.checkExistUnsettledFinBill();
            this.selectTargetDataRows();
            this.invokeCloseAccountForUnaudit(false);
            this.checkEntryClear();
            this.checkCurrentDate(this.initOrgId, 21);
            this.antiCloseAccountForDataRecover();
        }
    }

    @TestMethod(value=3)
    @DisplayName(value="\u53cd\u5173\u8d26")
    @Test
    public void antiCloseAccountTest() {
        if (this.isOperationFailByOtherReason) {
            AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
        } else {
            this.checkExistUnsettledFinBill();
            this.antiCloseAccountForDataRecover();
            this.checkCurrentDate(this.initOrg2Id, 0);
            this.checkEntryClear();
        }
    }

    private void deleteRelatedBill() {
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("CloseAccount_ArBusBill_01");
        billNos.add("CloseAccount_ArBusBill_02");
        this.deleteBill("ar_busbill", billNos);
        billNos.clear();
        billNos.add("CloseAccount_ArInvoiceBill_01");
        billNos.add("CloseAccount_ArInvoiceBill_02");
        this.deleteBill("ar_invoice", billNos);
        billNos.clear();
        billNos.add("CloseAccount_ArLiquidBill_01");
        billNos.add("CloseAccount_ArLiquidBill_02");
        this.deleteBill("ar_liquidation", billNos);
        billNos.clear();
        billNos.add("CloseAccount_ArFinBill_01");
        billNos.add("CloseAccount_ArFinBill_02");
        this.deleteBill("ar_finarbill", billNos);
    }

    private void selectTargetDataRows() {
        DynamicObject[] initDatas = this.getInitDatas();
        String initIdForOrg = initDatas[INDEX_ZREO].getString("id");
        String initIdForOrg2 = initDatas[INDEX_ONE].getString("id");
        String orgCommonSerachParam = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"org.name\"],\"Value\":[\"\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u5173\u8d26\u4e13\u7528\"]}],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"entryentity\"],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(orgCommonSerachParam);
        String selectAllParam = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"0\",\"row\":0,\"selRows\":[0,1],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[[\"" + initIdForOrg + "\",\"0\",\"UNITTESTORG-0006\",\"\"],[\"" + initIdForOrg2 + "\",\"0\",\"UNITTESTORG-0007\",\"\"]]}},[]]}]";
        this.simulatorTestHelper.invokeAction(selectAllParam);
    }

    private DynamicObject[] getInitDatas() {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        orgIds.add(this.initOrgId);
        orgIds.add(this.initOrg2Id);
        return BusinessDataServiceHelper.load((String)"ar_init", (String)"id,org,isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)}, (String)"org");
    }

    private void checkIsFinishInit() {
        this.initData.set("isfinishinit", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.initData});
        OperateOption param = OperateOption.create();
        param.setVariableValue("closedate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.getNextDay(this.currentDate, 1)));
        try {
            OperationResult operationResult = this.getView().invokeOperation("closeaccount", param);
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            List allErrorInfo = operationResult.getAllErrorInfo();
            for (OperateErrorInfo info : allErrorInfo) {
                if (!info.getMessage().contains("\u5f02\u5e38")) continue;
                this.isOperationFailByOtherReason = true;
                AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
                return;
            }
            for (OperateErrorInfo info : allErrorOrValidateInfo) {
                if (!info.getMessage().contains("\u5f02\u5e38")) continue;
                this.isOperationFailByOtherReason = true;
                AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
                return;
            }
            for (OperateErrorInfo info : allErrorOrValidateInfo) {
                AR007_001_CloseAccountUnitTest.assertEquals((String)info.getMessage(), (boolean)true, (boolean)info.getMessage().contains("\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u8fdb\u884c\u5173\u8d26\u64cd\u4f5c"));
            }
        }
        catch (Exception e) {
            this.isOperationFailByOtherReason = true;
            AR007_001_CloseAccountUnitTest.assertEquals((int)1, (int)1);
        }
    }

    private void checkCurrentDateValidator() {
        OperateOption param = OperateOption.create();
        param.setVariableValue("closedate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.getLastDay(this.currentDate, 1)));
        OperationResult operationResult = this.getView().invokeOperation("closeaccount", param);
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : allErrorOrValidateInfo) {
            AR007_001_CloseAccountUnitTest.assertEquals((String)info.getMessage(), (boolean)true, (boolean)info.getMessage().contains("\u5173\u8d26\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u7ec4\u7ec7\u5f53\u524d\u65e5\u671f"));
        }
    }

    private void checkExistUnauditBusBill() {
        this.prepareBusBill();
        this.invokeCloseAccountForUnaudit(true);
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("CloseAccount_ArBusBill_01");
        billNos.add("CloseAccount_ArBusBill_02");
        this.deleteBill("ar_busbill", billNos);
        this.antiCloseAccountForDataRecover();
    }

    private void prepareBusBill() {
        DynamicObject materialBusBill = BusArBillTestDataProvider.buildByHeadPriceTaxTotal("CloseAccount_ArBusBill_01", this.initOrg, BIGDECIMAL_100);
        materialBusBill.set("billstatus", (Object)"B");
        Date date = DateUtils.getNextDay(this.currentDate, 10);
        materialBusBill.set("bizdate", (Object)date);
        materialBusBill.set("bookdate", (Object)date);
        DynamicObject planBusBill = BusArBillTestDataProvider.buildByHeadPriceTaxTotal("CloseAccount_ArBusBill_02", this.initOrg2, BIGDECIMAL_100);
        planBusBill.set("bizdate", (Object)date);
        planBusBill.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{materialBusBill, planBusBill});
    }

    private void invokeCloseAccountForUnaudit(boolean validate) {
        OperateOption param = OperateOption.create();
        param.setVariableValue("closedate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.getNextDay(this.currentDate, 20)));
        OperationResult operationResult = this.getView().invokeOperation("closeaccount", param);
        if (validate) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            AR007_001_CloseAccountUnitTest.assertEquals((boolean)operationResult.isSuccess(), (boolean)false);
        }
    }

    private void deleteBill(String entityName, Set<String> billNos) {
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
    }

    private void antiCloseAccountForDataRecover() {
        this.selectTargetDataRows();
        OperateOption param = OperateOption.create();
        param.setVariableValue("anticlosedate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.getLastDay(this.currentDate, 1)));
        this.getView().invokeOperation("anticloseaccount", param);
    }

    private void checkExistUnauditInvoice() {
        this.prepareInvoiceBill();
        this.selectTargetDataRows();
        this.invokeCloseAccountForUnaudit(true);
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("CloseAccount_ArInvoiceBill_01");
        billNos.add("CloseAccount_ArInvoiceBill_02");
        this.deleteBill("ar_invoice", billNos);
        this.antiCloseAccountForDataRecover();
    }

    private void prepareInvoiceBill() {
        Date date = DateUtils.getNextDay(this.currentDate, 10);
        DynamicObject materialInvoiceBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_invoice");
        materialInvoiceBill.set("org", (Object)this.initOrgId);
        materialInvoiceBill.set("billno", (Object)"CloseAccount_ArInvoiceBill_01");
        materialInvoiceBill.set("biztype", (Object)"SAL");
        materialInvoiceBill.set("applydate", (Object)date);
        materialInvoiceBill.set("bizdate", (Object)date);
        materialInvoiceBill.set("invoicetype", (Object)"ELE");
        materialInvoiceBill.set("billstatus", (Object)"B");
        materialInvoiceBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        materialInvoiceBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        materialInvoiceBill.set("exratedate", (Object)date);
        materialInvoiceBill.set("exchangerate", (Object)1);
        materialInvoiceBill.set("quotation", (Object)"0");
        materialInvoiceBill.set("amount", (Object)BIGDECIMAL_100);
        materialInvoiceBill.set("localamt", (Object)BIGDECIMAL_100);
        materialInvoiceBill.set("paymode", (Object)"CASH");
        materialInvoiceBill.set("asstacttype", (Object)"bd_customer");
        materialInvoiceBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        DynamicObject planInvoiceBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_invoice");
        planInvoiceBill.set("org", (Object)this.initOrg2Id);
        planInvoiceBill.set("billno", (Object)"CloseAccount_ArInvoiceBill_02");
        planInvoiceBill.set("biztype", (Object)"SAL");
        planInvoiceBill.set("applydate", (Object)date);
        planInvoiceBill.set("bizdate", (Object)date);
        planInvoiceBill.set("invoicetype", (Object)"ELE");
        planInvoiceBill.set("billstatus", (Object)"C");
        planInvoiceBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        planInvoiceBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        planInvoiceBill.set("exratedate", (Object)date);
        planInvoiceBill.set("exchangerate", (Object)1);
        planInvoiceBill.set("quotation", (Object)"0");
        planInvoiceBill.set("amount", (Object)BIGDECIMAL_100);
        planInvoiceBill.set("localamt", (Object)BIGDECIMAL_100);
        planInvoiceBill.set("paymode", (Object)"CASH");
        planInvoiceBill.set("asstacttype", (Object)"bd_customer");
        planInvoiceBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{materialInvoiceBill, planInvoiceBill});
    }

    private void checkExistUnauditLiquidation() {
        this.prepareLiquidationBill();
        this.selectTargetDataRows();
        this.invokeCloseAccountForUnaudit(true);
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("CloseAccount_ArLiquidBill_01");
        billNos.add("CloseAccount_ArLiquidBill_02");
        this.deleteBill("ar_liquidation", billNos);
        this.antiCloseAccountForDataRecover();
    }

    private void prepareLiquidationBill() {
        Date date = DateUtils.getNextDay(this.currentDate, 10);
        DynamicObject materialLiquidationBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_liquidation");
        materialLiquidationBill.set("org", (Object)this.initOrgId);
        materialLiquidationBill.set("billno", (Object)"CloseAccount_ArLiquidBill_01");
        materialLiquidationBill.set("liquidationdate", (Object)date);
        materialLiquidationBill.set("asstacttype", (Object)"bd_customer");
        materialLiquidationBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        materialLiquidationBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        materialLiquidationBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        materialLiquidationBill.set("exratedate", (Object)date);
        materialLiquidationBill.set("exchangerate", (Object)1);
        materialLiquidationBill.set("quotation", (Object)"0");
        materialLiquidationBill.set("liquidationamt", (Object)BIGDECIMAL_100);
        materialLiquidationBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        materialLiquidationBill.set("billstatus", (Object)"B");
        DynamicObject planLiquidationBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_liquidation");
        planLiquidationBill.set("org", (Object)this.initOrg2Id);
        planLiquidationBill.set("billno", (Object)"CloseAccount_ArLiquidBill_02");
        planLiquidationBill.set("liquidationdate", (Object)date);
        planLiquidationBill.set("asstacttype", (Object)"bd_customer");
        planLiquidationBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        planLiquidationBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        planLiquidationBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        planLiquidationBill.set("exratedate", (Object)date);
        planLiquidationBill.set("exchangerate", (Object)1);
        planLiquidationBill.set("quotation", (Object)"0");
        planLiquidationBill.set("liquidationamt", (Object)BIGDECIMAL_100);
        planLiquidationBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        planLiquidationBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{materialLiquidationBill, planLiquidationBill});
    }

    private void checkExistUnsettledFinBill() {
        this.prepareFinBill();
        this.selectTargetDataRows();
        this.invokeCloseAccountForUnaudit(true);
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("CloseAccount_ArFinBill_01");
        billNos.add("CloseAccount_ArFinBill_02");
        this.deleteBill("ar_finarbill", billNos);
    }

    private void prepareFinBill() {
        Date date = DateUtils.getNextDay(this.currentDate, 10);
        DynamicObject materialFinBill = FinArBillTestDataProvider.buildByHeadPriceTaxTotal("CloseAccount_ArFinBill_01", this.initOrg, BIGDECIMAL_100);
        materialFinBill.set("bizdate", (Object)date);
        materialFinBill.set("bookdate", (Object)date);
        materialFinBill.set("paymode", (Object)"CASH");
        DynamicObject planFinBill = FinArBillTestDataProvider.buildByHeadPriceTaxTotal("CloseAccount_ArFinBill_02", this.initOrg2, BIGDECIMAL_100);
        planFinBill.set("bizdate", (Object)date);
        planFinBill.set("bookdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{materialFinBill, planFinBill});
    }

    private void checkEntryClear() {
        DynamicObject accountData = BusinessDataServiceHelper.loadSingle((String)"ar_closeaccount", (String)"failedmessage", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.initOrgId)});
        AR007_001_CloseAccountUnitTest.assertEquals((boolean)true, (boolean)EmptyUtils.isEmpty(accountData.get("entryentity")));
    }

    private void checkCurrentDate(Long orgId, int day) {
        DynamicObject initData = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateUtils.getNextDay(this.currentDate, day));
        AR007_001_CloseAccountUnitTest.assertEquals((String)initData.getDate("currentdate").toString(), (boolean)true, (boolean)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(initData.getDate("currentdate")).equals(date));
    }
}

