/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.OmInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.OmInBillDataTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP023_013_OmIn2FinApWriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u591a\u5bf9\u591a-\u7b80\u5355\u59d4\u5916\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.purInBillStratProcess("AP023_013_ominbill_1", false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u591a\u5bf9\u591a-\u7b80\u5355\u59d4\u5916\u5165\u5e93\u5355\uff08\u5f02\u5e01\u522b\uff09-\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.purInBillStratProcess("AP023_013_ominbill_2", true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6e05\u9664StdConfig\u59d4\u5916\u6838\u9500\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase3() {
        ConfigCache.clear();
    }

    private void purInBillStratProcess(String billno, boolean isUSD) throws InterruptedException {
        ConfigCache.put("ap_stdconfig", "mdcinbillkey", "im_mdc_ominbill");
        OmInBillDataVO omInBillDataVO = OmInBillDataVO.New().setBillStatus("C").setBillEntity("im_mdc_ominbill").setBillNo(billno);
        if (isUSD) {
            omInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            omInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        }
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        ArrayList<OmInBillDataDetailVO> detailVO1S = new ArrayList<OmInBillDataDetailVO>(2);
        detailVO1S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(10L)).setQuantity(BigDecimal.valueOf(10L)).setSeq(1));
        detailVO1S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(20L)).setQuantity(BigDecimal.valueOf(20L)).setSeq(2));
        DynamicObject omInBill1 = OmInBillDataTestDataProvider.buildByEntryPriceAndQty(omInBillDataVO, detailVO1S);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omInBill1});
        omInBill1 = QueryServiceHelper.queryOne((String)"im_mdc_ominbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)omInBill1.getString("billno"))});
        long omInBill1Id = omInBill1.getLong("id");
        ArrayList<OmInBillDataDetailVO> detailVO2S = new ArrayList<OmInBillDataDetailVO>(2);
        detailVO2S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(30L)).setQuantity(BigDecimal.valueOf(30L)).setSeq(1));
        detailVO2S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.valueOf(40L)).setSeq(2));
        omInBillDataVO.setBillNo(billno.concat("_t"));
        DynamicObject omInBill2 = OmInBillDataTestDataProvider.buildByEntryPriceAndQty(omInBillDataVO, detailVO2S);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omInBill2});
        omInBill2 = QueryServiceHelper.queryOne((String)"im_mdc_ominbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)omInBill2.getString("billno"))});
        long omInBill2Id = omInBill2.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("im_mdc_ominbill", Arrays.asList(omInBill1Id, omInBill2Id), "C", "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        finApBills = FinApBillTestHelper.fullPushFinApBill("im_mdc_ominbill", Arrays.asList(omInBill1Id, omInBill2Id), "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        DynamicObject finApBill2 = finApBills[0];
        Thread.sleep(30000L);
        long finApBill2Id = finApBill2.getLong("id");
        DynamicObject writeOffBill1 = FinApBillTestHelper.executeAndGetWriteOffBill(finApBill1Id);
        Thread.sleep(30000L);
        long writeOffBill1Id = writeOffBill1.getLong("id");
        this.finApBillAuditCheck(finApBill1Id);
        this.writeOffBillCheck(writeOffBill1Id, finApBill1Id);
        this.finApBillAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill1Id, true);
        DynamicObject writeOffBill2 = FinApBillTestHelper.executeAndGetWriteOffBill(finApBill2Id);
        Thread.sleep(30000L);
        long writeOffBill2Id = writeOffBill2.getLong("id");
        this.finApBillAuditCheck(finApBill2Id);
        this.writeOffBillCheck(writeOffBill2Id, finApBill2Id);
        this.finApBillAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill2Id, false);
    }

    public void finApBillAuditCheck(long finApBillId) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(200L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(450L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(800L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    public void writeOffBillCheck(long writeOffBillId, long finApBillId) {
        DynamicObject writeOffBill = BusinessDataServiceHelper.loadSingle((Object)writeOffBillId, (String)"ap_finapbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = writeOffBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(-5L), BigDecimal.ZERO, BigDecimal.valueOf(-50L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(-10L), BigDecimal.ZERO, BigDecimal.valueOf(-200L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(-15L), BigDecimal.ZERO, BigDecimal.valueOf(-450L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(-20L), BigDecimal.ZERO, BigDecimal.valueOf(-800L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(writeOffBill);
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, writeOffBill, false);
    }

    public void finApBillAuditCheckOmInBill(long omInBill1Id, long omInBill2Id, long finApBillId, boolean isFirst) {
        DynamicObject omInBill1 = BusinessDataServiceHelper.loadSingle((Object)omInBill1Id, (String)"im_mdc_ominbill");
        DynamicObject omInBill2 = BusinessDataServiceHelper.loadSingle((Object)omInBill2Id, (String)"im_mdc_ominbill");
        if (isFirst) {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        } else {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
        VerifyRecordTestChecker.redVerifyRecordCheck(omInBill1Id, finApBillId, false);
        VerifyRecordTestChecker.redVerifyRecordCheck(omInBill2Id, finApBillId, false);
    }
}

