/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.payapply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PayApplyBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PayApplyBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.ArApCommonTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import org.junit.Test;

public class AP015_001_PayApply2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355")
    @Test
    public void PayApplyUnitTest_001() {
        DynamicObject applyOne = PayApplyBillTestDataProvider.createPayApplyBill(true, "AP015_payApply_001_1");
        DynamicObject applyTwo = PayApplyBillTestDataProvider.createPayApplyBill(false, "AP015_payApply_001_2");
        Long pkOne = applyOne.getLong("id");
        Long pkTwo = applyTwo.getLong("id");
        List<Long> pks = Arrays.asList(pkOne, pkTwo);
        DynamicObject[] casPayBillArrayFirst = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(70L), "ap_payapply", pks, "C", null, null);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.ZERO);
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(30L));
        ArApCommonTestHelper.executeOperate("pay", "cas_paybill", casPayBillArrayFirst);
        DynamicObject casPayBillOne = BusinessDataServiceHelper.loadSingle((Object)casPayBillArrayFirst[0].getLong("id"), (String)"cas_paybill");
        CasPayBillTestChecker.validateCasPayBillJournalData(casPayBillOne);
        ArApCommonTestHelper.executeOperate("closepay", "ap_payapply", new Object[]{pkOne, pkTwo});
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Inpayment", BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.ZERO);
        AP015_001_PayApply2PayTest.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u5df2\u5173\u95ed", (String)"D", (String)applyOne.getString("billstatus"));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Inpayment", BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        AP015_001_PayApply2PayTest.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u5df2\u5173\u95ed", (String)"D", (String)applyTwo.getString("billstatus"));
        ArApCommonTestHelper.executeOperate("unclosepay", "ap_payapply", new Object[]{pkOne, pkTwo});
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        AP015_001_PayApply2PayTest.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u5ba1\u6838\u6001", (String)"C", (String)applyOne.getString("billstatus"));
        AP015_001_PayApply2PayTest.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u72b6\u6001\u5e94\u4e3a\u5ba1\u6838\u6001", (String)"C", (String)applyTwo.getString("billstatus"));
        DynamicObject[] casPayBillArrayTwice = CasPayBillTestHelper.pushPayBill(null, "ap_payapply", pks, "C", null, null);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Inpayment", BigDecimal.valueOf(15L), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.valueOf(70L));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Inpayment", BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(30L), BigDecimal.valueOf(60L));
        ArApCommonTestHelper.executeOperate("pay", "cas_paybill", casPayBillArrayTwice);
        DynamicObject casPayBillTwo = BusinessDataServiceHelper.loadSingle((Object)casPayBillArrayTwice[0].getLong("id"), (String)"cas_paybill");
        CasPayBillTestChecker.validateCasPayBillJournalData(casPayBillTwo);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Alreadypay", BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Alreadypay", BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        ArApCommonTestHelper.executeOperate("cancelpay", "cas_paybill", casPayBillArrayFirst);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Inpayment", BigDecimal.valueOf(15L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Inpayment", BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(30L), BigDecimal.valueOf(60L));
        ArApCommonTestHelper.executeOperate("unaudit", "cas_paybill", casPayBillArrayFirst);
        ArApCommonTestHelper.executeOperate("cancelpay", "cas_paybill", casPayBillArrayTwice);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.valueOf(70L));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.ZERO, BigDecimal.valueOf(60L));
        ArApCommonTestHelper.executeOperate("unaudit", "cas_paybill", casPayBillArrayTwice);
        ArApCommonTestHelper.executeOperate("delete", "cas_paybill", casPayBillArrayFirst);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(70L));
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(30L));
        ArApCommonTestHelper.executeOperate("delete", "cas_paybill", casPayBillArrayTwice);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

