/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.payapply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PayApplyBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PayApplyBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.PayApplyBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PayApplyBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP015_002_PayApply2ReturnMoneyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("AP015_payBill_002_1", "AP015_payBill_002_2", "AP015_payBill_002_3", "AP015_payBill_002_4", "AP015_payBill_002_5");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> recBillNos = Arrays.asList("AP015_recBill_002_1", "AP015_recBill_002_2", "AP015_recBill_002_5");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", recBillNos)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355->\u9000\u5355")
    @Test
    public void PayApplyUnitTest_002_1() {
        DynamicObject applyOne = PayApplyBillTestDataProvider.createPayApplyBill(true, "AP015_payApply_002_1");
        DynamicObject applyTwo = PayApplyBillTestDataProvider.createPayApplyBill(false, "AP015_payApply_002_2");
        Long pkOne = applyOne.getLong("id");
        Long pkTwo = applyTwo.getLong("id");
        List<Long> pks = Arrays.asList(pkOne, pkTwo);
        DynamicObject[] casPayBillArrayFirst = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(70L), "ap_payapply", pks, "A", "AP015_payBill_002_1", null);
        DynamicObject[] casPayBillArrayTwice = CasPayBillTestHelper.pushPayBill(null, "ap_payapply", pks, "A", "AP015_payBill_002_2", null);
        CasPayBillTestHelper.executeChargeback(casPayBillArrayFirst);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(30L));
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(70L));
        CasPayBillTestHelper.executeChargeback(casPayBillArrayTwice);
        applyOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(applyTwo, "Unpaid", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968")
    @Test
    public void PayApplyUnitTest_002_2() {
        DynamicObject applyOne = PayApplyBillTestDataProvider.createPayApplyBill(true, "AP015_payApply_002_3");
        DynamicObject applyTwo = PayApplyBillTestDataProvider.createPayApplyBill(false, "AP015_payApply_002_4");
        List<Long> pks = Arrays.asList(applyOne.getLong("id"), applyTwo.getLong("id"));
        CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(70L), "ap_payapply", pks, "AP015_payBill_002_3");
        DynamicObject[] casPayBillArrayTwice = CasPayBillTestHelper.fullPushPayBill("ap_payapply", pks, "AP015_payBill_002_4");
        long payBillId = casPayBillArrayTwice[0].getLong("id");
        DynamicObject recBillOne = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("AP015_recBill_002_1", BigDecimal.valueOf(100L), false, false);
        long recBillId = recBillOne.getLong("id");
        CasPayBillTestHelper.executeReturnMoney(this, payBillId, recBillId);
        recBillOne = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill");
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        applyOne = BusinessDataServiceHelper.loadSingle((Object)applyOne.getLong("id"), (String)"ap_payapply");
        applyTwo = BusinessDataServiceHelper.loadSingle((Object)applyTwo.getLong("id"), (String)"ap_payapply");
        BigDecimal eSettledAmt = ((DynamicObject)recBillOne.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        AP015_002_PayApply2ReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e100", recBillOne.getString("billno")), (int)0, (int)BigDecimal.valueOf(100L).compareTo(eSettledAmt));
        AP015_002_PayApply2ReturnMoneyTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{payBillId}, new Long[]{recBillId}, false);
        PayApplyBillTestChecker.validatePayApplyPayStatus(applyOne, "Inpayment");
        PayApplyBillTestChecker.validatePayApplyPayStatus(applyTwo, "Inpayment");
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968\uff08\u6b63\u8d1f\u5206\u5f55\u5f02\u5e01\u522b\u6570\u636e)")
    @Test
    public void PayApplyUnitTest_004() {
        DynamicObject applyOne = this.fillFieldValues(false, "AP015_payApply_002_5");
        List<Long> pks = Collections.singletonList(applyOne.getLong("id"));
        DynamicObject[] casPayBillArray = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(70L), "ap_payapply", pks, "AP015_payBill_002_5", BigDecimal.valueOf(6.045));
        DynamicObject casPayBill = casPayBillArray[0];
        DynamicObject recBillOne = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("AP015_recBill_002_5", BigDecimal.valueOf(10L), false, true);
        CasPayBillTestHelper.executeReturnMoney(this, casPayBill.getLong("id"), recBillOne.getLong("id"));
        recBillOne = BusinessDataServiceHelper.loadSingle((Object)recBillOne.getLong("id"), (String)"cas_recbill");
        casPayBill = BusinessDataServiceHelper.loadSingle((Object)casPayBill.getLong("id"), (String)"cas_paybill");
        applyOne = BusinessDataServiceHelper.loadSingle((Object)applyOne.getLong("id"), (String)"ap_payapply");
        BigDecimal eSettledAmt = ((DynamicObject)recBillOne.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledamt");
        BigDecimal eSettledLocalAmt = ((DynamicObject)recBillOne.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_settledlocalamt");
        AP015_002_PayApply2ReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e10", recBillOne.getString("billno")), (int)0, (int)BigDecimal.valueOf(10L).compareTo(eSettledAmt));
        AP015_002_PayApply2ReturnMoneyTest.assertEquals((String)String.format("\u6536\u6b3e\u5355[%s]\u9000\u6b3e\u5931\u8d25,\u5206\u5f55\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u4e0d\u7b49\u4e8e60.4500", recBillOne.getString("billno")), (int)0, (int)BigDecimal.valueOf(60.45).compareTo(eSettledLocalAmt));
        DynamicObjectCollection payEntry = casPayBill.getDynamicObjectCollection("entry");
        AP015_002_PayApply2ReturnMoneyTest.assertEquals((String)String.format("\u4ed8\u6b3e\u5355[%s]\u72b6\u6001\u4e0e\u671f\u5f85\u503c[\u9000\u6b3e]\u4e0d\u4e00\u81f4", casPayBill.getString("billno")), (String)"I", (String)casPayBill.getString("billstatus"));
        QFilter filter = new QFilter("mainbillentryid", "=", (Object)((DynamicObject)payEntry.get(1)).getLong("id"));
        filter.and(new QFilter("totalsettleamt", "=", (Object)BigDecimal.valueOf(10L)));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new QFilter[]{filter}, false);
        SettleRecordTestChecker.checkSettleAmt(settleRecords);
        PayApplyBillTestChecker.validatorPayApply(applyOne, "Unpaid", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private DynamicObject fillFieldValues(boolean isSameData, String billNo) {
        PayApplyBillDataVO headVO = PayApplyBillDataVO.New();
        headVO.setBillNo(billNo);
        headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        headVO.setExchangerate(BigDecimal.valueOf(6.045));
        headVO.setPricetaxTotal(BigDecimal.valueOf(100L));
        PayApplyBillDataDetailVO newOne = PayApplyBillDataDetailVO.New();
        PayApplyBillDataDetailVO newTwo = PayApplyBillDataDetailVO.New();
        if (isSameData) {
            newOne.setPriceTaxTotal(BigDecimal.valueOf(30L));
            newTwo.setPriceTaxTotal(BigDecimal.valueOf(70L));
        } else {
            newOne.setPriceTaxTotal(BigDecimal.valueOf(40L).negate());
            newTwo.setPriceTaxTotal(BigDecimal.valueOf(60L));
        }
        DynamicObject settlementType = BusinessDataServiceHelper.loadSingleFromCache((Object)900001L, (String)"bd_settlementtype");
        newOne.setSettlementType(settlementType).setSeq(1);
        newTwo.setSettlementType(settlementType).setSeq(2);
        return PayApplyBillTestDataProvider.buildByEntryAmount(headVO, Arrays.asList(newOne, newTwo));
    }
}

