/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_002_PurInBill2BusAp2FinApTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase1() throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill2Id = purInBill2.getLong("id");
        ArrayList<Long> purinBills = new ArrayList<Long>(2);
        purinBills.add(purInBill1.getLong("id"));
        purinBills.add(purInBill2.getLong("id"));
        DynamicObject busApBill = this.pushBusApBill(purinBills);
        DynamicObject[] finApBills = BOTPHelper.push("ap_busbill", "ap_finapbill", "764222085420581888", busApBill);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        DynamicObjectCollection detailEntry = finApBill1.getDynamicObjectCollection("detailentry");
        ArrayList qtyList = new ArrayList(4);
        detailEntry.forEach(row -> qtyList.add(row.getBigDecimal("quantity").divide(BigDecimal.valueOf(2L))));
        FinApBillTestHelper.modifyQty(finApBill1, qtyList.toArray(new BigDecimal[0]));
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill1});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), true, BigDecimal.ONE);
        this.finApBillAuditCheckByFinAp(finApBill1Id, purInBill1Id, purInBill2Id, BigDecimal.ONE);
        finApBills = BOTPHelper.push("ap_busbill", "ap_finapbill", "764222085420581888", busApBill);
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill2});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), false, BigDecimal.ONE);
        this.finApBillAuditCheckByFinAp(finApBill2Id, purInBill1Id, purInBill2Id, BigDecimal.ONE);
        Thread.sleep(60000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, true, BigDecimal.ONE);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, false, BigDecimal.ONE);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u9000\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase2() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setBizTypeNumber("1101");
        purInBillDataVO.setInvSchemeNumber("1101");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(-15L), BigDecimal.valueOf(-30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill2Id = purInBill2.getLong("id");
        ArrayList<Long> purinBills = new ArrayList<Long>(2);
        purinBills.add(purInBill1.getLong("id"));
        purinBills.add(purInBill2.getLong("id"));
        DynamicObject busApBill = this.pushBusApBill(purinBills);
        DynamicObject[] finApBills = BOTPHelper.push("ap_busbill", "ap_finapbill", "764222085420581888", busApBill);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        DynamicObjectCollection detailEntry = finApBill1.getDynamicObjectCollection("detailentry");
        ArrayList qtyList = new ArrayList(4);
        detailEntry.forEach(row -> qtyList.add(row.getBigDecimal("quantity").divide(BigDecimal.valueOf(2L))));
        FinApBillTestHelper.modifyQty(finApBill1, qtyList.toArray(new BigDecimal[0]));
        finApBill1.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        BusBillTestHelper.executeOperation("save", "ap_finapbill", new DynamicObject[]{finApBill1});
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), true, BigDecimal.valueOf(-1L));
        this.finApBillAuditCheckByFinAp(finApBill1Id, purInBill1Id, purInBill2Id, BigDecimal.valueOf(-1L));
        finApBills = BOTPHelper.push("ap_busbill", "ap_finapbill", "764222085420581888", busApBill);
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        finApBill2.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        BusBillTestHelper.executeOperation("save", "ap_finapbill", new DynamicObject[]{finApBill2});
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), false, BigDecimal.valueOf(-1L));
        this.finApBillAuditCheckByFinAp(finApBill2Id, purInBill1Id, purInBill2Id, BigDecimal.valueOf(-1L));
        Thread.sleep(60000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, true, BigDecimal.valueOf(-1L));
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, false, BigDecimal.valueOf(-1L));
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8-\u5f02\u5e01\u522b")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        ArrayList<Long> purinBills = new ArrayList<Long>(1);
        purinBills.add(purInBill.getLong("id"));
        DynamicObject busApBill = this.pushBusApBill(purinBills);
        DynamicObject[] finApBills = BOTPHelper.push("ap_busbill", "ap_finapbill", "764222085420581888", busApBill);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
        Thread.sleep(60000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill.getLong("id")});
    }

    private void finApBillAuditCheckByPur(long purInBill1Id, long purInBillId2, boolean isFirstPush, BigDecimal flag) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        if (isFirstPush) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag), 1);
        }
    }

    private void finApBillAuditCheckByFinAp(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinVerifyRecordData(purInBill1Id, finApBillId);
        FinApBillTestChecker.validateApFinVerifyRecordData(purInBill2Id, finApBillId);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
    }

    private void finApBillUnAuditCheckByPur(long purInBill1Id, long purInBillId2, boolean isFirstUnAudit, BigDecimal flag) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        if (isFirstUnAudit) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
    }

    private DynamicObject pushBusApBill(List<Long> purinBills) {
        List<DynamicObject> busApBills = BOTPHelper.push("im_purinbill", "ap_busbill", "727233134134847488", purinBills);
        DynamicObject busApBill = busApBills.get(0);
        BusBillTestHelper.executeOperation("save", "ap_busbill", new DynamicObject[]{busApBill});
        busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBill.getLong("id"), (String)"ap_busbill");
        busApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{busApBill});
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{busApBill.getLong("id")});
        busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBill.getLong("id"), (String)"ap_busbill");
        return busApBill;
    }
}

