/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.ApInvoiceBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u6536\u7968\u5355-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.purInBillStratProcess(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u9000\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u6536\u7968\u5355-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.purInBillStratProcess(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u6536\u7968\u5355-\u8d22\u52a1\u5e94\u4ed8-\u5f02\u5e01\u522b-\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        long purInBillId = purInBill.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Collections.singletonList(purInBillId), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        ApInvoiceBillTestHelper.setAP001(busApBill.getLong("org.id"), false);
        DynamicObject invoiceBill = ApInvoiceBillTestHelper.pushInvoice("ap_busbill", Collections.singletonList(busApBillId));
        long invoiceBillId = invoiceBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_invoice", Collections.singletonList(invoiceBillId), "AP-" + DBServiceHelper.genGlobalLongId(), BigDecimal.valueOf(6.5));
        Thread.sleep(30000L);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finApBillId);
        long writeOffBillId = writeOffBill.getLong("id");
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill.getLong("id"), finApBillId, false);
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)writeOffBillId, (String)"ap_finapbill");
        DynamicObjectCollection writeEntry = finApBillWrite.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)writeEntry.get(0), BigDecimal.valueOf(-10L), BigDecimal.ZERO, BigDecimal.valueOf(-100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private void purInBillStratProcess(boolean isReturn) throws InterruptedException {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        if (isReturn) {
            purInBillDataVO.setBizTypeNumber("1101");
            purInBillDataVO.setInvSchemeNumber("1101");
        }
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill2Id = purInBill2.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        ApInvoiceBillTestHelper.setAP001(busApBill.getLong("org.id"), false);
        DynamicObject invoiceBill = ApInvoiceBillTestHelper.pushInvoice("ap_busbill", Collections.singletonList(busApBillId));
        long invoiceBillId = invoiceBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_invoice", Collections.singletonList(invoiceBillId), "AP-" + DBServiceHelper.genGlobalLongId());
        Thread.sleep(30000L);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finApBillId);
        long writeOffBillId = writeOffBill.getLong("id");
        Thread.sleep(30000L);
        this.finApBillWriteCheckByPur(purInBill1Id, purInBill2Id);
        this.finApBillWriteCheck(writeOffBillId, finApBillId, isReturn ? BigDecimal.ONE : BigDecimal.valueOf(-1L));
        this.finApBillCheck(finApBillId, purInBill1Id, purInBill2Id, flag);
    }

    private void finApBillWriteCheckByPur(long purInBill1Id, long purInBillId2) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }

    private void finApBillWriteCheck(long finApBillWriteId, long finApBillId, BigDecimal flag) {
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)finApBillWriteId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBillWrite.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(20L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(30L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBillWrite.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        FinApBillTestChecker.validateApFinJournalData(finApBillWrite);
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private void finApBillCheck(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(100L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(20L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(400L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(225L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(30L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(900L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.valueOf(1625L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP020_008_PurInBill2BusAp2Invoice2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill1Id, finApBillId, false);
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill2Id, finApBillId, false);
    }
}

