/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_012_PurInBill2FinApBillTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase1() throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill2Id = purInBill2.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "C", "AP-" + DBServiceHelper.genGlobalLongId(), BigDecimal.ONE);
        Thread.sleep(30000L);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), true, BigDecimal.ONE);
        this.finApBillAuditCheckByFinAp(finApBill1Id, purInBill1Id, purInBill2Id, BigDecimal.ONE);
        finApBills = FinApBillTestHelper.fullPushFinApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "AP-" + DBServiceHelper.genGlobalLongId());
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        Thread.sleep(60000L);
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), false, BigDecimal.ONE);
        this.finApBillAuditCheckByFinAp(finApBill2Id, purInBill1Id, purInBill2Id, BigDecimal.ONE);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, true, BigDecimal.ONE);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, false, BigDecimal.ONE);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u9000\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase2() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setBizTypeNumber("1101");
        purInBillDataVO.setInvSchemeNumber("1101");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(-15L), BigDecimal.valueOf(-30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill2Id = purInBill2.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "C", "AP-" + DBServiceHelper.genGlobalLongId(), BigDecimal.ONE);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), true, BigDecimal.valueOf(-1L));
        this.finApBillAuditCheckByFinAp(finApBill1Id, purInBill1Id, purInBill2Id, BigDecimal.valueOf(-1L));
        finApBills = FinApBillTestHelper.fullPushFinApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "AP-" + DBServiceHelper.genGlobalLongId());
        Thread.sleep(30000L);
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        this.finApBillAuditCheckByPur(purInBill1.getLong("id"), purInBill2.getLong("id"), false, BigDecimal.valueOf(-1L));
        this.finApBillAuditCheckByFinAp(finApBill2Id, purInBill1Id, purInBill2Id, BigDecimal.valueOf(-1L));
        Thread.sleep(60000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, true, BigDecimal.valueOf(-1L));
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheckByPur(purInBill1Id, purInBill2Id, false, BigDecimal.valueOf(-1L));
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8-\u5f02\u5e01\u522b")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        DynamicObject[] finApBills = BOTPHelper.push("im_purinbill", "ap_finapbill", "562850542418677760", purInBill);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
        Thread.sleep(60000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill.getLong("id")});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u5f80\u6765\u6237\u4e0d\u540c\u6838\u9500\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
    }

    private void finApBillAuditCheckByPur(long purInBill1Id, long purInBillId2, boolean isFirstPush, BigDecimal flag) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        if (isFirstPush) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag), 1);
        }
    }

    private void finApBillAuditCheckByFinAp(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinVerifyRecordData(purInBill1Id, finApBillId);
        FinApBillTestChecker.validateApFinVerifyRecordData(purInBill2Id, finApBillId);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
    }

    private void finApBillUnAuditCheckByPur(long purInBill1Id, long purInBillId2, boolean isFirstUnAudit, BigDecimal flag) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        if (isFirstUnAudit) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
    }

    private void asstactDifferentVerify(long finApBillId1, long finApBillId2, long purInBill1Id, long purInBill2Id, BigDecimal flag) throws InterruptedException {
        ConfigCache.put("ap_stdconfig", "verify.isAsstActMatch", "true");
        DynamicObject finApBill1 = BusinessDataServiceHelper.loadSingle((Object)finApBillId1, (String)"ap_finapbill");
        DynamicObject finApBill2 = BusinessDataServiceHelper.loadSingle((Object)finApBillId2, (String)"ap_finapbill");
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)0L), new QFilter("id", "!=", (Object)finApBill1.getLong("asstact.id"))});
        finApBill1.set("asstact", (Object)supplier.getLong("id"));
        finApBill2.set("asstact", (Object)supplier.getLong("id"));
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill1, finApBill2});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId1, finApBillId2});
        Thread.sleep(20000L);
        this.unVerifyCheck(finApBillId1, purInBill1Id, purInBill2Id, flag);
        this.unVerifyCheck(finApBillId2, purInBill1Id, purInBill2Id, flag);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId1, finApBillId2});
        ConfigCache.put("ap_stdconfig", "verify.isAsstActMatch", "false");
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId1});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId1});
        this.finApBillAuditCheckByPur(purInBill1Id, purInBill2Id, true, flag);
        this.finApBillAuditCheckByFinAp(finApBillId1, purInBill1Id, purInBill2Id, flag);
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId2});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId2});
        this.finApBillAuditCheckByPur(purInBill1Id, purInBill2Id, false, flag);
        this.finApBillAuditCheckByFinAp(finApBillId2, purInBill1Id, purInBill2Id, flag);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId1, finApBillId2});
    }

    private void unVerifyCheck(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBill2Id, (String)"im_purinbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBill1Id, finApBillId, false, false);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBill2Id, finApBillId, false, false);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.valueOf(10L).multiply(flag), 0);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.valueOf(20L).multiply(flag), 1);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.valueOf(15L).multiply(flag), 0);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.valueOf(30L).multiply(flag), 1);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.ZERO, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.ZERO, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.ZERO, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.ZERO, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag));
        FinApBillTestChecker.validateApFinHead(finApBill);
    }
}

