/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_013_PurInBill2FinApBill2WriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        DynamicObject finApBill1 = this.pushFinApBill(purInBill1.getLong("id"), purInBill2.getLong("id"), true, false);
        DynamicObject finApBill2 = this.pushFinApBill(purInBill1.getLong("id"), purInBill2.getLong("id"), false, false);
        Thread.sleep(30000L);
        this.pushWriteOffBill(finApBill1, purInBill1.getLong("id"), purInBill2.getLong("id"), false, true);
        this.pushWriteOffBill(finApBill2, purInBill1.getLong("id"), purInBill2.getLong("id"), false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u9000\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setBizTypeNumber("1101");
        purInBillDataVO.setInvSchemeNumber("1101");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        qtys = new BigDecimal[]{BigDecimal.valueOf(-15L), BigDecimal.valueOf(-30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        DynamicObject finApBill1 = this.pushFinApBill(purInBill1.getLong("id"), purInBill2.getLong("id"), true, true);
        DynamicObject finApBill2 = this.pushFinApBill(purInBill1.getLong("id"), purInBill2.getLong("id"), false, true);
        Thread.sleep(30000L);
        this.pushWriteOffBill(finApBill1, purInBill1.getLong("id"), purInBill2.getLong("id"), true, true);
        this.pushWriteOffBill(finApBill2, purInBill1.getLong("id"), purInBill2.getLong("id"), true, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8-\u5f02\u5e01\u522b-\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        DynamicObject[] finApBills = BOTPHelper.push("im_purinbill", "ap_finapbill", "562850542418677760", purInBill);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        BusBillTestHelper.executeOperation("save", "ap_finapbill", new DynamicObject[]{finApBill});
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObject[] writeFinAPs = BOTPHelper.push("ap_finapbill", "ap_finapbill", "520819751337865216", finApBill);
        Thread.sleep(30000L);
        BusBillTestHelper.executeOperation("save", "ap_finapbill", writeFinAPs);
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBill.getLong("id"), (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill.getLong("id"), finApBillId, false);
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)writeFinAPs[0].getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        FinApBillTestChecker.validateApFinJournalData(finApBillWrite);
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private DynamicObject pushFinApBill(long purInBill1Id, long purInBill2Id, boolean isModifyQty, boolean isReturnBill) {
        ArrayList<Long> purinBills = new ArrayList<Long>(2);
        purinBills.add(purInBill1Id);
        purinBills.add(purInBill2Id);
        List<DynamicObject> finApBills = BOTPHelper.push("im_purinbill", "ap_finapbill", "562850542418677760", purinBills);
        DynamicObject finApBill = finApBills.get(0);
        long finApBillId = finApBill.getLong("id");
        if (isModifyQty) {
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
            ArrayList qtyList = new ArrayList(4);
            detailEntry.forEach(row -> qtyList.add(row.getBigDecimal("quantity").divide(BigDecimal.valueOf(2L))));
            FinApBillTestHelper.modifyQty(finApBill, qtyList.toArray(new BigDecimal[0]));
        }
        if (isReturnBill) {
            finApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
            BusBillTestHelper.executeOperation("save", "ap_finapbill", new DynamicObject[]{finApBill});
            BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId});
        } else {
            BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill});
        }
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        return finApBill;
    }

    private void pushWriteOffBill(DynamicObject finApBill, long purInBill1Id, long purInBill2Id, boolean isReturnBill, boolean isFirst) throws InterruptedException {
        DynamicObject[] writeFinAPs = BOTPHelper.push("ap_finapbill", "ap_finapbill", "520819751337865216", finApBill);
        BusBillTestHelper.executeOperation("save", "ap_finapbill", writeFinAPs);
        Thread.sleep(30000L);
        this.finApBillWriteCheckByPur(purInBill1Id, purInBill2Id, isReturnBill ? BigDecimal.valueOf(-1L) : BigDecimal.ONE, isFirst);
        this.finApBillWriteCheck(writeFinAPs[0].getLong("id"), finApBill.getLong("id"), isReturnBill ? BigDecimal.ONE : BigDecimal.valueOf(-1L));
        this.finApBillCheck(finApBill.getLong("id"), purInBill1Id, purInBill2Id, isReturnBill ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
    }

    private void finApBillWriteCheckByPur(long purInBill1Id, long purInBillId2, BigDecimal flag, boolean isFirst) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purinbill");
        if (isFirst) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
    }

    private void finApBillWriteCheck(long finApBillWriteId, long finApBillId, BigDecimal flag) {
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)finApBillWriteId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBillWrite.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBillWrite.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        FinApBillTestChecker.validateApFinJournalData(finApBillWrite);
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private void finApBillCheck(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP020_013_PurInBill2FinApBill2WriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill1Id, finApBillId, false);
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill2Id, finApBillId, false);
    }
}

