/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.junit.Test;

public class AP020_017_PurInBill2HomogenyWoff
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8,\u91c7\u8d2d\u5165\u5e93-\u8d22\u52a1\u5e94\u4ed8-\u540c\u6e90\u51b2\u56de")
    @Test
    public void testCase1() throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill2Id = purInBill2.getLong("id");
        ArrayList<Long> purinBills = new ArrayList<Long>(2);
        purinBills.add(purInBill1.getLong("id"));
        purinBills.add(purInBill2.getLong("id"));
        DynamicObject busApBill = PurInBillTestHelper.purInBillPushBusApBill(purinBills);
        long billApBillId = busApBill.getLong("id");
        DynamicObject finApBill1 = PurInBillTestHelper.purInBillPushFinApBill(purinBills, true, false);
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, false, true);
        this.busApBillCheck(billApBillId, false, true);
        this.busApWoffBillCheck(busApBill, finApBill1, false, false);
        DynamicObject finApBill2 = PurInBillTestHelper.purInBillPushFinApBill(purinBills, false, false);
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, false, false);
        this.busApBillCheck(billApBillId, false, false);
        this.busApWoffBillCheck(busApBill, finApBill2, false, false);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2.getLong("id")});
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, false, true);
        this.busApBillCheck(billApBillId, false, true);
        this.busApWoffBillCheck(busApBill, finApBill2, false, true);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1.getLong("id")});
        Thread.sleep(30000L);
        this.firstHandCheck(billApBillId, purInBill1Id, purInBill2Id, false);
        this.busApWoffBillCheck(busApBill, finApBill2, false, true);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u591a\u5bf9\u591a-\u91c7\u8d2d\u9000\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\uff0c\u91c7\u8d2d\u5165\u5e93-\u8d22\u52a1\u5e94\u4ed8-\u540c\u6e90\u51b2\u56de")
    @Test
    public void testCase2() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setBizTypeNumber("1101");
        purInBillDataVO.setInvSchemeNumber("1101");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(-15L), BigDecimal.valueOf(-30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill2Id = purInBill2.getLong("id");
        ArrayList<Long> purinBills = new ArrayList<Long>(2);
        purinBills.add(purInBill1Id);
        purinBills.add(purInBill2.getLong("id"));
        DynamicObject busApBill = PurInBillTestHelper.purInBillPushBusApBill(purinBills);
        long billApBillId = busApBill.getLong("id");
        DynamicObject finApBill1 = PurInBillTestHelper.purInBillPushFinApBill(purinBills, true, true);
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, true, true);
        this.busApBillCheck(billApBillId, true, true);
        this.busApWoffBillCheck(busApBill, finApBill1, true, false);
        DynamicObject finApBill2 = PurInBillTestHelper.purInBillPushFinApBill(purinBills, false, true);
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, true, false);
        this.busApBillCheck(billApBillId, true, false);
        this.busApWoffBillCheck(busApBill, finApBill2, true, false);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2.getLong("id")});
        Thread.sleep(30000L);
        this.purInBillCheck(purInBill1Id, purInBill2Id, true, true);
        this.busApBillCheck(billApBillId, true, true);
        this.busApWoffBillCheck(busApBill, finApBill2, true, true);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1.getLong("id")});
        Thread.sleep(30000L);
        this.firstHandCheck(billApBillId, purInBill1Id, purInBill2Id, true);
        this.busApWoffBillCheck(busApBill, finApBill2, true, true);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1.getLong("id")});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBill2Id});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8-\u6682\u4f30\u5e94\u4ed8\uff0c\u91c7\u8d2d\u5165\u5e93-\u8d22\u52a1\u5e94\u4ed8-\u5f02\u5e01\u522b-\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        long purInBillId = purInBill.getLong("id");
        ArrayList<Long> purinBills = new ArrayList<Long>(1);
        purinBills.add(purInBillId);
        DynamicObject busApBill = PurInBillTestHelper.purInBillPushBusApBill(purinBills);
        long billApBillId = busApBill.getLong("id");
        DynamicObject finApBill = PurInBillTestHelper.purInBillPushFinApBill(purinBills, false, false);
        long finApBillId = finApBill.getLong("id");
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{billApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBillId});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBillId});
    }

    private void purInBillCheck(long purInBill1Id, long purInBill2Id, boolean isReturn, boolean isFirstPushFinAp) {
        BigDecimal flag;
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBill2Id, (String)"im_purinbill");
        BigDecimal bigDecimal = flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        if (isFirstPushFinAp) {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag), 1);
        }
    }

    private void busApBillCheck(long busBillId, boolean isReturn, boolean isFirstPushFinAp) {
        BigDecimal flag;
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ap_busbill");
        BigDecimal bigDecimal = flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        if (isFirstPushFinAp) {
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), 1);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), 2);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), 3);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), 0);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), 1);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), 2);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), 3);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 3);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
            BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 3);
        }
        BusBillTestChecker.headCheck(busApBill);
    }

    private void busApWoffBillCheck(DynamicObject busBill, DynamicObject finApBill, boolean isReturn, boolean isReverse) {
        DynamicObject woffBill = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)String.valueOf(busBill.getLong("id"))), new QFilter("srcfinbillid", "=", (Object)finApBill.getLong("id"))});
        if (isReverse) {
            AP020_017_PurInBill2HomogenyWoff.assertEquals((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u53cd\u5ba1\u6838\u672a\u81ea\u52a8\u5220\u9664\u6682\u4f30\u51b2\u56de\u5355", (boolean)true, (woffBill == null ? 1 : 0) != 0);
        } else {
            AP020_017_PurInBill2HomogenyWoff.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u5ba1\u6838\u672a\u751f\u6210\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u540c\u6e90\u51b2\u56de\u5355"), (boolean)true, (!ObjectUtils.isEmpty((Object)woffBill) ? 1 : 0) != 0);
            BigDecimal flag = isReturn ? BigDecimal.ONE : BigDecimal.valueOf(-1L);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), 1);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), 2);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), 3);
            BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), 1);
            BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), 2);
            BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), 3);
            BusBillTestChecker.headCheck(woffBill);
            AP020_017_PurInBill2HomogenyWoff.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + woffBill.getString("billno") + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
        }
    }

    private void firstHandCheck(long busApBillId, long purInBill1Id, long purInBill2Id, boolean isReturn) {
        DynamicObject busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBill2Id, (String)"im_purinbill");
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), 0);
        BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), 1);
        BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), 2);
        BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), 3);
        BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), BigDecimal.valueOf(100L).multiply(flag), 0);
        BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), BigDecimal.valueOf(400L).multiply(flag), 1);
        BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), BigDecimal.valueOf(225L).multiply(flag), 2);
        BusBillTestChecker.entryCheckByInvoice(busApBill, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), BigDecimal.valueOf(900L).multiply(flag), 3);
        BusBillTestChecker.headCheck(busApBill);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }
}

