/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurInBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_018_PurIn2Red2FinTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteBusAps = Collections.singletonList("AP020_018_busApBill_1");
        DeleteServiceHelper.delete((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteBusAps)});
        List<String> deleteFinAps = Collections.singletonList("AP020_018_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        DeleteServiceHelper.delete((String)"ap_verifyrecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", Arrays.asList("AP020_018_purInBill_1", "AP020_018_purInBill_2"))});
    }

    @TestMethod(value=1)
    @DisplayName(value="\uff08\u7ea2\u84dd\u6838\u9500=\u662f\uff09\u5f53\u6708\u5230\u8d27\u3001\u6b21\u6708\u9000\u8d27\u3001\u6700\u540e\u5f00\u7968")
    @Test
    public void PruIn2Red2FinTest_1() throws InterruptedException {
        DynamicObject purInBillOne = PurInBillDataTestProvider.createPurInBill(true, false, "AP020_018_purInBill_1");
        DynamicObject purInBillTwo = PurInBillDataTestProvider.createPurInBill(false, false, "AP020_018_purInBill_2");
        long purInBillOneId = purInBillOne.getLong("id");
        long purInBillTwoId = purInBillTwo.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Arrays.asList(purInBillOneId, purInBillTwoId), "AP020_018_busApBill_1");
        Thread.sleep(30000L);
        purInBillOne = BusinessDataServiceHelper.loadSingle((Object)purInBillOneId, (String)"im_purinbill");
        purInBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInBillTwoId, (String)"im_purinbill");
        AP020_018_PurIn2Red2FinTest.assertEquals((String)"\u91c7\u8d2d\u5165\u5e93\u5355\u8868\u5934\u672a\u751f\u6210\u6682\u4f30\u5e94\u4ed8\u5355\u5b57\u6bb5", (Object)Boolean.TRUE, (Object)purInBillOne.get("hasapbusbill"));
        AP020_018_PurIn2Red2FinTest.assertEquals((String)"\u91c7\u8d2d\u5165\u5e93\u5355\u8868\u5934\u672a\u751f\u6210\u6682\u4f30\u5e94\u4ed8\u5355\u5b57\u6bb5", (Object)Boolean.TRUE, (Object)purInBillTwo.get("hasapbusbill"));
        DynamicObject[] redPurInBills = PurInBillTestHelper.pushPruInBill("im_purinbill", Arrays.asList(purInBillOneId, purInBillTwoId), "AP020_018_purInBill_3", Boolean.TRUE, "A");
        Thread.sleep(30000L);
        long purInRedBillOneId = QueryServiceHelper.queryOne((String)"im_purinbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.srcbillid", "=", (Object)purInBillOneId)}).getLong("id");
        long purInRedBillTwoId = QueryServiceHelper.queryOne((String)"im_purinbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.srcbillid", "=", (Object)purInBillTwoId)}).getLong("id");
        DynamicObject purInRedBillOne = BusinessDataServiceHelper.loadSingle((Object)purInRedBillOneId, (String)"im_purinbill");
        DynamicObject purInRedBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInRedBillTwoId, (String)"im_purinbill");
        purInBillOne = BusinessDataServiceHelper.loadSingle((Object)purInBillOneId, (String)"im_purinbill");
        purInBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInBillTwoId, (String)"im_purinbill");
        DynamicObjectCollection entrys = purInBillOne.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = purInBillTwo.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = purInRedBillOne.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        entrys = purInRedBillTwo.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        PurInBillTestChecker.validateReturnqtyAndReturnbaseqty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        Arrays.stream(redPurInBills).forEach(purBill -> purBill.set("billstatus", (Object)"B"));
        SaveServiceHelper.save((DynamicObject[])redPurInBills);
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"im_purinbill", (DynamicObject[])redPurInBills, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(audit);
        Thread.sleep(30000L);
        purInBillOne = BusinessDataServiceHelper.loadSingle((Object)purInBillOneId, (String)"im_purinbill");
        purInBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInBillTwoId, (String)"im_purinbill");
        entrys = purInBillOne.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(0), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5));
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(1), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5));
        entrys = purInBillTwo.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(0), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5));
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(1), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5));
        purInRedBillOne = BusinessDataServiceHelper.loadSingle((Object)purInRedBillOneId, (String)"im_purinbill");
        purInRedBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInRedBillTwoId, (String)"im_purinbill");
        entrys = purInRedBillOne.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-0.5), BigDecimal.valueOf(-0.5));
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-0.5), BigDecimal.valueOf(-0.5));
        entrys = purInRedBillTwo.getDynamicObjectCollection("billentry");
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-0.5), BigDecimal.valueOf(-0.5));
        PurInBillTestChecker.validateRetrunreQty((DynamicObject)entrys.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-0.5), BigDecimal.valueOf(-0.5));
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBillOneId, (Long)purInRedBillOne.getPkValue(), false, true);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBillTwoId, (Long)purInRedBillTwo.getPkValue(), false, true);
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill(BigDecimal.valueOf(999999L), "ap_busbill", Collections.singletonList(busApBills[0].getLong("id")), "AP020_018_finApBill_1");
        Thread.sleep(30000L);
        long finApBillId = finApBills[0].getLong("id");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        purInBillOne = BusinessDataServiceHelper.loadSingle((Object)purInBillOneId, (String)"im_purinbill");
        purInBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInBillTwoId, (String)"im_purinbill");
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillOne, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), 0);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillOne, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), 1);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillTwo, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), 0);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillTwo, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), 1);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBillOneId, finApBillId, false, true);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBillTwoId, finApBillId, false, true);
        FinApBillTestChecker.validateFinishApFin(finApBill, false, true);
        Thread.sleep(30000L);
        OperationResult unaudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Object[]{finApBillId}, (OperateOption)OperateOption.create());
        AP020_018_PurIn2Red2FinTest.assertInvokeOperation((OperationResult)unaudit);
        Thread.sleep(30000L);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinHeadVerifyData(finApBill, "10", BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinHeadSettleStatus(finApBill, "unsettle");
        purInBillOne = BusinessDataServiceHelper.loadSingle((Object)purInBillOneId, (String)"im_purinbill");
        purInBillTwo = BusinessDataServiceHelper.loadSingle((Object)purInBillTwoId, (String)"im_purinbill");
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillOne, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillOne, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO, 1);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillTwo, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.validateVerifyQtyAndJoinPriceQty(purInBillTwo, BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }
}

