/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import org.junit.Test;

public class AP025_002_PurOrder2Apply2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Collections.singletonList("AP025_002_payapply_1");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355(\u8ba1\u5212\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_002_purOrder_1", true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject[] payApplys = PayApplyBillTestHelper.pushPayApplyBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_002_payapply_1");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(999999L), "ap_payapply", Collections.singletonList(payApplys[0].getLong("id")), "AP025_002_payBill_1");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(5L), BigDecimal.valueOf(2.5), BigDecimal.valueOf(15L), BigDecimal.valueOf(7.5));
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L));
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)OperateOption.create());
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestHelper.casPayBillToDelete(payBills, false);
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO);
    }
}

