/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.junit.Test;

public class AP025_003_PurOrder2BusApTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteBusAps = Collections.singletonList("AP025_003_busApBill_2");
        DeleteServiceHelper.delete((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteBusAps)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u6682\u4f30\u5e94\u4ed8(\u7269\u6599\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_003_purOrder_1", false, true, false);
        DynamicObject purOrderBillTwo = PurOrderBillTestDataProvider.createPurOrderBill("AP025_003_purOrder_2", false, false, false);
        long orderOneId = purOrderBillOne.getLong("id");
        long orderTwoId = purOrderBillTwo.getLong("id");
        DynamicObject[] busApBillOne = BusBillTestHelper.pushBusApBill(BigDecimal.valueOf(70L), "pm_purorderbill", Arrays.asList(orderOneId, orderTwoId), "AP025_003_busApBill_1");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        DynamicObjectCollection billEntry = purOrderBillOne.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
        purOrderBillTwo = BusinessDataServiceHelper.loadSingle((Object)orderTwoId, (String)"pm_purorderbill");
        billEntry = purOrderBillTwo.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
        BusBillTestHelper.pushBusApBill(null, "pm_purorderbill", Arrays.asList(orderOneId, orderTwoId), "A", "AP025_003_busApBill_2");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        billEntry = purOrderBillOne.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        purOrderBillTwo = BusinessDataServiceHelper.loadSingle((Object)orderTwoId, (String)"pm_purorderbill");
        billEntry = purOrderBillTwo.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        Object[] busBillIds = new Long[]{busApBillOne[0].getLong("id")};
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_busbill", (Object[])busBillIds, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_busbill", (Object[])busBillIds, (OperateOption)OperateOption.create());
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        billEntry = purOrderBillOne.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
        purOrderBillTwo = BusinessDataServiceHelper.loadSingle((Object)orderTwoId, (String)"pm_purorderbill");
        billEntry = purOrderBillTwo.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(0), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)billEntry.get(1), BigDecimal.valueOf(0.5), BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

