/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurOrderBillTestHelper;
import org.junit.Test;

public class AP025_020_PurOrder2PurIn2BusAp2FinApTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355-\u91c7\u8d2d\u5165\u5e93-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase1() throws InterruptedException {
        this.purOrderStratProcessTest(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355(\u5f02\u5e01\u522b)-\u91c7\u8d2d\u5165\u5e93-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase2() throws InterruptedException {
        this.purOrderStratProcessTest(true);
    }

    private void purOrderStratProcessTest(boolean isUSD) throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purOrderBill = PurOrderBillTestHelper.getAuditStatusPurOrderBill(qtys, prices, isUSD, true);
        long purOrderBillId = purOrderBill.getLong("id");
        DynamicObject[] purInBills = PurInBillTestHelper.fullPushPruInBill("pm_purorderbill", Collections.singletonList(purOrderBillId), "CGRK-" + DBServiceHelper.genGlobalLongId());
        DynamicObject purInBill = purInBills[0];
        long purInBillId = purInBill.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Collections.singletonList(purInBillId), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "AP-" + DBServiceHelper.genGlobalLongId());
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        this.purOrderBillCheck(purOrderBillId);
        this.finApBillCheck(purInBillId, finApBillId, isUSD);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        PurOrderBillTestChecker.validatePurOrderApDataByZero(purOrderBillId);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBillId});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBillId});
        BusBillTestHelper.executeOperation("unaudit", "pm_purorderbill", new Object[]{purOrderBillId});
        BusBillTestHelper.executeOperation("delete", "pm_purorderbill", new Object[]{purOrderBillId});
    }

    private void purOrderBillCheck(long purOrderBillId) {
        DynamicObject purOrderBill = BusinessDataServiceHelper.loadSingle((Object)purOrderBillId, (String)"pm_purorderbill");
        DynamicObjectCollection entry = purOrderBill.getDynamicObjectCollection("billentry");
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)entry.get(0), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        PurOrderBillTestChecker.validatePurOrderApData((DynamicObject)entry.get(1), BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L));
    }

    private void finApBillCheck(long purInBillId, long finApBillId, boolean isUSD) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(400L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        DynamicObject purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        VerifyRecordTestChecker.verifyRecordCheck(purInBill, finApBill, false);
    }
}

