/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PayApplyBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import org.junit.Test;

public class AP025_080_PurOrder2Apply2ReturnMoneyAnd2FinTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Arrays.asList("AP025_080_finApBill_1", "AP025_080_finApBill_2");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deleteApplys = Arrays.asList("AP025_080_payapply_1", "AP025_080_payapply_2");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Arrays.asList("AP025_080_payBill_1", "AP025_080_payBill_2");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecBills = Arrays.asList("AP025_080_recBill_1", "AP025_080_recBill_2");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecBills)});
        List<String> deleteRecords = Arrays.asList("AP025_080_finApBill_1", "AP025_080_finApBill_2", "AP025_080_payBill_1", "AP025_080_payBill_2");
        DeleteServiceHelper.delete((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecords)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7\u5355->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8(\u7269\u6599\u884c)\uff08\u5148\u9000\u6b3e\u540e\u5e94\u4ed8\u5ba1\u6838\uff09")
    @Test
    public void purOrderUnitTest_001() {
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7\u5355->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8(\u7269\u6599\u884c)\uff08\u5148\u5e94\u4ed8\u5ba1\u6838\u540e\u9000\u6b3e\uff09")
    @Test
    public void purOrderUnitTest_002() {
        AP025_080_PurOrder2Apply2ReturnMoneyAnd2FinTest.assertEquals((int)1, (int)1);
    }

    private void validateData(long orderOneId, long finBillId, long payApplyId, long payBillId, long recBillId) {
        DynamicObject purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(20L));
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderOneId);
        AP025_080_PurOrder2Apply2ReturnMoneyAnd2FinTest.assertEquals((String)"\u91c7\u8d2d\u8ba2\u5355\u5e94\u4e3a\u5173\u95ed\u6001", (boolean)true, (boolean)"B".equals(purOrderBillOne.getString("closestatus")));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        AP025_080_PurOrder2Apply2ReturnMoneyAnd2FinTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u8868\u5934\u72b6\u6001\u5e94\u4e3a\u9000\u6b3e\u72b6\u6001", (boolean)true, (boolean)"I".equals(casPayBill.getString("billstatus")));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        CasPayBillTestChecker.validateCasPayBillRefundAndLockAndSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.ZERO, BigDecimal.ZERO);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{payBillId}, new Long[]{recBillId}, false);
        DynamicObject payApply = BusinessDataServiceHelper.loadSingle((Object)payApplyId, (String)"ap_payapply");
        PayApplyBillTestChecker.validatorPayApply(payApply, "Inpayment", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void validateFinApBill(long finBillId, long payBillId) {
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finBillId, (String)"ap_finapbill");
        AP025_080_PurOrder2Apply2ReturnMoneyAnd2FinTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            BigDecimal ePayableAmt = detail.getBigDecimal("e_payableamt");
            BigDecimal ePayableLocAmt = detail.getBigDecimal("e_payablelocamt");
            CasPayBillTestChecker.validateCasPayDetailLockAmt(detail, ePayableAmt, BigDecimal.ZERO);
            CasPayBillTestChecker.validateCasPayDetailSettleAmt(detail, ePayableAmt, ePayableLocAmt, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBillId}, new Long[]{payBillId}, false);
    }
}

