/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP025_081_PurOrder2PayAnd2Fin2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Collections.singletonList("AP025_081_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deletePayBills = Arrays.asList("AP025_081_payBill_1", "AP025_081_payBill_2");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u5355 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355(\u8ba1\u5212\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_081_purOrder_1", true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        CasPayBillTestHelper.fullPushPayBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_081_payBill_1");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_081_finApBill_1");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finApBills[0].getLong("id")), "AP025_081_payBill_2");
        Object[] payBillIds = new Long[]{payBills[0].getLong("id")};
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(100L));
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)OperateOption.create());
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)OperateOption.create());
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finApBills[0].getLong("id")}, (Long[])payBillIds, false);
        SettleRecordTestHelper.setIsVoucherToTrue(settleRecords);
        OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])settleRecords, (OperateOption)OperateOption.create());
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
    }
}

