/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP025_082_PurOrder2PayAnd2Fin2ReturnMoneyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Collections.singletonList("AP025_082_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deletePayBills = Arrays.asList("AP025_082_payBill_1", "AP025_082_payBill_2");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecBills = Collections.singletonList("AP025_082_recBill_1");
        DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u5355 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355->\u9000\u6b3e\u9000\u7968(\u7269\u6599\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_082_purOrder_1", false, true, false);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject[] payBillArrAy = CasPayBillTestHelper.fullPushPayBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_082_payBill_1");
        DynamicObject paymenttype = payBillArrAy[0].getDynamicObject("paymenttype");
        DynamicObjectCollection entryColl = payBillArrAy[0].getDynamicObjectCollection("entry");
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            entry.set("e_corebillentryseq", (Object)(i + 1));
            entry.set("e_paymenttype", (Object)paymenttype);
        }
        SaveServiceHelper.save((DynamicObject[])payBillArrAy);
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_082_finApBill_1");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finApBills[0].getLong("id")), "AP025_082_payBill_2");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(100L));
        DynamicObject recBill = CasRecBillTestDataProvider.createCasRecBillByReturnMoney("AP025_082_recBill_1", BigDecimal.valueOf(100L), false, false);
        CasPayBillTestHelper.executeReturnMoney(this, payBills[0].getLong("id"), recBill.getLong("id"));
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
    }
}

