/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purrecieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataVo;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurReceiveBillTestHelper;
import org.junit.Test;

public class AP024_002_PurReceive2FinApWriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.purRecStratProcessTest(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u7ea2\u5b57\u91c7\u8d2d\u6536\u8d27-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.purRecStratProcessTest(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27(\u5f02\u5e01\u522b)-\u8d22\u52a1\u5e94\u4ed8-\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushFinAPBillDataVo(false);
        purRecDataVo.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purRecDataVo.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purRecBill = PurReceiveBillTestHelper.getAuditStatusPurRecBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purRecDataVo);
        long purRecBillId = purRecBill.getLong("id");
        ArrayList<Long> purRecBills = new ArrayList<Long>(1);
        purRecBills.add(purRecBillId);
        DynamicObject finApBill = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, true);
        long finApBillId = finApBill.getLong("id");
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        Thread.sleep(20000L);
        DynamicObject[] writeFinAPs = BOTPHelper.push("ap_finapbill", "ap_finapbill", "520819751337865216", finApBill);
        BusBillTestHelper.executeOperation("save", "ap_finapbill", writeFinAPs);
        purRecBill = BusinessDataServiceHelper.loadSingle((Object)purRecBill.getLong("id"), (String)"im_purreceivebill");
        PurInBillTestChecker.entryCheckByQty(purRecBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purRecBill.getLong("id"), finApBillId, false);
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)writeFinAPs[0].getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        FinApBillTestChecker.validateApFinJournalData(finApBillWrite);
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private void purRecStratProcessTest(boolean isReturn) throws InterruptedException {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushFinAPBillDataVo(isReturn);
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purRecBill1 = PurReceiveBillTestHelper.getAuditStatusPurRecBill(qtys, prices, purRecDataVo);
        long purRecBill1Id = purRecBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purRecBill2 = PurReceiveBillTestHelper.getAuditStatusPurRecBill(qtys, prices, purRecDataVo);
        long purRecBill2Id = purRecBill2.getLong("id");
        ArrayList<Long> purRecBills = new ArrayList<Long>(2);
        purRecBills.add(purRecBill1Id);
        purRecBills.add(purRecBill2Id);
        DynamicObject finApBill1 = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, false);
        DynamicObject finApBill2 = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, true);
        Thread.sleep(20000L);
        this.pushWriteOffBill(finApBill1, purRecBill1Id, purRecBill2Id, isReturn, true);
        this.pushWriteOffBill(finApBill2, purRecBill1Id, purRecBill2Id, isReturn, false);
    }

    private void pushWriteOffBill(DynamicObject finApBill, long purInBill1Id, long purInBill2Id, boolean isReturnBill, boolean isFirst) {
        DynamicObject[] writeFinAPs = BOTPHelper.push("ap_finapbill", "ap_finapbill", "520819751337865216", finApBill);
        BusBillTestHelper.executeOperation("save", "ap_finapbill", writeFinAPs);
        this.finApBillWriteCheckByPur(purInBill1Id, purInBill2Id, isReturnBill ? BigDecimal.valueOf(-1L) : BigDecimal.ONE, isFirst);
        this.finApBillWriteCheck(writeFinAPs[0].getLong("id"), finApBill.getLong("id"), isReturnBill ? BigDecimal.ONE : BigDecimal.valueOf(-1L));
        this.finApBillCheck(finApBill.getLong("id"), purInBill1Id, purInBill2Id, isReturnBill ? BigDecimal.valueOf(-1L) : BigDecimal.ONE);
    }

    private void finApBillWriteCheckByPur(long purInBill1Id, long purInBillId2, BigDecimal flag, boolean isFirst) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purreceivebill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBillId2, (String)"im_purreceivebill");
        if (isFirst) {
            PurRecBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurRecBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurRecBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurRecBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            PurRecBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurRecBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
    }

    private void finApBillWriteCheck(long finApBillWriteId, long finApBillId, BigDecimal flag) {
        DynamicObject finApBillWrite = BusinessDataServiceHelper.loadSingle((Object)finApBillWriteId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBillWrite.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBillWrite.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBillWrite);
        FinApBillTestChecker.validateApFinJournalData(finApBillWrite);
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBillWrite.getBoolean("iswrittenoff"));
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBillWrite.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBillWrite.getBoolean("hadwrittenoff"));
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, finApBillWrite, false);
    }

    private void finApBillCheck(long finApBillId, long purInBill1Id, long purInBill2Id, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailLockAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(2), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailSettleAmt((DynamicObject)entry.get(3), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        DynamicObjectCollection planEntity = finApBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.valueOf(812.5).multiply(flag), BigDecimal.ZERO, BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u51b2\u9500\u5355\u636e\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)finApBill.getBoolean("iswrittenoff"));
        AP024_002_PurReceive2FinApWriteTest.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + finApBill.getString("billno") + "\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u8868\u5934\u5df2\u88ab\u51b2\u9500\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)finApBill.getBoolean("hadwrittenoff"));
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill1Id, finApBillId, false);
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBill2Id, finApBillId, false);
    }
}

