/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import kd.fi.arapcommon.unittest.scene.process.saleorder.SaleOrderBaseTest;
import org.junit.Test;

public class AR022_001_BusSaleOrderTest
extends SaleOrderBaseTest {
    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u6682\u4f30\u5e94\u6536\u5355\u5355\u5143\u6d4b\u8bd5\u7c7b")
    @Test
    public void case1() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)6L, (String)"bd_taxrate");
        DynamicObject saleOrder1 = SaleOrderTestHelper.createSaleOrder("AR022_001-TEST-1", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId1 = saleOrder1.getLong("id");
        DynamicObject saleOrder2 = SaleOrderTestHelper.createSaleOrder("AR022_001-TEST-2", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId2 = saleOrder2.getLong("id");
        HashSet<Long> deleteEntryIds = new HashSet<Long>();
        deleteEntryIds.add(((DynamicObject)saleOrder1.getDynamicObjectCollection("billentry").get(0)).getLong("id"));
        deleteEntryIds.add(((DynamicObject)saleOrder2.getDynamicObjectCollection("billentry").get(0)).getLong("id"));
        Long busBillId1 = this.partPushBus1SaveTest(saleOrderId1, saleOrderId2, deleteEntryIds);
        Long busBillId2 = this.fullPushBus2SaveTest(saleOrderId1, saleOrderId2);
        this.bus1deleteTest(busBillId1, saleOrderId1, saleOrderId2);
        this.bus2deleteTest(busBillId2, saleOrderId1, saleOrderId2);
    }

    public Long partPushBus1SaveTest(Long saleOrderId1, Long saleOrderId2, Set<Long> deleteEntryIds) {
        Long busBillId1 = this.pushAndSaveBus(saleOrderId1, saleOrderId2, deleteEntryIds, new BigDecimal[]{BigDecimal.valueOf(5L), BigDecimal.valueOf(5L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(0), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(5L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(5L));
        this.doOperation("ar_busbill", "submit", Collections.singletonList(busBillId1));
        this.doOperation("ar_busbill", "audit", Collections.singletonList(busBillId1));
        return busBillId1;
    }

    public Long fullPushBus2SaveTest(Long saleOrderId1, Long saleOrderId2) {
        List<DynamicObject> busBillList = BOTPHelper.push("sm_salorder", "ar_busbill", "727977235356625920", Arrays.asList(saleOrderId1, saleOrderId2));
        AR022_001_BusSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6682\u4f30\u5355\u5f02\u5e38", (busBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject busBill = busBillList.get(0);
        busBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        Long busBillId2 = busBill.getLong("id");
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L));
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L));
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(10L));
        this.doOperation("ar_busbill", "submit", Collections.singletonList(busBillId2));
        this.doOperation("ar_busbill", "audit", Collections.singletonList(busBillId2));
        return busBillId2;
    }

    public void bus1deleteTest(Long busBillId1, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("ar_busbill", "unaudit", Collections.singletonList(busBillId1));
        this.doOperation("ar_busbill", "delete", Collections.singletonList(busBillId1));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L));
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(5L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L));
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(5L));
    }

    public void bus2deleteTest(Long busBillId2, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("ar_busbill", "unaudit", Collections.singletonList(busBillId2));
        this.doOperation("ar_busbill", "delete", Collections.singletonList(busBillId2));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(0), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries.get(1), BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkArJoinQty((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO);
    }

    private long pushAndSaveBus(Long saleOrderId1, Long saleOrderId2, Set<Long> deleteEntryIds, BigDecimal[] detailEntryQty, BigDecimal[] detailEntryPrice) {
        List<DynamicObject> busBillList = BOTPHelper.push("sm_salorder", "ar_busbill", "727977235356625920", Arrays.asList(saleOrderId1, saleOrderId2));
        AR022_001_BusSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6682\u4f30\u5355\u5f02\u5e38", (busBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject busBill = busBillList.get(0);
        BusBillTestHelper.setDetailEntryQtyAndPrice(busBill, deleteEntryIds, detailEntryQty, detailEntryPrice, true);
        busBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        return busBill.getLong("id");
    }
}

