/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import kd.fi.arapcommon.unittest.scene.process.saleorder.SaleOrderBaseTest;
import org.junit.Test;

public class AR022_002_FinArSaleOrderTest
extends SaleOrderBaseTest {
    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u6682\u4f30\u5e94\u6536-\u8d22\u52a1\u5e94\u6536\u5355\u5143\u6d4b\u8bd5")
    @Test
    public void case1() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)6L, (String)"bd_taxrate");
        DynamicObject saleOrder1 = SaleOrderTestHelper.createSaleOrder("AR022_002-TEST-1", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId1 = saleOrder1.getLong("id");
        DynamicObject saleOrder2 = SaleOrderTestHelper.createSaleOrder("AR022_002-TEST-2", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId2 = saleOrder2.getLong("id");
        Long finArBillId = this.fullPushFinArBillSaveTest(saleOrderId1, saleOrderId2);
        this.finArBillAuditTest(finArBillId, saleOrderId1, saleOrderId2);
        this.finArBillUnAuditTest(finArBillId, saleOrderId1, saleOrderId2);
        this.finArBillDeleteTest(finArBillId, saleOrderId1, saleOrderId2);
    }

    public Long fullPushFinArBillSaveTest(Long saleOrderId1, Long saleOrderId2) {
        List<DynamicObject> busBillList = BOTPHelper.push("sm_salorder", "ar_busbill", "727977235356625920", Arrays.asList(saleOrderId1, saleOrderId2));
        AR022_002_FinArSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6682\u4f30\u5355\u5f02\u5e38", (busBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject busBill = busBillList.get(0);
        busBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        long busBillId = busBill.getLong("id");
        this.doOperation("ar_busbill", "submit", Collections.singletonList(busBillId));
        this.doOperation("ar_busbill", "audit", Collections.singletonList(busBillId));
        List<DynamicObject> finBillList = BOTPHelper.push("ar_busbill", "ar_finarbill", "674365182167762944", Collections.singletonList(busBillId));
        AR022_002_FinArSaleOrderTest.assertTrue((String)"\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u5f02\u5e38", (busBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject finArBill = finBillList.get(0);
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        Long finArBillId = finArBill.getLong("id");
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        return finArBillId;
    }

    public void finArBillAuditTest(Long finArBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(finArBillId));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(finArBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
    }

    public void finArBillUnAuditTest(Long finArBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("ar_finarbill", "unaudit", Collections.singletonList(finArBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public void finArBillDeleteTest(Long finArBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("ar_finarbill", "delete", Collections.singletonList(finArBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

