/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import org.junit.Test;

public class AR022_022_SalOrdertoFinArWriteOffTest
extends AbstractJUnitTestPlugIn {
    private Long salOrderId1 = 0L;
    private Long salOrderId2 = 0L;
    private List<Long> salOrderIds = new ArrayList<Long>(2);
    private DynamicObject finArBill = null;

    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u51c6\u5907\u9500\u552e\u8ba2\u5355")
    @Test
    public void createBillInfo() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)2L, (String)"bd_taxrate");
        DynamicObject salOrder1 = SaleOrderTestHelper.createSaleOrder("AR022_018_SalOrder_01", "sm_SalesOrder_STD_BT_S", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        this.salOrderId1 = salOrder1.getLong("id");
        this.salOrderIds.add(this.salOrderId1);
        DynamicObject saleOrder2 = SaleOrderTestHelper.createSaleOrder("AR022_018_SalOrder_02", "sm_SalesOrder_STD_BT_S", taxRate, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        this.salOrderId2 = saleOrder2.getLong("id");
        this.salOrderIds.add(this.salOrderId2);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355->\u9500\u552e\u51fa\u5e93\u5355->\u6682\u4f30\u5e94\u6536\u5355->\u5f00\u7968\u5355->\u8d22\u52a1\u5e94\u6536\u5355")
    @Test
    public void salOrdertoFinAr() {
        List<DynamicObject> salOutBills = BOTPHelper.push("sm_salorder", "im_saloutbill", "610056021305574400", this.salOrderIds);
        OperationResult salOutSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])salOutBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(salOutSaveResult);
        ArrayList<Long> salOutBillIds = new ArrayList<Long>(1);
        for (DynamicObject salOutBill : salOutBills) {
            salOutBill.set("billstatus", (Object)"C");
            salOutBillIds.add(salOutBill.getLong("id"));
        }
        SaveServiceHelper.update((DynamicObject[])salOutBills.toArray(new DynamicObject[0]));
        List<DynamicObject> busBills = BOTPHelper.push("im_saloutbill", "ar_busbill", "727376405603593216", salOutBillIds);
        OperationResult busBillSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])busBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(busBillSaveResult);
        DynamicObject busBill = busBills.get(0);
        long busBillId = busBill.getLong("id");
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        DynamicObject recProperty = BaseDataTestProvider.getRecProperty();
        busBill.set("payproperty", (Object)recProperty);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{busBill});
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_busbill", (Object[])new Object[]{busBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_busbill", (Object[])new Object[]{busBillId}, (OperateOption)OperateOption.create());
        List<DynamicObject> invoices = BOTPHelper.push("ar_busbill", "ar_invoice", "678812139145673728", Collections.singletonList(busBillId));
        OperationResult invoiceSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_invoice", (DynamicObject[])invoices.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(invoiceSaveResult);
        DynamicObject invoice = invoices.get(0);
        Long orgId = invoice.getLong("org.id");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("ar_001", Boolean.FALSE);
        SystemParameterHelper.setSystemParameter(true, orgId, params);
        invoice.set("billstatus", (Object)"B");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{invoice});
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_invoice", (Object[])new Object[]{invoice.getLong("id")}, (OperateOption)OperateOption.create());
        List<DynamicObject> finArBills = BOTPHelper.push("ar_invoice", "ar_finarbill", "460543480779767808", Collections.singletonList(invoice.getLong("id")));
        OperationResult finBillSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])finArBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(finBillSaveResult);
        this.finArBill = finArBills.get(0);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355(\u81ea\u52a8\u786e\u8ba4)\u63d0\u4ea4\u5ba1\u6838")
    @Test
    public void FinArBillSubmmitandAudit() {
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{this.finArBill}, (OperateOption)OperateOption.create());
        AR022_022_SalOrdertoFinArWriteOffTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        FinArBillTestHelper.setAR005(this.finArBill.getLong("org.id"), true);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{this.finArBill}, (OperateOption)OperateOption.create());
        AR022_022_SalOrdertoFinArWriteOffTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355(\u81ea\u52a8\u786e\u8ba4)\u51b2\u9500")
    @Test
    public void FinArBillWriteOff() {
        DynamicObject[] writeOffBills = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", this.finArBill);
        DynamicObject writeOffBill = writeOffBills[0];
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{writeOffBill}, (OperateOption)OperateOption.create());
        AR022_022_SalOrdertoFinArWriteOffTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\uff0c\u51b2\u9500\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        DynamicObject salOrder1 = BusinessDataServiceHelper.loadSingle((Object)this.salOrderId1, (String)"sm_salorder");
        DynamicObjectCollection entry1 = salOrder1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkAddQtyAndAmt((DynamicObject)entry1.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkAddQtyAndAmt((DynamicObject)entry1.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry1.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry1.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject salOrder2 = BusinessDataServiceHelper.loadSingle((Object)this.salOrderId2, (String)"sm_salorder");
        DynamicObjectCollection entry2 = salOrder2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkAddQtyAndAmt((DynamicObject)entry2.get(0), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkAddQtyAndAmt((DynamicObject)entry2.get(1), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

