/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.saleorder.SaleOrderBaseTest;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR022_028_SaleOutCasRecSaleOrderTest
extends SaleOrderBaseTest {
    public void initData() {
        super.initData();
        this.deleteFinAndRec(Arrays.asList("AR022_028-TEST-1", "AR022_028-TEST-2"));
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u6682\u4f30\u5e94\u6536-\u8d22\u52a1\u5e94\u6536\u5355\u5143\u6d4b\u8bd5")
    @Test
    public void case1() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)6L, (String)"bd_taxrate");
        DynamicObject saleOrder1 = SaleOrderTestHelper.createSaleOrder("AR022_028-TEST-1", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId1 = saleOrder1.getLong("id");
        DynamicObject saleOrder2 = SaleOrderTestHelper.createSaleOrder("AR022_028-TEST-2", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        Long saleOrderId2 = saleOrder2.getLong("id");
        Map<String, Long> map = this.fullPushCasRecAuditTest(saleOrderId1, saleOrderId2);
        Long finArBillId = map.get("ar_finarbill");
        Long casRecBillId = map.get("cas_recbill");
        this.casRecReceiveRecTest(casRecBillId, saleOrderId1, saleOrderId2);
        this.casRecCancelRecTest(casRecBillId, saleOrderId1, saleOrderId2);
        this.handleSettleRecordTest(casRecBillId, finArBillId, saleOrderId1, saleOrderId2);
    }

    public Map<String, Long> fullPushCasRecAuditTest(Long saleOrderId1, Long saleOrderId2) {
        HashMap<String, Long> map = new HashMap<String, Long>(2);
        List<DynamicObject> saleOutBillList = BOTPHelper.push("sm_salorder", "im_saloutbill", "610056021305574400", Arrays.asList(saleOrderId1, saleOrderId2));
        AR022_028_SaleOutCasRecSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u9500\u552e\u51fa\u5e93\u5355\u5f02\u5e38", (saleOutBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject saleOutBill = saleOutBillList.get(0);
        saleOutBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOutBill});
        long saleOutBillId = saleOutBill.getLong("id");
        List<DynamicObject> finBillList = BOTPHelper.push("im_saloutbill", "ar_finarbill", "645358541351198720", Collections.singletonList(saleOutBillId));
        AR022_028_SaleOutCasRecSaleOrderTest.assertTrue((String)"\u9500\u552e\u51fa\u5e93\u5355\u4e0b\u63a8\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u5f02\u5e38", (finBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject finArBill = finBillList.get(0);
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        Long finArBillId = finArBill.getLong("id");
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(finArBillId));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(finArBillId));
        map.put("ar_finarbill", finArBillId);
        List<DynamicObject> casRecBillList = BOTPHelper.push("ar_finarbill", "cas_recbill", "440257677843523584", Collections.singletonList(finArBillId));
        AR022_028_SaleOutCasRecSaleOrderTest.assertTrue((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u751f\u6210\u6536\u6b3e\u5355\u5f02\u5e38", (casRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject casRecBill = casRecBillList.get(0);
        casRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        casRecBill = BusinessDataServiceHelper.loadSingle(result2.getSuccessPkIds().get(0), (String)"cas_recbill");
        Long casRecBillId = casRecBill.getLong("id");
        casRecBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        map.put("cas_recbill", casRecBillId);
        this.doOperation("cas_recbill", "audit", Collections.singletonList(casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.valueOf(1000L));
        return map;
    }

    public void casRecReceiveRecTest(Long casRecBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.ZERO, BigDecimal.valueOf(2000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.ZERO, BigDecimal.valueOf(2000L));
    }

    public void casRecCancelRecTest(Long casRecBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("cas_recbill", "cancelrec", Collections.singletonList(casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public void handleSettleRecordTest(Long casRecBillId, Long finArBillId, Long saleOrderId1, Long saleOrderId2) {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(casRecBillId));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{finArBillId}, new Long[]{casRecBillId}, true);
        AR022_028_SaleOutCasRecSaleOrderTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (settleRecords.length > 0 ? 1 : 0) != 0);
        for (DynamicObject settleRecord2 : settleRecords) {
            settleRecord2.set("isvoucher", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        List<Long> settleRecordIds = Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).collect(Collectors.toList());
        this.doOperation("ar_settlerecord", "unsettle", settleRecordIds);
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject[] settleRecords1 = SettleRecordTestHelper.loadData(new Long[]{finArBillId}, new Long[]{casRecBillId}, true);
        AR022_028_SaleOutCasRecSaleOrderTest.assertTrue((String)"\u672a\u751f\u6210\u5bf9\u5e94\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55", (settleRecords1.length > settleRecords.length ? 1 : 0) != 0);
    }
}

