/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SaleOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.saleorder.SaleOrderBaseTest;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR022_050_CasRecFinSaleOrderTest
extends SaleOrderBaseTest {
    private long saleOrderId1;
    private long saleOrderId2;
    private long saleOrderId3;
    private long saleOrderId4;
    private long casRecBillId;
    private long finArBillId;

    public void initData() {
        super.initData();
        this.deleteFinAndRec(Arrays.asList("AR022_050-TEST-1", "AR022_050-TEST-2"));
        SaleOrderBillDataVO dataVO = new SaleOrderBillDataVO();
        dataVO.setBillNo("AR022_050-TEST-1");
        dataVO.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder1 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId1 = saleOrder1.getLong("id");
        SaleOrderBillDataVO dataVO2 = new SaleOrderBillDataVO();
        dataVO2.setBillNo("AR022_050-TEST-2");
        dataVO2.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO2.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO2.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder2 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO2, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId2 = saleOrder2.getLong("id");
        SaleOrderBillDataVO dataVO3 = new SaleOrderBillDataVO();
        dataVO3.setBillNo("AR022_050-TEST-3");
        dataVO3.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO3.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO3.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder3 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO3, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId3 = saleOrder3.getLong("id");
        SaleOrderBillDataVO dataVO4 = new SaleOrderBillDataVO();
        dataVO4.setBillNo("AR022_050-TEST-4");
        dataVO4.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO4.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO4.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder4 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO4, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId4 = saleOrder4.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u8d22\u52a1\u5e94\u6536\u5355 & \u9500\u552e\u8ba2\u5355-\u6536\u6b3e\u5355")
    @Test
    public void partPushCasRecFinAuditTest() {
        List<DynamicObject> finArBillList = BOTPHelper.push("sm_salorder", "ar_finarbill", "940441051997418496", Arrays.asList(this.saleOrderId1, this.saleOrderId2));
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u5f02\u5e38", (finArBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject finArBill = finArBillList.get(0);
        DynamicObjectCollection finDetailEntries = finArBill.getDynamicObjectCollection("entry");
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(0), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(1), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(2), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(3), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setEntryAmount(finArBill, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)});
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        this.finArBillId = finArBill.getLong("id");
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(this.finArBillId));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(this.finArBillId));
        List<DynamicObject> casRecBillList = BOTPHelper.push("sm_salorder", "cas_recbill", "711443854984779776", Arrays.asList(this.saleOrderId1, this.saleOrderId2));
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6536\u6b3e\u5904\u7406\u5355\u5f02\u5e38", (casRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject casRecBill = casRecBillList.get(0);
        casRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        CasRecTestHelper.setEntryAmt(casRecBill, new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        casRecBill = BusinessDataServiceHelper.loadSingle(result2.getSuccessPkIds().get(0), (String)"cas_recbill");
        this.casRecBillId = casRecBill.getLong("id");
        casRecBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        this.doOperation("cas_recbill", "audit", Collections.singletonList(this.casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e")
    @Test
    public void casRecReceiveTest() {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838")
    @Test
    public void finArBillUnAuditTest() {
        this.doOperation("ar_finarbill", "unaudit", Collections.singletonList(this.finArBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355\u5ba1\u6838")
    @Test
    public void finArBillAuditTest() {
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(this.finArBillId));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(this.finArBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6536\u6b3e\u5355\u53d6\u6d88\u6536\u6b3e")
    @Test
    public void casRecCancelTest() {
        this.doOperation("cas_recbill", "cancelrec", Collections.singletonList(this.casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.ZERO);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u7ed3\u7b97\u8bb0\u5f55\u624b\u5de5\u53cd\u7ed3\u7b97")
    @Test
    public void handleSettleRecord() {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.casRecBillId));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{this.finArBillId}, new Long[]{this.casRecBillId}, true);
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (settleRecords.length > 0 ? 1 : 0) != 0);
        for (DynamicObject settleRecord2 : settleRecords) {
            settleRecord2.set("isvoucher", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        List<Long> settleRecordIds = Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).collect(Collectors.toList());
        this.doOperation("ar_settlerecord", "unsettle", settleRecordIds);
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(1000L), BigDecimal.ZERO);
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(5L), BigDecimal.valueOf(5L), BigDecimal.valueOf(500L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject[] settleRecords1 = SettleRecordTestHelper.loadData(new Long[]{this.finArBillId}, new Long[]{this.casRecBillId}, true);
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u672a\u751f\u6210\u5bf9\u5e94\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55", (settleRecords1.length > settleRecords.length ? 1 : 0) != 0);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u6536\u6b3e\u5355-\u786e\u8ba4\u6536\u6b3e & \u9500\u552e\u8ba2\u5355-\u8d22\u52a1\u5e94\u6536\u5355-\u63d0\u4ea4(\u63d0\u4ea4\u6001\u7ed3\u7b97)")
    @Test
    public void sumbitSettleTest() {
        List<DynamicObject> casRecBillList = BOTPHelper.push("sm_salorder", "cas_recbill", "711443854984779776", Arrays.asList(this.saleOrderId3, this.saleOrderId4));
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6536\u6b3e\u5904\u7406\u5355\u5f02\u5e38", (casRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject casRecBill = casRecBillList.get(0);
        casRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        CasRecTestHelper.setEntryAmt(casRecBill, new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        casRecBill = BusinessDataServiceHelper.loadSingle(result2.getSuccessPkIds().get(0), (String)"cas_recbill");
        this.casRecBillId = casRecBill.getLong("id");
        casRecBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        this.doOperation("cas_recbill", "audit", Collections.singletonList(this.casRecBillId));
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.casRecBillId));
        List<DynamicObject> finArBillList = BOTPHelper.push("sm_salorder", "ar_finarbill", "940441051997418496", Arrays.asList(this.saleOrderId3, this.saleOrderId4));
        AR022_050_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u5f02\u5e38", (finArBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject finArBill = finArBillList.get(0);
        DynamicObjectCollection findetailEntries3 = finArBill.getDynamicObjectCollection("entry");
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)findetailEntries3.get(0), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)findetailEntries3.get(1), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)findetailEntries3.get(2), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)findetailEntries3.get(3), BigDecimal.valueOf(5L));
        FinArBillTestHelper.setEntryAmount(finArBill, new BigDecimal[]{BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L)});
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        this.finArBillId = finArBill.getLong("id");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ar_016", 1);
        SystemParameterHelper.setSystemParameter(true, (Long)finArBill.getDynamicObject("org").getPkValue(), paramMap);
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(this.finArBillId));
        QFilter filter = new QFilter("mainbillid", "in", (Object)new Long[]{this.finArBillId});
        filter.and(new QFilter("entry.billid", "in", (Object)new Long[]{this.casRecBillId}));
        filter.and(new QFilter("billstatus", "=", (Object)"B"));
        KDAssert.assertEquals((boolean)true, (boolean)SettleRecordTestHelper.exists(filter, false));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(this.finArBillId));
        DynamicObject saleOrderBill3 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId3, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill3, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries3 = saleOrderBill3.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries3.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObject saleOrderBill4 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId4, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill4, BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
        DynamicObjectCollection planEntries34 = saleOrderBill4.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries34.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L));
    }
}

