/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;

public class ManualSettleUnitTestHelper {
    public static DynamicObject[] buildMainRowsByTotal(DynamicObject mainBill, BigDecimal curSettleAmt, boolean isAr) {
        ArrayList<BillRowVO> mainBills = new ArrayList<BillRowVO>(1);
        BillRowVO rowModel = new BillRowVO(mainBill, curSettleAmt);
        mainBills.add(rowModel);
        return ManualSettleUnitTestHelper.buildMainRowsByTotal(mainBills, isAr);
    }

    public static DynamicObject[] buildMainRowsByTotal(List<BillRowVO> mainBills, boolean isAr) {
        ArrayList<DynamicObject> mainRows = new ArrayList<DynamicObject>(mainBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_handsettle" : "ap_handsettle"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("mainbill")).getDynamicCollectionItemPropertyType();
        for (BillRowVO rowModel : mainBills) {
            DynamicObject mainBill = rowModel.getBill();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("id", (Object)mainBill.getLong("id"));
            row.set("entryid", (Object)mainBill.getLong("id"));
            row.set("billno", mainBill.get("billno"));
            row.set("billtype", (Object)mainBill.getDataEntityType().getName());
            row.set("exchangerate", mainBill.get("exchangerate"));
            row.set("cursettleamt", (Object)rowModel.getCurSettleAmt());
            mainRows.add(row);
        }
        return mainRows.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] buildAsstRowsByTotal(DynamicObject asstBill, BigDecimal curSettleAmt, boolean isAr) {
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(1);
        BillRowVO rowModel = new BillRowVO(asstBill, curSettleAmt);
        asstBills.add(rowModel);
        return ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, isAr);
    }

    public static DynamicObject[] buildAsstRowsByTotal(List<BillRowVO> asstBills, boolean isAr) {
        ArrayList<DynamicObject> asstRows = new ArrayList<DynamicObject>(asstBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_handsettle" : "ap_handsettle"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("asstbill")).getDynamicCollectionItemPropertyType();
        for (BillRowVO rowModel : asstBills) {
            DynamicObject asstBill = rowModel.getBill();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("asst_id", (Object)asstBill.getLong("id"));
            row.set("asst_entryid", (Object)asstBill.getLong("id"));
            row.set("asst_billno", asstBill.get("billno"));
            row.set("asst_exchangerate", asstBill.get("exchangerate"));
            row.set("asst_billtype", (Object)asstBill.getDataEntityType().getName());
            row.set("asst_cursettleamt", (Object)rowModel.getCurSettleAmt());
            asstRows.add(row);
        }
        return asstRows.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] buildMainRowsByEntry(DynamicObject mainBill, DynamicObject mainEntry, BigDecimal curSettleAmt, boolean isAr) {
        ArrayList<EntryRowVO> mainBills = new ArrayList<EntryRowVO>(1);
        EntryRowVO rowModel = new EntryRowVO(mainBill, mainEntry, curSettleAmt);
        mainBills.add(rowModel);
        return ManualSettleUnitTestHelper.buildMainRowsByEntry(mainBills, isAr);
    }

    public static DynamicObject[] buildMainRowsByEntry(List<EntryRowVO> mainBills, boolean isAr) {
        ArrayList<DynamicObject> mainRows = new ArrayList<DynamicObject>(mainBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_handsettle" : "ap_handsettle"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("mainbill")).getDynamicCollectionItemPropertyType();
        for (EntryRowVO rowModel : mainBills) {
            DynamicObject mainBill = rowModel.getBill();
            DynamicObject mainEntry = rowModel.getEntry();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("id", (Object)mainBill.getLong("id"));
            row.set("entryid", (Object)mainEntry.getLong("id"));
            row.set("billno", mainBill.get("billno"));
            row.set("billtype", (Object)mainBill.getDataEntityType().getName());
            row.set("exchangerate", mainBill.get("exchangerate"));
            row.set("cursettleamt", (Object)rowModel.getCurSettleAmt());
            mainRows.add(row);
        }
        return mainRows.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] buildAsstRowsByEntry(DynamicObject asstBill, DynamicObject asstEntry, BigDecimal curSettleAmt, boolean isAr) {
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(1);
        EntryRowVO rowModel = new EntryRowVO(asstBill, asstEntry, curSettleAmt);
        asstBills.add(rowModel);
        return ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, isAr);
    }

    public static DynamicObject[] buildAsstRowsByEntry(List<EntryRowVO> asstBills, boolean isAr) {
        ArrayList<DynamicObject> asstRows = new ArrayList<DynamicObject>(asstBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_handsettle" : "ap_handsettle"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("asstbill")).getDynamicCollectionItemPropertyType();
        for (EntryRowVO rowModel : asstBills) {
            DynamicObject asstBill = rowModel.getBill();
            DynamicObject asstEntry = rowModel.getEntry();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("asst_id", (Object)asstBill.getLong("id"));
            row.set("asst_entryid", (Object)asstEntry.getLong("id"));
            row.set("asst_billno", asstBill.get("billno"));
            row.set("asst_exchangerate", asstBill.get("exchangerate"));
            row.set("asst_billtype", (Object)asstBill.getDataEntityType().getName());
            row.set("asst_cursettleamt", (Object)rowModel.getCurSettleAmt());
            asstRows.add(row);
        }
        return asstRows.toArray(new DynamicObject[0]);
    }

    public static Set<Long> getSettleRecordIds(Long[] mainIds, Long[] asstIds, boolean isAr) {
        String entityName = isAr ? "ar_settlerecord" : "ap_settlerecord";
        QFilter filter = new QFilter("mainbillid", "in", (Object)mainIds);
        filter.and(new QFilter("entry.billid", "in", (Object)asstIds));
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filter.toArray());
        return Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).collect(Collectors.toSet());
    }
}

