/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.settle.news;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class ApPaySettleNewUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testBOTPDetail_1() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_001", org, details);
        Long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(50L), "ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_001");
        Long[] mainIds = new Long[]{apBillId};
        Long[] asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_001(mainIds, asstIds);
        DynamicObject[] twoPayBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_002");
        asstIds = new Long[]{twoPayBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPDetail_1_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(mainIds[0]);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testBOTPDetail_2() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_002", org, details);
        Long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(20L), "ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_003");
        Long[] mainIds = new Long[]{apBillId};
        Long[] asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_001(mainIds, asstIds);
        DynamicObject[] twoPayBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_004");
        asstIds = new Long[]{twoPayBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPDetail_2_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(mainIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testBOTPPlan_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_003", org, details);
        Long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(50L), "ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_004");
        Long[] mainIds = new Long[]{apBillId};
        Long[] asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_001(mainIds, asstIds);
        DynamicObject[] twoPayBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_006");
        asstIds = new Long[]{twoPayBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPPlan_1_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(mainIds[0]);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testBOTPPlan_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_004", org, details);
        Long apBillId = apBill.getLong("id");
        DynamicObject[] payBills = CasPayBillTestHelper.pushPayBill(BigDecimal.valueOf(20L), "ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_007");
        Long[] mainIds = new Long[]{apBillId};
        Long[] asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_001(mainIds, asstIds);
        DynamicObject[] twoPayBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(apBillId), "ApPay_New_Pay_008");
        asstIds = new Long[]{twoPayBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{payBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{payBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPPlan_2_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{twoPayBills[0].getLong("id")}, (OperateOption)option);
        FinApBillTestChecker.validateInitialApFin(mainIds[0]);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testCoreDetail_1() {
        String coreBillNo = "ApPay_New_AP_Core_1";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_005", org, details);
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setBillNo("ApPay_New_Pay_009").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, payEntries);
        OperateOption option = OperateOption.create();
        OperationResult payResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(payResult);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)payResult.isSuccess());
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestCoreDetail_1_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_1_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_1_001(mainIds, asstIds);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testCoreDetail_2() {
        String coreBillNo = "ApPay_New_AP_Core_2";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_006", org, details);
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setBillNo("ApPay_New_Pay_010").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, payEntries);
        OperateOption option = OperateOption.create();
        OperationResult payResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(payResult);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)payResult.isSuccess());
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestCoreDetail_2_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_2_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_2_001(mainIds, asstIds);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testCorePlan_1() {
        String coreBillNo = "ApPay_New_AP_Core_3";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_007", org, details);
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setBillNo("ApPay_New_Pay_011").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, payEntries);
        OperateOption option = OperateOption.create();
        OperationResult payResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(payResult);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)payResult.isSuccess());
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestCorePlan_1_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_1_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_1_001(mainIds, asstIds);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testCorePlan_2() {
        String coreBillNo = "ApPay_New_AP_Core_4";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_008", org, details);
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setBillNo("ApPay_New_Pay_012").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, payEntries);
        OperateOption option = OperateOption.create();
        OperationResult payResult = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(payResult);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)payResult.isSuccess());
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestCorePlan_2_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_2_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{apBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_2_001(mainIds, asstIds);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testManualDetail_1() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_009", org, details);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("ApPay_New_Pay_013", org, payEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(apBill, BigDecimal.valueOf(70L), false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(payBill, BigDecimal.valueOf(70L), false);
        IManualSettleService service = SettleServiceFactory.getManualService("appaysettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestManualDetail_1_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualDetail_1_002(mainIds, asstIds);
    }

    @TestMethod(value=10)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testManualDetail_2() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_010", org, details);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("ApPay_New_Pay_014", org, payEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(apBill, BigDecimal.valueOf(40L), false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(payBill, BigDecimal.valueOf(40L), false);
        IManualSettleService service = SettleServiceFactory.getManualService("appaysettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestManualDetail_2_001(mainIds, asstIds);
        QFilter filter = new QFilter("mainbillid", "in", (Object)mainIds);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id", (QFilter[])filter.toArray());
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).distinct().toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualDetail_2_002(mainIds, asstIds);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testManualPlan_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_011", org, details);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("ApPay_New_Pay_015", org, payEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(apBill, BigDecimal.valueOf(40L), false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(payBill, BigDecimal.valueOf(40L), false);
        IManualSettleService service = SettleServiceFactory.getManualService("appaysettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestManualPlan_1_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualPlan_1_002(mainIds, asstIds);
    }

    @TestMethod(value=12)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testManualPlan_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> details = new ArrayList<FinApBillDataDetailVO>(2);
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildNewByPriceAndQuantity("ApPay_New_AP_012", org, details);
        ArrayList<CasPayBillDataDetailVO> payEntries = new ArrayList<CasPayBillDataDetailVO>(2);
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        payEntries.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal("ApPay_New_Pay_016", org, payEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(apBill, BigDecimal.valueOf(40L), false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(payBill, BigDecimal.valueOf(40L), false);
        IManualSettleService service = SettleServiceFactory.getManualService("appaysettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForTestManualPlan_2_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualPlan_2_002(mainIds, asstIds);
    }

    private void checkForTestBOTPDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPDetail_1_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTestBOTPDetail_1_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
    }

    private void checkForTestBOTPDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPDetail_2_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
    }

    private void checkForTestBOTPDetail_2_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestBOTPPlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPPlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPPlan_1_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTestBOTPPlan_1_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTestBOTPPlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPPlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestBOTPPlan_2_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestBOTPPlan_2_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestCoreDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestCoreDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestCoreDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestCoreDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestCorePlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestCorePlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestCorePlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestCorePlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestManualDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(90L), BigDecimal.valueOf(90L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt(entry1, BigDecimal.valueOf(20L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L));
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestManualDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestManualDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestManualDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestManualPlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "partsettle");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(120L), BigDecimal.valueOf(120L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(25L), BigDecimal.valueOf(75L), BigDecimal.valueOf(25L), BigDecimal.valueOf(25L), BigDecimal.valueOf(75L), BigDecimal.valueOf(75L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(15L), BigDecimal.valueOf(45L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestManualPlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }

    private void checkForTestManualPlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateApFinHeadSettleStatus(needCheckMainBill, "settled");
        FinApBillTestChecker.validateApFinHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("detailentry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, false);
    }

    private void checkForTestManualPlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill(needCheckAsstBill);
    }
}

