/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.settle.news;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class ArRecSettleNewUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testBOTPDeail_1() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_001", org, details);
        Long arBillId = arBill.getLong("id");
        DynamicObject[] recBills = CasRecTestHelper.pushRecBill(BigDecimal.valueOf(50L), "ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_001");
        Long[] mainIds = new Long[]{arBillId};
        Long[] asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_001(mainIds, asstIds);
        DynamicObject[] twoRecBills = CasRecTestHelper.fullPushRecBill("ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_002");
        asstIds = new Long[]{twoRecBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPDetail_1_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPDetail_1_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        FinArBillTestChecker.validateInitialArFin(mainIds[0]);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u884c\u5206\u5f55")
    @Test
    public void testBOTPDetail_2() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_002", org, details);
        Long arBillId = arBill.getLong("id");
        DynamicObject[] recBills = CasRecTestHelper.pushRecBill(BigDecimal.valueOf(20L), "ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_003");
        Long[] mainIds = new Long[]{arBillId};
        Long[] asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_001(mainIds, asstIds);
        DynamicObject[] twoRecBills = CasRecTestHelper.fullPushRecBill("ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_004");
        asstIds = new Long[]{twoRecBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPDetail_2_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPDetail_2_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        FinArBillTestChecker.validateInitialArFin(mainIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testBOTPPlan_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_003", org, details);
        Long arBillId = arBill.getLong("id");
        DynamicObject[] recBills = CasRecTestHelper.pushRecBill(BigDecimal.valueOf(50L), "ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_004");
        Long[] mainIds = new Long[]{arBillId};
        Long[] asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_001(mainIds, asstIds);
        DynamicObject[] twoRecBills = CasRecTestHelper.fullPushRecBill("ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_006");
        asstIds = new Long[]{twoRecBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPPlan_1_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTESTBOTPPlan_1_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        FinArBillTestChecker.validateInitialArFin(mainIds[0]);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e->BOTP\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testBOTPPlan_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_004", org, details);
        Long arBillId = arBill.getLong("id");
        DynamicObject[] recBills = CasRecTestHelper.pushRecBill(BigDecimal.valueOf(20L), "ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_007");
        Long[] mainIds = new Long[]{arBillId};
        Long[] asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_001(mainIds, asstIds);
        DynamicObject[] twoRecBills = CasRecTestHelper.fullPushRecBill("ar_finarbill", Collections.singletonList(arBillId), "ArRec_New_Rec_008");
        asstIds = new Long[]{twoRecBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_002(mainIds, asstIds);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        asstIds = new Long[]{recBills[0].getLong("id")};
        this.checkForTestBOTPPlan_2_003(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recBills[0].getLong("id")}, (OperateOption)option);
        this.checkForTestBOTPPlan_2_004(mainIds);
        OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{twoRecBills[0].getLong("id")}, (OperateOption)option);
        FinArBillTestChecker.validateInitialArFin(mainIds[0]);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testCoreDetail_1() {
        String coreBillNo = "ArRec_New_AR_Core_1";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_005", org, details);
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setBillNo("ArRec_New_Rec_009").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, recEntries);
        OperateOption option = OperateOption.create();
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])new Long[]{recBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25", (boolean)true, (boolean)recResult.isSuccess());
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestCoreDetail_1_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_1_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_1_001(mainIds, asstIds);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testCoreDetail_2() {
        String coreBillNo = "ArRec_New_AR_Core_2";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_006", org, details);
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setBillNo("ArRec_New_Rec_010").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, recEntries);
        OperateOption option = OperateOption.create();
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])new Long[]{recBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25", (boolean)true, (boolean)recResult.isSuccess());
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestCoreDetail_2_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_2_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCoreDetail_2_001(mainIds, asstIds);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testCorePlan_1() {
        String coreBillNo = "ArRec_New_AR_Core_3";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_007", org, details);
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setBillNo("ArRec_New_Rec_011").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, recEntries);
        OperateOption option = OperateOption.create();
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])new Long[]{recBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25", (boolean)true, (boolean)recResult.isSuccess());
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestCorePlan_1_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_1_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_1_001(mainIds, asstIds);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u6838\u5fc3\u5355\u636e\u53f7\u81ea\u52a8\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testCorePlan_2() {
        String coreBillNo = "ArRec_New_AR_Core_4";
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_008", org, details);
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setBillNo("ArRec_New_Rec_012").setOrg(org).setStatus("C").setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1).setCorebillno(coreBillNo).setCorebillentryseq(1L));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-30L)).setSeq(2).setCorebillno(coreBillNo).setCorebillentryseq(2L));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, recEntries);
        OperateOption option = OperateOption.create();
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])new Long[]{recBill.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25", (boolean)true, (boolean)recResult.isSuccess());
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestCorePlan_2_001(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_2_002(mainIds, asstIds);
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Long[]{arBill.getLong("id")}, (OperateOption)option);
        this.checkForTestCorePlan_2_001(mainIds, asstIds);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testManualDetail_1() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_009", org, details);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal("ArRec_New_Rec_013", org, recEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(arBill, BigDecimal.valueOf(70L), true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(recBill, BigDecimal.valueOf(70L), true);
        IManualSettleService service = SettleServiceFactory.getManualService("recsettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestManualDetail_1_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualDetail_1_002(mainIds, asstIds);
    }

    @TestMethod(value=10)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u7269\u6599\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testManualDetail_2() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_010", org, details);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal("ArRec_New_Rec_014", org, recEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(arBill, BigDecimal.valueOf(40L), true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(recBill, BigDecimal.valueOf(40L), true);
        IManualSettleService service = SettleServiceFactory.getManualService("recsettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestManualDetail_2_001(mainIds, asstIds);
        QFilter filter = new QFilter("mainbillid", "in", (Object)mainIds);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)"id", (QFilter[])filter.toArray());
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).distinct().toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualDetail_2_002(mainIds, asstIds);
    }

    @TestMethod(value=11)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u6570\u5206\u5f55\u884c")
    @Test
    public void testManualPlan_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_011", org, details);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal("ArRec_New_Ar_015", org, recEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(arBill, BigDecimal.valueOf(40L), true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(recBill, BigDecimal.valueOf(40L), true);
        IManualSettleService service = SettleServiceFactory.getManualService("recsettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestManualPlan_1_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualPlan_1_002(mainIds, asstIds);
    }

    @TestMethod(value=12)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e->\u624b\u5de5\u7ed3\u7b97->\u8ba1\u5212\u884c\u7ed3\u7b97\u6a21\u578b->\u6b63\u8d1f\u5206\u5f55\u884c")
    @Test
    public void testManualPlan_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> details = new ArrayList<FinArBillDataDetailVO>(2);
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        details.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity("ArRec_New_AR_012", org, details);
        ArrayList<CasRecBillDataDetailVO> recEntries = new ArrayList<CasRecBillDataDetailVO>(2);
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(10L)).setSeq(1));
        recEntries.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(30L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal("ArRec_New_Rec_016", org, recEntries);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal(arBill, BigDecimal.valueOf(40L), true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(recBill, BigDecimal.valueOf(40L), true);
        IManualSettleService service = SettleServiceFactory.getManualService("recsettle");
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk(orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam(orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForTestManualPlan_2_001(mainIds, asstIds);
        Set<Long> settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds(mainIds, asstIds, true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unSettleResult);
        this.checkForTestManualPlan_2_002(mainIds, asstIds);
    }

    private void checkForTestBOTPDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPDetail_1_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTestBOTPDetail_1_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
    }

    private void checkForTestBOTPDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPDetail_2_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
    }

    private void checkForTestBOTPDetail_2_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestBOTPPlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPPlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPPlan_1_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTESTBOTPPlan_1_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
    }

    private void checkForTestBOTPPlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPPlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill(needCheckMainBill, true, false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestBOTPPlan_2_003(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestBOTPPlan_2_004(Long[] mainIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    private void checkForTestCoreDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestCoreDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestCoreDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestCoreDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestCorePlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(80L), BigDecimal.valueOf(80L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestCorePlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestCorePlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestCorePlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestManualDetail_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(90L), BigDecimal.valueOf(90L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(70L), BigDecimal.valueOf(70L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry0, BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt(entry1, BigDecimal.valueOf(20L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L));
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestManualDetail_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestManualDetail_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "settled");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestManualDetail_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestManualPlan_1_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "partsettle");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(120L), BigDecimal.valueOf(120L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(25L), BigDecimal.valueOf(75L), BigDecimal.valueOf(25L), BigDecimal.valueOf(25L), BigDecimal.valueOf(75L), BigDecimal.valueOf(75L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(15L), BigDecimal.valueOf(45L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L), BigDecimal.valueOf(45L), BigDecimal.valueOf(45L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry1, BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestManualPlan_1_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }

    private void checkForTestManualPlan_2_001(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus(needCheckMainBill, "settled");
        FinArBillTestChecker.validateHeadSettleAmt(needCheckMainBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry0, BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt(detailEntry1, BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(-60L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt(planEntry0, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(mainIds, asstIds, true);
    }

    private void checkForTestManualPlan_2_002(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData(mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill(needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData(asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill(needCheckAsstBill);
    }
}

