/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.unittest.scene.process.verify.EntryRowVO;

public class PurBillManualVerifyBuilder {
    public static List<EntryRowVO> build(String entity, long billId) {
        QFilter purFilter = new QFilter("id", "=", (Object)billId);
        String selector = "id,billno,biztime,settlecurrency,currency,exchangerate,billentry.id,billentry.material.id,billentry.material.masterid,billentry.material.masterid.modelnum,billentry.qty,billentry.amount,billentry.unit,billentry.baseunit,billentry.baseqty,billentry.unverifyqty,billentry.actualprice,billentry.mversion,billentry.auxpty,billentry.configuredcode,billentry.tracknumber";
        String orderBy = "billno,biztime,billentry.material";
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"manual_querypur", (String)entity, (String)selector, (QFilter[])purFilter.toArray(), (String)orderBy);
        DataSet multUnitDataSet = QueryServiceHelper.queryDataSet((String)"getmultimeasureunit", (String)"bd_multimeasureunit", (String)"materialid.id,measureunitid.id,denominator,numerator", (QFilter[])new QFilter[]{new QFilter("converttype", "=", (Object)"1")}, null);
        finDataSet = finDataSet.join(multUnitDataSet, JoinType.LEFT).on("billentry.material.masterid", "materialid.id").on("billentry.unit", "measureunitid.id").select(new String[]{"id", "billno", "biztime", "settlecurrency", "exchangerate", "currency", "billentry.id", "billentry.material.masterid", "billentry.material.masterid.modelnum", "billentry.qty", "billentry.amount", "billentry.unit", "billentry.baseunit", "billentry.baseqty", "billentry.unverifyqty", "billentry.actualprice", "billentry.mversion", "billentry.auxpty", "billentry.configuredcode", "billentry.tracknumber"}, new String[]{"1.0*numerator/denominator unitrate"}).finish();
        ArrayList<EntryRowVO> entryRowList = new ArrayList<EntryRowVO>(2);
        for (Row row : finDataSet) {
            BigDecimal unverifyQuantity = row.getBigDecimal("billentry.unverifyqty");
            BigDecimal convertrate = row.getBigDecimal("unitrate");
            if (convertrate == null) {
                convertrate = BigDecimal.ONE;
            }
            BigDecimal price = row.getBigDecimal("billentry.actualprice");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
            paramMap.put("id", row.getLong("id"));
            paramMap.put("entryid", row.getLong("billentry.id"));
            paramMap.put("billno", row.get("billno"));
            paramMap.put("currency", row.get("settlecurrency"));
            paramMap.put("bizdate", row.get("biztime"));
            paramMap.put("price", price);
            paramMap.put("curVerifyAmt", price.multiply(unverifyQuantity));
            paramMap.put("material", row.get("billentry.material.masterid"));
            paramMap.put("convertrate", convertrate);
            paramMap.put("measureunit", row.get("billentry.unit"));
            paramMap.put("baseunit", row.get("billentry.baseunit"));
            paramMap.put("curverifyqty", unverifyQuantity);
            paramMap.put("quotation", "0");
            paramMap.put("exchangerate", row.get("exchangerate"));
            paramMap.put("basecurrency", row.get("currency"));
            paramMap.put("materialversion", row.get("billentry.mversion"));
            paramMap.put("modelnum", row.get("billentry.material.masterid.modelnum"));
            paramMap.put("assistantattr", row.get("billentry.auxpty"));
            paramMap.put("configuredcode", row.get("billentry.configuredcode"));
            paramMap.put("tracknumber", row.get("billentry.tracknumber"));
            EntryRowVO entryRow = new EntryRowVO();
            entryRow.setParamMap(paramMap);
            entryRowList.add(entryRow);
        }
        return entryRowList;
    }
}

