/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.upgrade.ISplit;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSplitHandle
implements ISplit {
    private static final Log logger = LogFactory.getLog(AbstractSplitHandle.class);
    protected static final int DATA_LIMIT = 10000;
    protected DBRoute dbRoute;
    protected String sql;
    protected Object[] params;

    public AbstractSplitHandle() {
    }

    public AbstractSplitHandle(DBRoute dbRoute, String sql) {
        this.initialize(dbRoute, sql, null);
    }

    public AbstractSplitHandle(DBRoute dbRoute, String sql, Object[] params) {
        this.initialize(dbRoute, sql, params);
    }

    private void initialize(DBRoute dbRoute, String sql, Object[] params) {
        this.dbRoute = dbRoute;
        this.sql = sql;
        this.params = params;
    }

    @Override
    public Map<String, Object> execute() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (this.dbRoute == null || this.sql == null) {
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"dbRoute\u6216sql\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractSplitHandle_0", (String)"fi-arapcommon", (Object[])new Object[0])), new Object[0]);
        }
        String fromClause = StringUtils.substring((String)this.sql, (int)this.sql.toLowerCase().lastIndexOf("from"));
        String pkFieldName = this.getPkFieldName();
        String pkSql = "select " + pkFieldName + " " + fromClause;
        ArrayList<Long> pks = new ArrayList<Long>(64);
        try (DataSet pkDataSet = DB.queryDataSet((String)"getPkSql", (DBRoute)this.dbRoute, (String)pkSql, (Object[])this.params);){
            for (Row row : pkDataSet) {
                pks.add(row.getLong(pkFieldName));
            }
        }
        int total = pks.size();
        logger.info("---upgrade.total = " + total);
        int upgradeCnt = this.getUpgradeCnt();
        if (upgradeCnt > 0 && total > upgradeCnt) {
            total = upgradeCnt;
        }
        String noWhereSql = StringUtils.substring((String)this.sql, (int)0, (int)this.sql.toLowerCase().lastIndexOf("where"));
        int sumCnt = 0;
        for (int i = 0; i < total; i += 10000) {
            if (i % 10000 != 0) continue;
            List subPks = null;
            if (i % 10000 == 0) {
                subPks = i < total - 10000 ? pks.subList(i, i + 10000) : pks.subList(i, total);
            }
            StringBuilder sql = new StringBuilder(noWhereSql);
            sql.append(" where ").append(pkFieldName).append(" in ( ").append(StringUtils.join(subPks, (String)",")).append(')');
            DataSet subDataSet = DB.queryDataSet((String)"getSubData", (DBRoute)this.dbRoute, (String)sql.toString());
            int exeCnt = 0;
            if (subPks != null && subPks.size() != 0) {
                Map<String, Object> subResult = this.doProcess(subDataSet);
                exeCnt = (Integer)subResult.get("exeCnt");
                logger.info("---currentUpgrade.subCnt = " + subPks.size() + ", exeCnt = " + exeCnt);
            }
            sumCnt += exeCnt;
        }
        String message = String.format(ResManager.loadKDString((String)"\u5171\u9700\u5347\u7ea7 %1$s \u6761\uff0c\u672c\u6b21\u5347\u7ea7\u6210\u529f  %2$s \u6761\u3002", (String)"AbstractSplitHandle_1", (String)"fi-arapcommon", (Object[])new Object[0]), total, sumCnt);
        result.put("total", total);
        result.put("exeCnt", sumCnt);
        result.put("message", message);
        logger.info("---upgrade.result=" + SerializationUtils.toJsonString(result));
        return result;
    }

    protected int getUpgradeCnt() {
        return 0;
    }

    protected String getPkFieldName() {
        return "fid";
    }

    protected abstract Map<String, Object> doProcess(DataSet var1);
}

