/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.fi.arapcommon.report.SingleValAggFunction;
import kd.fi.arapcommon.report.SumParam;

public class DataSetUtils {
    public static DataSet totalSum(DataSet rawDataSet, List<String> summaryFields) {
        rawDataSet = rawDataSet.addField("1", "israwrow").addField("0", "sumlevel");
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        sumParam.addGroupByField("israwrow");
        sumParam.setSummaryFields(summaryFields);
        DataSet sum = DataSetUtils.sum(rawDataSet, sumParam);
        return rawDataSet.union(sum).orderBy(sumParam.getGroupByFields().toArray(new String[0]));
    }

    public static DataSet sum(DataSet rawDataSet, SumParam sumParam, boolean autoUnion) {
        if (SumParam.SumType.TOTAL == sumParam.getSumType()) {
            rawDataSet = rawDataSet.addField("1", "israwrow");
            sumParam.setGroupByFields(Collections.singletonList("israwrow"));
        }
        if (autoUnion) {
            rawDataSet = rawDataSet.addField("0", "sumlevel");
        }
        DataSet sum = DataSetUtils.sum(rawDataSet, sumParam);
        if (SumParam.SumType.TOTAL == sumParam.getSumType()) {
            sum = sum.removeFields(new String[]{"israwrow"});
        }
        if (autoUnion) {
            return rawDataSet.union(sum);
        }
        return sum;
    }

    public static DataSet sum(DataSet rawDataSet, SumParam sumParam, SumParam totalSumParam) {
        rawDataSet = rawDataSet.addField("1", "israwrow").addField("0", "sumlevel");
        totalSumParam.setGroupByFields(Collections.singletonList("israwrow"));
        DataSet sum = DataSetUtils.sum(rawDataSet, sumParam);
        DataSet totalSum = DataSetUtils.sum(rawDataSet, totalSumParam);
        return rawDataSet.union(sum).union(totalSum);
    }

    public static DataSet sum(DataSet rawDataSet, List<SumParam> sumParams) {
        DataSet result = rawDataSet;
        DataSet statisticalDataSet = rawDataSet;
        for (SumParam sumParam : sumParams) {
            if (sumParam == null) continue;
            DataSet sum = DataSetUtils.sum(statisticalDataSet, sumParam);
            if (sumParam.getSumType() == SumParam.SumType.RAW) {
                statisticalDataSet = sum;
            }
            if (result != null) {
                result = result.union(sum).orderBy(sumParam.getGroupByFields().toArray(new String[0]));
                continue;
            }
            result = sum;
        }
        return result;
    }

    public static DataSet sum(DataSet rawDataSet, SumParam sumParam) {
        Field[] fields;
        List<String> groupByFields = sumParam.getGroupByFields();
        List<String> summaryFields = sumParam.getSummaryFields();
        GroupbyDataSet groupbyDataSet = rawDataSet.groupBy(groupByFields.toArray(new String[0]));
        for (String sumField : summaryFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        DataSet finish = groupbyDataSet.finish();
        finish = finish.addField(String.valueOf(sumParam.getSumLevel()), "sumlevel");
        if (sumParam.getSumType() == SumParam.SumType.RAW) {
            return finish;
        }
        LinkedList<String> selectFields = new LinkedList<String>();
        for (Field f : fields = rawDataSet.getRowMeta().getFields()) {
            if (groupByFields.contains(f.getName()) || summaryFields.contains(f.getName()) || "sumlevel".equals(f.getName())) {
                selectFields.add(f.getName());
                continue;
            }
            selectFields.add("NULL as " + f.getName());
        }
        if (!selectFields.contains("sumlevel")) {
            selectFields.add("sumlevel");
        }
        return finish.select(String.join((CharSequence)",", selectFields));
    }

    public static DataSet sumAndSelectField(DataSet rawDataSet, List<SumParam> sumParams) {
        DataSet result = rawDataSet;
        DataSet statisticalDataSet = rawDataSet;
        for (SumParam sumParam : sumParams) {
            if (sumParam == null) continue;
            DataSet sum = DataSetUtils.sumAndSelectField(statisticalDataSet, sumParam);
            if (sumParam.getSumType() == SumParam.SumType.RAW) {
                statisticalDataSet = sum;
            }
            if (result != null) {
                result = result.union(sum).orderBy(sumParam.getGroupByFields().toArray(new String[0]));
                continue;
            }
            result = sum;
        }
        return result;
    }

    public static DataSet sumAndSelectField(DataSet rawDataSet, SumParam sumParam) {
        Field[] fields;
        List<String> groupByFields = sumParam.getGroupByFields();
        List<String> summaryFields = sumParam.getSummaryFields();
        GroupbyDataSet groupbyDataSet = rawDataSet.groupBy(groupByFields.toArray(new String[0]));
        for (String sumField : summaryFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        ArrayList<String> ignoreFields = new ArrayList<String>();
        ignoreFields.addAll(groupByFields);
        ignoreFields.addAll(summaryFields);
        List<String> selectedFields = DataSetUtils.getSelectedFields(rawDataSet, ignoreFields.toArray(new String[0]));
        for (String field : selectedFields) {
            groupbyDataSet.agg(new SingleValAggFunction((DataType)DataType.AnyType), field, field);
        }
        DataSet finish = groupbyDataSet.finish();
        finish = finish.addField(String.valueOf(sumParam.getSumLevel()), "sumlevel");
        if (sumParam.getSumType() == SumParam.SumType.RAW) {
            return finish;
        }
        LinkedList<String> selectFields = new LinkedList<String>();
        for (Field f : fields = rawDataSet.getRowMeta().getFields()) {
            if (groupByFields.contains(f.getName()) || summaryFields.contains(f.getName()) || "sumlevel".equals(f.getName())) {
                selectFields.add(f.getName());
                continue;
            }
            selectFields.add("NULL as " + f.getName());
        }
        if (!selectFields.contains("sumlevel")) {
            selectFields.add("sumlevel");
        }
        return finish.select(String.join((CharSequence)",", selectFields));
    }

    public static DataSet union(DataSet ds1, DataSet ds2) {
        List<String> fields2;
        List<String> fields1 = DataSetUtils.getSelectedFields(ds1, new String[0]);
        if (fields1.containsAll(fields2 = DataSetUtils.getSelectedFields(ds2, new String[0]))) {
            ds2 = ds2.select(fields1.toArray(new String[0]));
        }
        return ds1.union(ds2);
    }

    public static List<String> getSelectedFields(DataSet dataSet, String ... ignoreFields) {
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<String> leftSelectedFields = new ArrayList<String>();
        for (Field f : fields) {
            boolean ignore = false;
            if (ignoreFields.length > 0) {
                for (String ignoreField : ignoreFields) {
                    if (!f.getName().equalsIgnoreCase(ignoreField)) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            leftSelectedFields.add(f.getName());
        }
        return leftSelectedFields;
    }

    public static StringBuffer formatDataSet(String title, DataSet ds) {
        StringBuffer sb = new StringBuffer();
        if (title != null) {
            sb.append(title).append('\n');
        }
        int cols = ds.getRowMeta().getFieldCount();
        for (int i = 0; i < cols; ++i) {
            sb.append(ds.getRowMeta().getFieldAlias(i)).append('\t');
        }
        sb.append('\n');
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                Object obj = row.get(i);
                sb.append(obj).append('\t');
            }
            sb.append('\n');
        }
        return sb;
    }
}

