/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public abstract class AbsVerifyLiquidationValidator
extends AbstractValidator {
    public void validate() {
        Long sourceEntryId;
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getBillEntity());
        HashSet<Long> sourceEntryIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal amount = entryInfo.getBigDecimal("amount");
                BigDecimal unsettleamt = entryInfo.getBigDecimal("unsettleamt");
                String amountName = entityType.findProperty("amount").getDisplayName().getLocaleValue();
                if (amount.compareTo(BigDecimal.ZERO) > 0) {
                    if (unsettleamt.compareTo(BigDecimal.ZERO) < 0 || unsettleamt.compareTo(amount) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u6e05\u7406\u91d1\u989d\u5e94>0\u5e76\u4e14\u2264%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbsVerifyLiquidationValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), entryInfo.getInt("seq"), amountName));
                    }
                } else if (amount.compareTo(BigDecimal.ZERO) < 0 && (unsettleamt.compareTo(BigDecimal.ZERO) > 0 || unsettleamt.compareTo(amount) < 0)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u6e05\u7406\u91d1\u989d\u5e94<0\u5e76\u4e14\u2265%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbsVerifyLiquidationValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), entryInfo.getInt("seq"), amountName));
                }
                sourceEntryId = entryInfo.getLong("sourceentryid");
                sourceEntryIds.add(sourceEntryId);
            }
        }
        if (sourceEntryIds.size() > 0) {
            QFilter filter = new QFilter("entryentity.sourceentryid", "in", sourceEntryIds);
            filter.and(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
            DynamicObjectCollection billCol = QueryServiceHelper.query((String)this.getBillEntity(), (String)"entryentity.sourceentryid", (QFilter[])new QFilter[]{filter});
            List existsList = billCol.stream().map(billInfo -> billInfo.getLong("entryentity.sourceentryid")).collect(Collectors.toList());
            if (existsList.size() > 0) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject info = dataEntity.getDataEntity();
                    DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryInfo : entryCol) {
                        sourceEntryId = entryInfo.getLong("sourceentryid");
                        if (!existsList.contains(sourceEntryId)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u5df2\u5b58\u5728\u672a\u6e05\u9879\u6e05\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AbsVerifyLiquidationValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{entryInfo.getInt("seq")}));
                    }
                }
            }
        }
    }

    protected abstract String getBillEntity();
}

