/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StdConfig;

public class AllEntriesIsDrawValidator
extends AbstractExecControlValidator {
    private static final Log logger = LogFactory.getLog(AllEntriesIsDrawValidator.class);
    private Set<String> settingParameter;
    private Map<String, String> entryNameMap = new HashMap<String, String>(8);
    private Map<String, String> planEntryNameMap = new HashMap<String, String>(8);

    public AllEntriesIsDrawValidator() {
        this.initEntryNameMap();
    }

    public void validate() {
        long time = System.currentTimeMillis();
        Set<DynamicObject> needCheckEntrylkDatas = this.prepareDatas();
        Set<Long> problemDataIds = this.getProblemDataIds(needCheckEntrylkDatas);
        this.buildErrorMessage(problemDataIds);
        logger.info("-- \u68c0\u67e5\u5206\u5f55\u662f\u5426\u4e0b\u63a8\u8017\u65f6 --" + (System.currentTimeMillis() - time) + "ms");
    }

    private void initEntryNameMap() {
        this.entryNameMap.put("ap_finapbill", "detailentry");
        this.entryNameMap.put("ar_finarbill", "entry");
        this.entryNameMap.put("ap_busbill", "entry");
        this.entryNameMap.put("ar_busbill", "entry");
        this.entryNameMap.put("ap_invoice", "entry");
        this.entryNameMap.put("ar_invoice", "entry");
        this.entryNameMap.put("ap_payapply", "entry");
        this.entryNameMap.put("ar_revcfmbill", "entry");
        this.entryNameMap.put("ap_liquidation", "entryentity");
        this.entryNameMap.put("ar_liquidation", "entryentity");
        this.entryNameMap.put("ar_baddebtlossbill", "entry");
        this.planEntryNameMap.put("ap_finapbill", "planentity");
        this.planEntryNameMap.put("ar_finarbill", "planentity");
        this.planEntryNameMap.put("ap_busbill", "planentity");
        this.planEntryNameMap.put("ar_busbill", "planentity");
        this.planEntryNameMap.put("ar_baddebtlossbill", "planentry");
    }

    protected Set<DynamicObject> prepareDatas() {
        HashSet<DynamicObject> needCheckEntrylkDatas = new HashSet<DynamicObject>(this.dataEntities.length);
        String validatorKey = StdConfig.get("AllEntriesIsDrawValidator");
        if ("false".equals(validatorKey)) {
            return needCheckEntrylkDatas;
        }
        this.settingParameter = this.notParticipateInValidatorParameter();
        boolean isSettingParameterNull = EmptyUtils.isEmpty(this.settingParameter);
        boolean isLiquidation = "ar_liquidation".equals(this.entityKey) || "ap_liquidation".equals(this.entityKey);
        boolean isFin = "ar_finarbill".equals(this.entityKey) || "ap_finapbill".equals(this.entityKey);
        boolean isBus = "ar_busbill".equals(this.entityKey) || "ap_busbill".equals(this.entityKey);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            if (isFin && "save".equals(this.getOperateKey()) && !data.getBoolean("iswrittenoff") || isBus && "save".equals(this.getOperateKey()) && !data.getBoolean("isselfwoff")) continue;
            if (!isLiquidation) {
                String sourcebilltype = data.getString("sourcebilltype");
                if (!isSettingParameterNull && this.settingParameter.contains("all") || this.settingParameter.contains(sourcebilltype)) {
                    continue;
                }
            } else if (!isSettingParameterNull) break;
            needCheckEntrylkDatas.add(data);
        }
        return needCheckEntrylkDatas;
    }

    private Set<String> notParticipateInValidatorParameter() {
        HashSet<String> billType = new HashSet<String>(8);
        String settingParameter = SettingMapperHelper.getValueFromCache("associatedLineValidate", this.entityKey + "_Validator");
        if (EmptyUtils.isEmpty(settingParameter)) {
            return billType;
        }
        String[] params = settingParameter.split(",");
        billType = new HashSet<String>(Arrays.asList(params));
        return billType;
    }

    protected Set<Long> getProblemDataIds(Set<DynamicObject> needCheckEntrylkDatas) {
        Set<Long> problemDataIds = new HashSet<Long>(needCheckEntrylkDatas.size());
        if (EmptyUtils.isNotEmpty(needCheckEntrylkDatas)) {
            String entryName = this.entryNameMap.get(this.entityKey);
            if (entryName != null) {
                problemDataIds = this.circleAndJudgeEntry(needCheckEntrylkDatas, entryName);
            }
            if ("ar_baddebtlossbill".equals(this.entityKey) && EmptyUtils.isEmpty(problemDataIds)) {
                logger.info("-- \u574f\u8d26\u635f\u5931\u5355\u68c0\u67e5\u8ba1\u5212\u884c\u5206\u5f55 --");
                problemDataIds = this.circleAndJudgeEntry(needCheckEntrylkDatas, this.planEntryNameMap.get(this.entityKey));
            }
        }
        return problemDataIds;
    }

    private Set<Long> circleAndJudgeEntry(Set<DynamicObject> needCheckEntrylkDatas, String entryName) {
        HashSet<Long> problemDataIds = new HashSet<Long>(needCheckEntrylkDatas.size());
        boolean isFirstTime = true;
        boolean isEixstProperty = true;
        block0: for (DynamicObject checkData : needCheckEntrylkDatas) {
            DynamicObjectCollection entry = checkData.getDynamicObjectCollection(entryName);
            String entryLkParam = entryName + "_lk";
            Boolean errorKey = null;
            if (!isEixstProperty) break;
            for (DynamicObject row : entry) {
                Boolean guard;
                if (isFirstTime) {
                    isFirstTime = false;
                    isEixstProperty = EntityMetadataUtils.containsProperty(row.getDataEntityType(), entryLkParam);
                    if (!isEixstProperty) continue block0;
                }
                DynamicObjectCollection entryLk = row.getDynamicObjectCollection(entryLkParam);
                Boolean bl = guard = EmptyUtils.isNotEmpty(errorKey) ? errorKey : Boolean.valueOf(EmptyUtils.isNotEmpty(entryLk));
                errorKey = EmptyUtils.isNotEmpty(entryLk);
                if (errorKey.equals(guard)) continue;
                problemDataIds.add(checkData.getLong("id"));
                continue block0;
            }
        }
        return problemDataIds;
    }

    protected void buildErrorMessage(Set<Long> problemDataIds) {
        if (EmptyUtils.isEmpty(problemDataIds)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!problemDataIds.contains(data.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u975e\u5173\u8054\u751f\u6210\u7684\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllEntriesIsDrawValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{data.getString("billno")}));
        }
    }

    @Override
    public Set<String> preparePropertys() {
        return new HashSet<String>(2);
    }
}

