/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.vo.LineTypeInfo;

public class BillSubmit4LineTypeValidator
extends AbstractValidator {
    private List<LineTypeInfo> lineTypeInfos;

    public BillSubmit4LineTypeValidator(List<LineTypeInfo> lineTypeInfos) {
        this.lineTypeInfos = lineTypeInfos;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Boolean> paramCache = new HashMap<Long, Boolean>(8);
        HashMap map = new HashMap(16);
        for (ExtendedDataEntity data : datas) {
            Boolean param;
            DynamicObject bill = data.getDataEntity();
            String billEntityKey = bill.getDataEntityType().getName();
            DynamicObject org = bill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            long orgId = org.getLong("id");
            if (!ObjectUtils.isEmpty(paramCache) && paramCache.get(orgId) != null) {
                param = (Boolean)paramCache.get(orgId);
            } else {
                param = LineTypeHelper.getParam(orgId, !billEntityKey.startsWith("ap_"));
                paramCache.put(orgId, param);
            }
            if (!param.booleanValue()) continue;
            long billTypeId = bill.getLong(this.getBillTypeFieldKey(billEntityKey) + ".id");
            HashMap<Long, Long> f7Map = (HashMap<Long, Long>)map.get(billTypeId);
            if (f7Map == null) {
                long bizTypeId = LineTypeHelper.getDefaultBizTypeId(billTypeId);
                long lineTypeId = LineTypeHelper.getDefaultLineTypeId(bizTypeId);
                f7Map = new HashMap<Long, Long>(1);
                map.put(billTypeId, f7Map);
                f7Map.put(bizTypeId, lineTypeId);
            }
            LineTypeInfo info = new LineTypeInfo();
            info.setBillTypeId(billTypeId);
            block1: for (Map.Entry entry : f7Map.entrySet()) {
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (bizType == null && (Long)entry.getKey() == 0L) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5355\u636e\u3002", (String)"BillSubmit4LineTypeValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                info.setBizTypeId((Long)entry.getKey());
                DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.getDetailEntryKey(billEntityKey));
                for (DynamicObject row : detailEntry) {
                    DynamicObject lineType = row.getDynamicObject("linetype");
                    if (lineType == null && (Long)entry.getValue() == 0L) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u884c\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5355\u636e\u3002", (String)"BillSubmit4LineTypeValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue block1;
                    }
                    info.setLineTypeId((Long)entry.getValue());
                }
            }
            this.lineTypeInfos.add(info);
        }
    }

    private String getBillTypeFieldKey(String billEntityKey) {
        return "ap_finapbill".equals(billEntityKey) ? "billtypeid" : "billtype";
    }

    private String getDetailEntryKey(String billEntityKey) {
        return "ap_finapbill".equals(billEntityKey) ? "detailentry" : "entry";
    }
}

